/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.fml.server.FMLServerHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import minechem.MinechemItemsRegistration;
import minechem.item.element.Element;
import minechem.item.element.ElementItem;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeItem;
import minechem.potion.PotionChemical;
import minechem.utils.Compare;
import minechem.utils.Position;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class MinechemHelper {
    public static Random random = new Random();

    public static int getSplitStringHeight(FontRenderer fontRenderer, String string, int width) {
        List stringRows = fontRenderer.func_78271_c(string, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static float translateValue(float value, float leftMin, float leftMax, float rightMin, float rightMax) {
        float leftRange = leftMax - leftMin;
        float rightRange = rightMax - rightMin;
        float valueScaled = (value - leftMin) / leftRange;
        return rightMin + valueScaled * rightRange;
    }

    public static String getLocalString(String key) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            String localString = StatCollector.func_74838_a((String)key);
            if (localString.equals("")) {
                return key;
            }
            localString = MinechemHelper.capitalizeFully(localString.replaceAll("molecule\\.", ""));
            return localString;
        }
        return key;
    }

    public static String capitalizeFully(String input) {
        String[] splitString = input.split(" ");
        String result = "";
        for (int i = 0; i < splitString.length; ++i) {
            char[] digit = splitString[i].toCharArray();
            digit[0] = Character.toUpperCase(digit[0]);
            for (int j = 1; j < digit.length; ++j) {
                digit[j] = Character.toLowerCase(digit[j]);
            }
            result = result + new String(digit) + (i < splitString.length - 1 ? " " : "");
        }
        return result;
    }

    public static NBTTagList writeItemStackArrayToTagList(ItemStack[] itemstacks) {
        NBTTagList taglist = new NBTTagList();
        for (int slot = 0; slot < itemstacks.length; ++slot) {
            ItemStack itemstack = itemstacks[slot];
            if (itemstack == null) continue;
            NBTTagCompound itemstackCompound = new NBTTagCompound();
            itemstackCompound.func_74774_a("slot", (byte)slot);
            itemstack.func_77955_b(itemstackCompound);
            taglist.func_74742_a((NBTBase)itemstackCompound);
        }
        return taglist;
    }

    public static ItemStack[] readTagListToItemStackArray(NBTTagList taglist, ItemStack[] itemstacks) {
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound itemstackCompound = taglist.func_150305_b(i);
            byte slot = itemstackCompound.func_74771_c("slot");
            itemstacks[slot] = ItemStack.func_77949_a((NBTTagCompound)itemstackCompound);
        }
        return itemstacks;
    }

    public static NBTTagList writeItemStackListToTagList(ArrayList<ItemStack> list) {
        NBTTagList taglist = new NBTTagList();
        for (ItemStack itemstack : list) {
            NBTTagCompound itemstackCompound = new NBTTagCompound();
            itemstack.func_77955_b(itemstackCompound);
            taglist.func_74742_a((NBTBase)itemstackCompound);
        }
        return taglist;
    }

    public static ArrayList<ItemStack> readTagListToItemStackList(NBTTagList taglist) {
        ArrayList<ItemStack> itemlist = new ArrayList<ItemStack>();
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound itemstackCompound = taglist.func_150305_b(i);
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)itemstackCompound);
            itemlist.add(itemstack);
        }
        return itemlist;
    }

    public static ArrayList<ItemStack> convertChemicalsIntoItemStacks(ArrayList<PotionChemical> potionChemicals) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (potionChemicals == null) {
            return stacks;
        }
        for (PotionChemical potionChemical : potionChemicals) {
            if (potionChemical instanceof Element) {
                stacks.add(new ItemStack((Item)MinechemItemsRegistration.element, potionChemical.amount, ((Element)potionChemical).element.ordinal()));
                continue;
            }
            if (!(potionChemical instanceof Molecule)) continue;
            stacks.add(new ItemStack((Item)MinechemItemsRegistration.molecule, potionChemical.amount, ((Molecule)potionChemical).molecule.id()));
        }
        return stacks;
    }

    public static List<ItemStack> pushTogetherStacks(List<ItemStack> stacks) {
        block0: for (int i = stacks.size() - 1; i >= 0; --i) {
            if (stacks.get(i) == null) continue;
            for (int j = 0; j < i; ++j) {
                if (stacks.get(j) == null) {
                    stacks.set(j, stacks.get(i));
                    stacks.set(j, null);
                    continue block0;
                }
                if (!stacks.get(j).func_77969_a(stacks.get(i))) continue;
                stacks.get((int)j).field_77994_a += stacks.get((int)i).field_77994_a;
                stacks.set(i, null);
                continue block0;
            }
        }
        stacks.removeAll(Collections.singleton(null));
        return stacks;
    }

    public static ItemStack[] convertChemicalArrayIntoItemStackArray(PotionChemical[] chemicals) {
        if (chemicals == null) {
            return null;
        }
        ItemStack[] stacks = new ItemStack[chemicals.length];
        for (int i = 0; i < chemicals.length; ++i) {
            PotionChemical potionChemical = chemicals[i];
            if (potionChemical instanceof Element) {
                stacks[i] = new ItemStack((Item)MinechemItemsRegistration.element, potionChemical.amount, ((Element)potionChemical).element.ordinal());
                continue;
            }
            if (!(potionChemical instanceof Molecule)) continue;
            stacks[i] = new ItemStack((Item)MinechemItemsRegistration.molecule, potionChemical.amount, ((Molecule)potionChemical).molecule.id());
        }
        return stacks;
    }

    public static ArrayList<PotionChemical> pushTogetherChemicals(ArrayList<PotionChemical> list) {
        block0: for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) == null) continue;
            for (int j = 0; j < i; ++j) {
                if (list.get(j) == null) {
                    list.set(j, list.get(i));
                    list.set(j, null);
                    continue block0;
                }
                if (!list.get(j).sameAs(list.get(i))) continue;
                list.get((int)j).amount += list.get((int)i).amount;
                list.set(i, null);
                continue block0;
            }
        }
        list.removeAll(Collections.singleton(null));
        return list;
    }

    public static boolean itemStackMatchesChemical(ItemStack itemstack, PotionChemical potionChemical) {
        return MinechemHelper.itemStackMatchesChemical(itemstack, potionChemical, 1);
    }

    public static boolean itemStackMatchesChemical(ItemStack itemstack, PotionChemical potionChemical, int factor) {
        if (potionChemical instanceof Element && itemstack.func_77973_b() == MinechemItemsRegistration.element) {
            Element element = (Element)potionChemical;
            return itemstack.func_77960_j() == element.element.ordinal() && itemstack.field_77994_a >= element.amount * factor;
        }
        if (potionChemical instanceof Molecule && itemstack.func_77973_b() == MinechemItemsRegistration.molecule) {
            Molecule molecule = (Molecule)potionChemical;
            return itemstack.func_77960_j() == molecule.molecule.id() && itemstack.field_77994_a >= molecule.amount * factor;
        }
        return false;
    }

    public static ForgeDirection getDirectionFromFacing(int facing) {
        switch (facing) {
            case 0: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return null;
    }

    public static void ejectItemStackIntoWorld(ItemStack itemstack, World world, int x, int y, int z) {
        float randomX = random.nextFloat() * 0.8f + 0.1f;
        float randomY = random.nextFloat() * 0.8f + 0.1f;
        float randomZ = random.nextFloat() * 0.8f + 0.1f;
        while (itemstack.field_77994_a > 0) {
            int randomN = random.nextInt(21) + 10;
            if (randomN > itemstack.field_77994_a) {
                randomN = itemstack.field_77994_a;
            }
            itemstack.field_77994_a -= randomN;
            new EntityItem(world, (double)((float)x + randomX), (double)((float)y + randomY), (double)((float)z + randomZ), new ItemStack(itemstack.func_77973_b(), randomN, itemstack.func_77960_j()));
        }
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            Position pos = new Position(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e);
            IInventory chest2 = null;
            TileEntity tile = MinechemHelper.getTile(chest.func_145831_w(), pos, ForgeDirection.WEST);
            if (tile instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if ((tile = MinechemHelper.getTile(chest.func_145831_w(), pos, ForgeDirection.EAST)) instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if ((tile = MinechemHelper.getTile(chest.func_145831_w(), pos, ForgeDirection.NORTH)) instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if ((tile = MinechemHelper.getTile(chest.func_145831_w(), pos, ForgeDirection.SOUTH)) instanceof TileEntityChest) {
                chest2 = (IInventory)tile;
            }
            if (chest2 != null) {
                return new InventoryLargeChest("", inv, chest2);
            }
        }
        return inv;
    }

    public static TileEntity getTile(World world, Position pos, ForgeDirection dir) {
        Position tmp = new Position(pos);
        tmp.orientation = dir;
        tmp.moveForwards(1.0);
        return world.func_147438_o((int)tmp.x, (int)tmp.y, (int)tmp.z);
    }

    @SideOnly(value=Side.SERVER)
    public static WorldServer getDimension(int dimensionID) {
        WorldServer[] worlds;
        for (WorldServer world : worlds = FMLServerHandler.instance().getServer().field_71305_c) {
            if (world.field_73011_w.field_76574_g != dimensionID) continue;
            return world;
        }
        return null;
    }

    public static String getChemicalName(PotionChemical potionChemical) {
        if (potionChemical instanceof Element) {
            return MinechemHelper.getLocalString(((Element)potionChemical).element.name());
        }
        return MinechemHelper.getLocalString(((Molecule)potionChemical).molecule.name());
    }

    public static ItemStack chemicalToItemStack(PotionChemical potionChemical, int amount) {
        if (potionChemical instanceof Element) {
            return new ItemStack((Item)MinechemItemsRegistration.element, amount, ((Element)potionChemical).element.ordinal());
        }
        if (potionChemical instanceof Molecule) {
            return new ItemStack((Item)MinechemItemsRegistration.molecule, amount, ((Molecule)potionChemical).molecule.id());
        }
        return null;
    }

    public static PotionChemical itemStackToChemical(ItemStack itemstack) {
        if (Compare.isStackAnElement(itemstack)) {
            return new Element(ElementItem.getElement(itemstack), itemstack.field_77994_a);
        }
        if (Compare.isStackAMolecule(itemstack)) {
            return new Molecule(MoleculeItem.getMolecule(itemstack), itemstack.field_77994_a);
        }
        return null;
    }

    public static int getNumberOfDigits(int n) {
        return (int)(Math.log10(n) + 1.0);
    }
}

