/*
 * Decompiled with CFR 0.152.
 */
package minechem.render;

import minechem.fluid.FluidElement;
import minechem.fluid.FluidMolecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.render.RenderingUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class FluidItemRenderingHandler
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_BOBBING: 
            case ENTITY_ROTATION: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Fluid fluid = ((BlockFluidBase)((ItemBlock)item.func_77973_b()).field_150939_a).getFluid();
        if (fluid instanceof FluidElement) {
            RenderingUtil.setColorForElement(((FluidElement)fluid).element);
        } else if (fluid instanceof FluidMolecule) {
            MoleculeEnum molecule = ((FluidMolecule)fluid).molecule;
            GL11.glColor3f((float)molecule.red, (float)molecule.green, (float)molecule.blue);
        }
        IIcon icon = ((ItemBlock)item.func_77973_b()).field_150939_a.func_149733_h(0);
        switch (type) {
            case INVENTORY: {
                RenderingUtil.drawTexturedRectUV(0.0f, 0.0f, 0.0f, 16, 16, icon);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                break;
            }
            case ENTITY: {
                EntityItem entityItem = (EntityItem)data[1];
                if (entityItem.field_70170_p == null) {
                    float angle = (float)(Minecraft.func_71386_F() % 8000L) / 8000.0f * 360.0f;
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.2f, (float)-0.5f, (float)0.0f);
                    this.renderItemAsEntity(item, icon);
                    GL11.glPopMatrix();
                    break;
                }
                this.renderItemAsEntity(item, icon);
                break;
            }
        }
    }

    private void renderItemAsEntity(ItemStack itemStack, IIcon icon) {
        RenderingUtil.drawTextureIn3D(icon);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderingUtil.drawTextureIn3D(icon);
    }
}

