/*
 * Decompiled with CFR 0.152.
 */
package minechem.radiation;

import minechem.MinechemItemsRegistration;
import minechem.item.bucket.MinechemBucketItem;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import minechem.radiation.RadiationEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class RadiationInfo
implements Cloneable {
    public long decayStarted;
    public long lastDecayUpdate;
    public int radiationDamage;
    public int dimensionID;
    public ItemStack itemstack;
    public RadiationEnum radioactivity;

    public RadiationInfo(ItemStack itemstack, long decayStarted, long lastDecayUpdate, int dimensionID, RadiationEnum radioactivity) {
        this.itemstack = itemstack;
        this.decayStarted = decayStarted;
        this.dimensionID = dimensionID;
        this.lastDecayUpdate = lastDecayUpdate;
        this.radioactivity = radioactivity;
    }

    public RadiationInfo(ItemStack itemstack, RadiationEnum radioactivity) {
        this.itemstack = itemstack;
        this.radioactivity = radioactivity;
        this.decayStarted = 0L;
        this.dimensionID = 0;
        this.lastDecayUpdate = 0L;
    }

    public boolean isRadioactive() {
        return this.radioactivity != RadiationEnum.stable;
    }

    public RadiationInfo clone() {
        return new RadiationInfo(this.itemstack.func_77946_l(), this.decayStarted, this.lastDecayUpdate, this.dimensionID, this.radioactivity);
    }

    public static RadiationEnum getRadioactivity(ItemStack itemstack) {
        int id = itemstack.func_77960_j();
        Item item = itemstack.func_77973_b();
        if (item == MinechemItemsRegistration.element) {
            ElementEnum element = ElementEnum.getByID(id);
            return id != 0 && element != null ? element.radioactivity() : RadiationEnum.stable;
        }
        if (item == MinechemItemsRegistration.molecule) {
            if (id >= MoleculeEnum.molecules.size() || MoleculeEnum.molecules.get(id) == null) {
                return RadiationEnum.stable;
            }
            return MoleculeEnum.molecules.get(id).radioactivity();
        }
        if (item instanceof MinechemBucketItem) {
            return ((MinechemBucketItem)item).chemical.radioactivity();
        }
        return RadiationEnum.stable;
    }

    public static void setRadiationInfo(RadiationInfo radiationInfo, ItemStack itemStack) {
        NBTTagCompound stackTag = itemStack.func_77978_p();
        if (stackTag == null) {
            stackTag = new NBTTagCompound();
        }
        stackTag.func_74772_a("lastUpdate", radiationInfo.lastDecayUpdate);
        stackTag.func_74772_a("decayStart", radiationInfo.decayStarted);
        stackTag.func_74768_a("dimensionID", radiationInfo.dimensionID);
        itemStack.func_77982_d(stackTag);
    }
}

