/*
 * Decompiled with CFR 0.152.
 */
package minechem.item.element;

import minechem.item.ChemicalRoomStateEnum;
import minechem.item.element.ElementEnum;
import minechem.item.element.ElementItem;
import minechem.render.FontRendererWithZLevel;
import minechem.render.RenderingUtil;
import minechem.utils.MinechemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ElementItemRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (item.func_77960_j() == 0) {
            return false;
        }
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        switch (helper) {
            case ENTITY_BOBBING: 
            case ENTITY_ROTATION: {
                return true;
            }
        }
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemstack, Object ... data) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        ElementItem item = (ElementItem)itemstack.func_77973_b();
        IIcon testtube = itemstack.func_77954_c();
        IIcon contentsTex = null;
        ElementEnum element = ElementItem.getElement(itemstack);
        float duration = 1500.0f;
        float t = (int)((float)Minecraft.func_71386_F() % duration);
        int frame = (int)MinechemUtil.translateValue(t, 0.0f, duration, 0.0f, 7.0f);
        contentsTex = element.roomState() == ChemicalRoomStateEnum.gas ? item.gas[frame] : (element.roomState() == ChemicalRoomStateEnum.liquid ? item.liquid[frame] : item.solid);
        switch (type) {
            case INVENTORY: {
                this.renderItemInInventory(itemstack, element, testtube, contentsTex);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                this.renderItemInEquipped(itemstack, element, testtube, contentsTex);
                break;
            }
            case ENTITY: {
                EntityItem entityItem = (EntityItem)data[1];
                if (entityItem.field_70170_p == null) {
                    float angle = (float)(Minecraft.func_71386_F() % 8000L) / 8000.0f * 360.0f;
                    GL11.glPushMatrix();
                    GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.2f, (float)-0.5f, (float)0.0f);
                    this.renderItemAsEntity(itemstack, element, testtube, contentsTex);
                    GL11.glPopMatrix();
                    break;
                }
                this.renderItemAsEntity(itemstack, element, testtube, contentsTex);
                break;
            }
        }
    }

    private void renderItemInInventory(ItemStack itemstack, ElementEnum element, IIcon testtube, IIcon contents) {
        String shortName = ElementItem.getShortName(itemstack);
        RenderingUtil.setColorForElement(element);
        RenderingUtil.drawTexturedRectUV(0.0f, 0.0f, 5.0f, 16, 16, contents);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderingUtil.drawTexturedRectUV(0.0f, 0.0f, 5.0f, 16, 16, testtube);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FontRendererWithZLevel fontRenderer = FontRendererWithZLevel.getFontRenderer(16.0f);
        fontRenderer.drawString(shortName, 1, 2, 0);
        fontRenderer.drawString(shortName, 1, 1, 0xEEEEEE);
    }

    private void renderItemInEquipped(ItemStack itemstack, ElementEnum element, IIcon testtube, IIcon contents) {
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderingUtil.setColorForElement(element);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)contents.func_94212_f(), (float)contents.func_94206_g(), (float)contents.func_94209_e(), (float)contents.func_94210_h(), (int)contents.func_94211_a(), (int)contents.func_94216_b(), (float)0.0625f);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer.func_78439_a((Tessellator)tessellator, (float)testtube.func_94212_f(), (float)testtube.func_94206_g(), (float)testtube.func_94209_e(), (float)testtube.func_94210_h(), (int)testtube.func_94211_a(), (int)testtube.func_94216_b(), (float)0.0625f);
    }

    private void renderItemAsEntity(ItemStack itemstack, ElementEnum element, IIcon testtube, IIcon contents) {
        GL11.glPushMatrix();
        RenderingUtil.setColorForElement(element);
        RenderingUtil.drawTextureIn3D(contents);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderingUtil.drawTextureIn3D(testtube);
        GL11.glPopMatrix();
    }
}

