/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.tileentity;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;
import openccsensors.OpenCCSensors;
import openccsensors.api.IGaugeSensor;
import openccsensors.api.IMethodCallback;
import openccsensors.common.util.CallbackEventManager;

public class TileEntityGauge
extends TileEntity
implements IPeripheral {
    private static ArrayList<IGaugeSensor> gaugeSensors = new ArrayList();
    private HashMap tileProperties = new HashMap();
    private CallbackEventManager eventManager = new CallbackEventManager();
    private int percentage = 0;
    private String updatePropertyName = "";
    private int lastBroadcast = 1;

    public static void addGaugeSensor(IGaugeSensor sensor) {
        gaugeSensors.add(sensor);
    }

    public static ArrayList<IGaugeSensor> getGaugeSensors() {
        return gaugeSensors;
    }

    public TileEntityGauge() {
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "getPercentage";
            }

            @Override
            public Object execute(IComputerAccess computer, Object[] arguments) throws Exception {
                return TileEntityGauge.this.getPercentage();
            }
        });
        this.eventManager.registerCallback(new IMethodCallback(){

            @Override
            public String getMethodName() {
                return "setTrackedProperty";
            }

            @Override
            public Object execute(IComputerAccess computer, Object[] arguments) throws Exception {
                TileEntityGauge.this.updatePropertyName = (String)arguments[0];
                return null;
            }
        });
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        this.percentage = nbttagcompound.func_74762_e("percentage");
        this.updatePropertyName = nbttagcompound.func_74779_i("property");
        super.func_145839_a(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("percentage", this.percentage);
        nbttagcompound.func_74778_a("property", this.updatePropertyName);
        super.func_145841_b(nbttagcompound);
    }

    public int getFacing() {
        return this.field_145850_b == null ? 0 : this.func_145832_p();
    }

    public int getPercentage() {
        return this.percentage;
    }

    public String getType() {
        return "gauge";
    }

    public String[] getMethodNames() {
        return this.eventManager.getMethodNames();
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return new Object[]{this.eventManager.queueMethodCall(computer, method, arguments)};
    }

    public void attach(IComputerAccess computer) {
        IMount mount = ComputerCraftAPI.createResourceMount(OpenCCSensors.class, (String)"openccsensors", (String)"openccsensors/mods/OCSLua/lua");
        computer.mount("ocs", mount);
    }

    public void detach(IComputerAccess computer) {
    }

    private HashMap checkForKeys(HashMap data, String[] keys, String prefix) {
        HashMap properties = new HashMap();
        for (Object obj : data.keySet()) {
            Object value = data.get(obj);
            if (value instanceof HashMap) {
                properties.putAll(this.checkForKeys((HashMap)value, keys, prefix + obj.toString()));
                continue;
            }
            if (!(obj instanceof String)) continue;
            for (String property : keys) {
                if (!property.equals(obj)) continue;
                properties.put(prefix + property, value);
            }
        }
        return properties;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.tileProperties.clear();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ForgeDirection infront = ForgeDirection.getOrientation((int)this.getFacing());
            ForgeDirection behind = infront.getOpposite();
            TileEntity behindTile = this.field_145850_b.func_147438_o(this.field_145851_c + behind.offsetX, this.field_145848_d, this.field_145849_e + behind.offsetZ);
            if (behindTile != null) {
                for (IGaugeSensor gaugeSensor : gaugeSensors) {
                    if (!gaugeSensor.isValidTarget(behindTile)) continue;
                    HashMap details = gaugeSensor.getDetails(this.field_145850_b, behindTile, new ChunkCoordinates(behindTile.field_145851_c, behindTile.field_145848_d, behindTile.field_145849_e), true);
                    this.tileProperties.putAll(this.checkForKeys(details, gaugeSensor.getGaugeProperties(), ""));
                }
            }
            this.percentage = 0;
            if (this.tileProperties.size() > 0) {
                if (this.updatePropertyName == "" || !this.tileProperties.containsKey(this.updatePropertyName)) {
                    this.updatePropertyName = "";
                    for (String property : new String[]{"HeatPercentage", "Progress", "StoredPercentage", "InventoryPercentFull"}) {
                        if (this.updatePropertyName != "" || !this.tileProperties.containsKey(property)) continue;
                        this.updatePropertyName = property;
                    }
                    if (this.updatePropertyName == "") {
                        Map.Entry entry = this.tileProperties.entrySet().iterator().next();
                        this.updatePropertyName = (String)entry.getKey();
                    }
                }
                this.percentage = ((Number)this.tileProperties.get(this.updatePropertyName)).intValue();
            }
            if (this.lastBroadcast++ % 10 == 0) {
                this.lastBroadcast = 1;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.eventManager.process();
        }
    }

    public boolean equals(IPeripheral other) {
        return false;
    }
}

