/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.sensor;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import openccsensors.api.IRequiresIconLoading;
import openccsensors.api.ISensor;
import openccsensors.api.ISensorTier;

public class SonicSensor
implements ISensor,
IRequiresIconLoading {
    private IIcon icon;
    private static final int BASE_RANGE = 1;

    @Override
    public HashMap getDetails(World world, Object obj, ChunkCoordinates sensorPos, boolean additional) {
        Vec3 target = (Vec3)obj;
        int x = (int)target.field_72450_a;
        int y = (int)target.field_72448_b;
        int z = (int)target.field_72449_c;
        Block block = world.func_147439_a(x, y, z);
        HashMap<String, Object> response = new HashMap<String, Object>();
        String type = "UNKNOWN";
        if (block != null && block.func_149688_o() != null) {
            if (block.func_149688_o().func_76224_d()) {
                type = "LIQUID";
            } else if (block.func_149688_o().func_76220_a()) {
                type = "SOLID";
            }
        }
        response.put("Type", type);
        HashMap<String, Integer> position = new HashMap<String, Integer>();
        position.put("X", x - sensorPos.field_71574_a);
        position.put("Y", y - sensorPos.field_71572_b);
        position.put("Z", z - sensorPos.field_71573_c);
        response.put("Position", position);
        return response;
    }

    @Override
    public HashMap getTargets(World world, ChunkCoordinates location, ISensorTier tier) {
        HashMap<String, Vec3> targets = new HashMap<String, Vec3>();
        int range = new Double(tier.getMultiplier()).intValue() + 1;
        int sx = location.field_71574_a;
        int sy = location.field_71572_b;
        int sz = location.field_71573_c;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && y == 0 && z == 0 || !world.func_72899_e(sx + x, sy + y, sz + z)) continue;
                    int bX = sx + x;
                    int bY = sy + y;
                    int bZ = sz + z;
                    Block block = world.func_147439_a(bX, bY, bZ);
                    if (world.func_147437_c(bX, bY, bZ) || block == null) continue;
                    Vec3 targetPos = Vec3.func_72443_a((double)bX, (double)bY, (double)bZ);
                    if (!(Vec3.func_72443_a((double)location.field_71574_a, (double)location.field_71572_b, (double)location.field_71573_c).func_72438_d(targetPos) <= (double)range)) continue;
                    targets.put(String.format("%s,%s,%s", x, y, z), targetPos);
                }
            }
        }
        return targets;
    }

    @Override
    public String[] getCustomMethods(ISensorTier tier) {
        return null;
    }

    @Override
    public Object callCustomMethod(World world, ChunkCoordinates location, int methodID, Object[] args, ISensorTier tier) {
        return null;
    }

    @Override
    public String getName() {
        return "sonicCard";
    }

    @Override
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public void loadIcon(IIconRegister iconRegistry) {
        this.icon = iconRegistry.func_94245_a("openccsensors:sonic");
    }

    @Override
    public ItemStack getUniqueRecipeItem() {
        return new ItemStack((Block)Block.field_149771_c.func_82594_a("jukebox"));
    }
}

