/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.phaseevent;

import lumaceon.mods.clockworkphase.extendeddata.ExtendedWorldData;
import lumaceon.mods.clockworkphase.lib.GlobalPhaseReference;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.lib.Phases;
import lumaceon.mods.clockworkphase.registry.PhaseEventRegistry;
import lumaceon.mods.clockworkphase.util.PhaseHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public abstract class PhaseEventAbstract {
    public int ID;
    public Phases phase;
    public String EVENT_UNLOCALIZED_NAME = "clockworkphase:phase_event.default";
    public String EVENT_WARNING_MESSAGE = "A developer suddenly forgets to extend default values and screws everything up: +50 derpy developer points.";
    public String EVENT_ACTIVATION_MESSAGE = "A developer suddenly forgets to extend default values and screws everything up: +50 derpy developer points.";
    public String EVENT_DEACTIVATION_MESSAGE = "A developer suddenly forgets to extend default values and screws everything up: +50 derpy developer points.";
    public int warmupTime = this.getWarmTime();
    public int duration = this.getDuration();

    public void setupID(int id) {
        this.ID = id;
    }

    public void updatePhaseEvent(World world) {
        if (!world.field_72995_K) {
            if (!MechanicTweaker.PHASE_EVENTS) {
                ExtendedWorldData.get(world).removeWorldPhaseEvent(world);
                return;
            }
            if (this.warmupTime > 0) {
                --this.warmupTime;
            } else if (this.warmupTime == 0) {
                if (!this.getActivationMessage().isEmpty()) {
                    for (int n = 0; n < world.field_73010_i.size(); ++n) {
                        ((EntityPlayer)world.field_73010_i.get(n)).func_146105_b((IChatComponent)new ChatComponentText(this.getActivationMessage()));
                    }
                }
                --this.warmupTime;
            } else {
                --this.duration;
            }
            if (this.duration < 0 || PhaseHelper.getPhaseForWorld(world) != this.getPhase()) {
                ExtendedWorldData.get(world).removeWorldPhaseEvent(world);
            }
        }
    }

    public void applyEntityEffects(EntityLivingBase player) {
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("warmup_time", this.warmupTime);
        nbt.func_74768_a("duration_time", this.duration);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.warmupTime = nbt.func_74762_e("warmup_time");
        this.duration = nbt.func_74762_e("duration_time");
    }

    public PhaseEventAbstract copy() {
        PhaseEventAbstract copy = null;
        try {
            copy = (PhaseEventAbstract)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return copy;
    }

    public String getUnlocalizedName() {
        return this.EVENT_UNLOCALIZED_NAME;
    }

    public String getWarningMessage() {
        return this.EVENT_WARNING_MESSAGE;
    }

    public String getActivationMessage() {
        return this.EVENT_ACTIVATION_MESSAGE;
    }

    public String getDeactivationMessage() {
        return this.EVENT_DEACTIVATION_MESSAGE;
    }

    public Phases getPhase() {
        return this.phase;
    }

    public int getWarmTime() {
        return 600;
    }

    public int getDuration() {
        return GlobalPhaseReference.phaseDuration;
    }

    public static PhaseEventAbstract getPhaseEventFromNBT(NBTTagCompound nbt) {
        int id;
        Phases phase;
        PhaseEventAbstract event = null;
        if (nbt.func_74764_b("cp_phase") && nbt.func_74764_b("phase_id") && (event = PhaseEventRegistry.getSpecificPhaseEvent(phase = Phases.values()[nbt.func_74762_e("cp_phase")], id = nbt.func_74762_e("phase_id")).copy()) != null) {
            NBTTagCompound compound = nbt.func_74775_l("phase_event_data");
            event.readFromNBT(compound);
        }
        return event;
    }
}

