/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.item.construct.clockworkarmor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lumaceon.mods.clockworkphase.ClockworkPhase;
import lumaceon.mods.clockworkphase.init.ModItems;
import lumaceon.mods.clockworkphase.item.construct.abstracts.IClockwork;
import lumaceon.mods.clockworkphase.item.construct.abstracts.IDisassemble;
import lumaceon.mods.clockworkphase.item.construct.clockworkarmor.ItemClockworkBoots;
import lumaceon.mods.clockworkphase.item.construct.clockworkarmor.ItemClockworkChestpiece;
import lumaceon.mods.clockworkphase.item.construct.clockworkarmor.ItemClockworkHeadpiece;
import lumaceon.mods.clockworkphase.item.construct.clockworkarmor.ItemClockworkLeggings;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.proxy.ClientProxy;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import lumaceon.mods.clockworkphase.util.TensionHelper;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.input.Keyboard;

public class ItemChronoArmor
extends ItemArmor
implements IClockwork,
IDisassemble,
ISpecialArmor {
    public ItemChronoArmor(ItemArmor.ArmorMaterial material, int renderIndex, int armorType) {
        super(material, renderIndex, armorType);
        this.func_77637_a(ClockworkPhase.instance.creativeTabClockworkPhase);
        this.func_77625_d(1);
        this.func_77656_e(500);
        this.setNoRepair();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean flag) {
        ISpecialArmor.ArmorProperties hatProp;
        ItemStack hat = player.field_71071_by.func_70440_f(0);
        ItemStack shirt = player.field_71071_by.func_70440_f(1);
        ItemStack pants = player.field_71071_by.func_70440_f(2);
        ItemStack shoes = player.field_71071_by.func_70440_f(3);
        float singleArmorDefense = 0.0f;
        float totalArmorDefense = 0.0f;
        if (is != null && is.func_77973_b() instanceof ItemChronoArmor) {
            hatProp = ((ItemChronoArmor)is.func_77973_b()).getProperties((EntityLivingBase)player, is, new DamageSource("mob"), 0.0, 0);
            singleArmorDefense = (float)((double)singleArmorDefense + hatProp.AbsorbRatio);
        }
        if (hat != null && hat.func_77973_b() instanceof ItemChronoArmor) {
            hatProp = ((ItemChronoArmor)hat.func_77973_b()).getProperties((EntityLivingBase)player, hat, new DamageSource("mob"), 0.0, 0);
            totalArmorDefense = (float)((double)totalArmorDefense + hatProp.AbsorbRatio);
        }
        if (shirt != null && shirt.func_77973_b() instanceof ItemChronoArmor) {
            hatProp = ((ItemChronoArmor)shirt.func_77973_b()).getProperties((EntityLivingBase)player, shirt, new DamageSource("mob"), 0.0, 0);
            totalArmorDefense = (float)((double)totalArmorDefense + hatProp.AbsorbRatio);
        }
        if (pants != null && pants.func_77973_b() instanceof ItemChronoArmor) {
            hatProp = ((ItemChronoArmor)pants.func_77973_b()).getProperties((EntityLivingBase)player, pants, new DamageSource("mob"), 0.0, 0);
            totalArmorDefense = (float)((double)totalArmorDefense + hatProp.AbsorbRatio);
        }
        if (shoes != null && shoes.func_77973_b() instanceof ItemChronoArmor) {
            hatProp = ((ItemChronoArmor)shoes.func_77973_b()).getProperties((EntityLivingBase)player, shoes, new DamageSource("mob"), 0.0, 0);
            totalArmorDefense = (float)((double)totalArmorDefense + hatProp.AbsorbRatio);
        }
        list.add("Tension: \u00a7e" + NBTHelper.getInt(is, "tension_energy") + "/" + "\u00a7e" + NBTHelper.getInt(is, "max_tension"));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("");
            list.add("Clockwork Quality: \u00a7e" + NBTHelper.getInt(is, "cp_quality"));
            list.add("Clockwork Speed: \u00a7e" + NBTHelper.getInt(is, "cp_speed"));
            list.add("");
            list.add("Defense (Item): \u00a7e" + singleArmorDefense * 100.0f + "%");
            list.add("Defense (Total): \u00a7e" + totalArmorDefense * 100.0f + "%");
        } else {
            list.add("-Hold shift for details-");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack is, int armorSlot) {
        ModelBiped armorModel = null;
        if (is != null && is.func_77973_b() instanceof ItemChronoArmor) {
            if (is.func_77973_b() instanceof ItemClockworkHeadpiece) {
                armorModel = ClientProxy.getChronoArmorModel(0);
            }
            if (is.func_77973_b() instanceof ItemClockworkChestpiece) {
                armorModel = ClientProxy.getChronoArmorModel(1);
            }
            if (is.func_77973_b() instanceof ItemClockworkLeggings) {
                armorModel = ClientProxy.getChronoArmorModel(2);
            }
            if (is.func_77973_b() instanceof ItemClockworkBoots) {
                armorModel = ClientProxy.getChronoArmorModel(3);
            }
            if (armorModel != null) {
                armorModel.field_78116_c.field_78806_j = armorSlot == 0;
                armorModel.field_78114_d.field_78806_j = armorSlot == 0;
                armorModel.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
                armorModel.field_78112_f.field_78806_j = armorSlot == 1;
                armorModel.field_78113_g.field_78806_j = armorSlot == 1;
                armorModel.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
                armorModel.field_78117_n = entityLiving.func_70093_af();
                armorModel.field_78093_q = entityLiving.func_70115_ae();
                armorModel.field_78091_s = entityLiving.func_70631_g_();
                int n = armorModel.field_78120_m = entityLiving.func_70694_bm() != null ? 1 : 0;
                if (entityLiving instanceof EntityPlayer) {
                    armorModel.field_78118_o = ((EntityPlayer)entityLiving).func_71057_bx() > 2;
                }
            }
        }
        return armorModel;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        switch (slot) {
            case 0: {
                return "clockworkphase:textures/armor/chronoArmor.png";
            }
            case 1: {
                return "clockworkphase:textures/armor/chronoArmor.png";
            }
            case 2: {
                return "clockworkphase:textures/armor/chronoArmor.png";
            }
        }
        return "clockworkphase:textures/armor/chronoArmor.png";
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 24000;
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "clockworkphase:", super.func_77658_a().substring(super.func_77658_a().indexOf(46) + 1));
    }

    public String func_77667_c(ItemStack is) {
        return String.format("item.%s%s", "clockworkphase:", super.func_77658_a().substring(super.func_77658_a().indexOf(46) + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.field_77791_bV = registry.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1));
    }

    @Override
    public void addTension(ItemStack is, int tension) {
        TensionHelper.addTension(is, tension);
    }

    @Override
    public void removeTension(ItemStack is, int tension) {
        TensionHelper.removeTension(is, tension);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack is) {
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack is, DamageSource source, double damage, int slot) {
        int tension;
        double fullSetDefenseAdditions = 0.0;
        if (source.func_76363_c()) {
            if (source.func_151517_h()) {
                new ISpecialArmor.ArmorProperties(0, 0.0, 0);
            } else {
                fullSetDefenseAdditions -= 0.5;
            }
        }
        if ((tension = NBTHelper.getInt(is, "tension_energy")) <= 0) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        int quality = NBTHelper.getInt(is, "cp_quality");
        if (quality <= 0) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        int speed = NBTHelper.getInt(is, "cp_speed");
        if (speed >= 10) {
            double fullSetDefenseFinal = 0.92 / (300.0 / (double)speed);
            if (fullSetDefenseFinal > 0.92) {
                fullSetDefenseFinal = 0.92;
            }
            if (speed > 300) {
                fullSetDefenseFinal += 0.08 / (double)(400 / (speed - 300));
            }
            if (fullSetDefenseFinal > 1.0) {
                fullSetDefenseFinal = 1.0;
            }
            return new ISpecialArmor.ArmorProperties(0, (fullSetDefenseFinal += fullSetDefenseAdditions) / 4.0, Integer.MAX_VALUE);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.func_82812_d().func_78044_b(Math.abs(slot - 3));
    }

    public void damageArmor(EntityLivingBase entity, ItemStack is, DamageSource source, int damage, int slot) {
        int tension = NBTHelper.getInt(is, "tension_energy");
        if (tension <= 0) {
            int maxTension = NBTHelper.getInt(is, "max_tension");
            if (maxTension / is.func_77958_k() == 0) {
                is.func_77964_b(is.func_77958_k() - 1);
            } else {
                is.func_77964_b(is.func_77958_k() - tension / (maxTension / is.func_77958_k()));
            }
            return;
        }
        int quality = NBTHelper.getInt(is, "cp_quality");
        if (quality <= 0) {
            int maxTension = NBTHelper.getInt(is, "max_tension");
            if (maxTension / is.func_77958_k() == 0) {
                is.func_77964_b(is.func_77958_k() - 1);
            } else {
                is.func_77964_b(is.func_77958_k() - tension / (maxTension / is.func_77958_k()));
            }
            return;
        }
        int speed = NBTHelper.getInt(is, "cp_speed");
        float efficiency = (float)speed / (float)quality;
        int tensionCost = (int)Math.round((double)MechanicTweaker.CLOCKWORK_ARMOR_TENSION_COST * Math.pow(efficiency, 2.0));
        int newTension = tension - tensionCost;
        if (newTension <= 0) {
            this.removeTension(is, tension);
            return;
        }
        this.removeTension(is, tensionCost);
    }

    @Override
    public void disassemble(World world, double x, double y, double z, ItemStack is) {
        NBTTagList tagList;
        if (world.field_72995_K) {
            return;
        }
        int maxTension = NBTHelper.getInt(is, "max_tension");
        if (maxTension != 0) {
            ItemStack mainspring = new ItemStack(ModItems.mainspring);
            NBTHelper.setInteger(mainspring, "max_tension", maxTension);
            NBTHelper.setInteger(mainspring, "tension_energy", 0);
            world.func_72838_d((Entity)new EntityItem(world, x, y, z, mainspring));
        }
        if (NBTHelper.hasTag(is, "cp_clockwork") && (tagList = NBTHelper.getTagList(is, "cp_clockwork")).func_74745_c() > 0) {
            ItemStack clockwork = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(0));
            world.func_72838_d((Entity)new EntityItem(world, x, y, z, clockwork));
        }
        NBTHelper.setInteger(is, "tension_energy", 0);
        NBTHelper.setInteger(is, "max_tension", 0);
        NBTHelper.setInteger(is, "cp_quality", 0);
        NBTHelper.setInteger(is, "cp_speed", 0);
        NBTHelper.setInteger(is, "cp_memory", 0);
        NBTHelper.removeTag(is, "cp_clockwork");
        is.func_77964_b(is.func_77958_k());
    }
}

