/*
 * Decompiled with CFR 0.152.
 */
package lumaceon.mods.clockworkphase.item.construct.clockwork.tool;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import lumaceon.mods.clockworkphase.ClockworkPhase;
import lumaceon.mods.clockworkphase.block.tileentity.TileEntityTimeWell;
import lumaceon.mods.clockworkphase.init.ModBlocks;
import lumaceon.mods.clockworkphase.init.ModItems;
import lumaceon.mods.clockworkphase.item.construct.IKeybindAbility;
import lumaceon.mods.clockworkphase.item.construct.ITemporalChange;
import lumaceon.mods.clockworkphase.item.construct.abstracts.IClockwork;
import lumaceon.mods.clockworkphase.item.construct.abstracts.IDisassemble;
import lumaceon.mods.clockworkphase.item.construct.abstracts.ITimeSand;
import lumaceon.mods.clockworkphase.lib.MechanicTweaker;
import lumaceon.mods.clockworkphase.network.MessageParticleSpawn;
import lumaceon.mods.clockworkphase.network.MessageTemporalItemChange;
import lumaceon.mods.clockworkphase.network.PacketHandler;
import lumaceon.mods.clockworkphase.util.NBTHelper;
import lumaceon.mods.clockworkphase.util.TensionHelper;
import lumaceon.mods.clockworkphase.util.TimeSandHelper;
import lumaceon.mods.clockworkphase.util.TimeSandParser;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.lwjgl.input.Keyboard;

public class ItemClockworkShovel
extends ItemSpade
implements IClockwork,
IDisassemble,
ITimeSand,
IKeybindAbility,
ITemporalChange {
    public ItemClockworkShovel(Item.ToolMaterial mat) {
        super(mat);
        this.func_77637_a(ClockworkPhase.instance.creativeTabClockworkPhase);
        this.func_77625_d(1);
        this.func_77656_e(50);
        this.setNoRepair();
        this.setHarvestLevel("shovel", 3);
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int meta, float f1, float f2, float f3) {
        return false;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        return is;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        int z;
        int y;
        int x = (int)Math.floor(entityItem.field_70165_t);
        Block targetBlock = entityItem.field_70170_p.func_147439_a(x, y = (int)Math.floor(entityItem.field_70163_u - 1.0), z = (int)Math.floor(entityItem.field_70161_v));
        if (targetBlock == null) {
            return false;
        }
        if (!targetBlock.equals(ModBlocks.timeWell)) {
            return false;
        }
        TileEntity te = entityItem.field_70170_p.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityTimeWell && !entityItem.field_70170_p.field_72995_K) {
            int amountRemoved = this.removeTimeSand(entityItem.func_92059_d(), 1000);
            TileEntityTimeWell timeWell = (TileEntityTimeWell)te;
            timeWell.addTimeSand(amountRemoved);
            return false;
        }
        return false;
    }

    public float func_150893_a(ItemStack is, Block block) {
        float efficiency = super.func_150893_a(is, block);
        if (efficiency == 1.0f) {
            return efficiency;
        }
        int tension = NBTHelper.getInt(is, "tension_energy");
        if (tension <= 0) {
            return 1.0f;
        }
        int speed = NBTHelper.getInt(is, "cp_speed");
        if (speed <= 0) {
            return 1.0f;
        }
        return (float)speed / 20.0f;
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (ForgeHooks.isToolEffective((ItemStack)stack, (Block)block, (int)meta)) {
            int tension = NBTHelper.getInt(stack, "tension_energy");
            if (tension <= 0) {
                return 1.0f;
            }
            int speed = NBTHelper.getInt(stack, "cp_speed");
            if (speed <= 0) {
                return 1.0f;
            }
            return (float)speed / 20.0f;
        }
        return this.func_150893_a(stack, block);
    }

    public boolean func_77644_a(ItemStack is, EntityLivingBase entity1, EntityLivingBase entity2) {
        return true;
    }

    public boolean func_150894_a(ItemStack is, World world, Block block, int x, int y, int z, EntityLivingBase entity) {
        if ((double)block.func_149712_f(world, x, y, z) != 0.0 && is.func_77973_b() instanceof IClockwork) {
            int tension = NBTHelper.getInt(is, "tension_energy");
            int quality = NBTHelper.getInt(is, "cp_quality");
            if (quality <= 0) {
                return false;
            }
            int speed = NBTHelper.getInt(is, "cp_speed");
            int memory = NBTHelper.getInt(is, "cp_memory");
            float efficiency = (float)speed / (float)quality;
            int tensionCost = (int)Math.round((double)MechanicTweaker.TENSION_PER_BLOCK_BREAK * Math.pow(efficiency, 2.0));
            int newTension = tension - tensionCost;
            if (newTension <= 0) {
                this.removeTension(is, tension);
                return true;
            }
            if (memory > 0 && !world.field_72995_K && this.func_150893_a(is, block) > 1.0f && entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                int memoryWebPower = (int)((double)memory * Math.pow((float)player.field_71068_ca + 1.0f, 2.0));
                int chance = 12800000;
                if (memoryWebPower > 0) {
                    chance = 12800000 / memoryWebPower;
                }
                if (chance < 1) {
                    chance = 1;
                }
                if (world.field_73012_v.nextInt(chance) == 0) {
                    this.addTimeSand(is, MechanicTweaker.SHOVEL_TIME_SAND_INCREMENT);
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageParticleSpawn((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 64.0));
                }
            }
            this.removeTension(is, tensionCost);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean flag) {
        list.add("Tension: \u00a7e" + NBTHelper.getInt(is, "tension_energy") + "/" + "\u00a7e" + NBTHelper.getInt(is, "max_tension"));
        int timeSand = this.getTimeSand(is);
        if (timeSand > 0) {
            list.add(TimeSandParser.getStringForRenderingFromTimeSand(timeSand));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int quality = NBTHelper.getInt(is, "cp_quality");
            int speed = NBTHelper.getInt(is, "cp_speed");
            int memory = NBTHelper.getInt(is, "cp_memory");
            int memoryWebPower = (int)((double)memory * Math.pow((float)player.field_71068_ca + 1.0f, 2.0));
            int chance = 12800000;
            if (memoryWebPower > 0 && (chance = 12800000 / memoryWebPower) < 1) {
                chance = 1;
            }
            list.add("");
            list.add("Clockwork Quality: \u00a7e" + quality);
            list.add("Clockwork Speed: \u00a7e" + speed);
            list.add("Memory: \u00a7e" + memory);
            if (memory > 0) {
                if (chance < 1000000) {
                    list.add("Chance of Extracting Time Sand: 1 in " + chance);
                } else {
                    list.add("Chance of Extracting Time Sand: 1 in an eternity.");
                }
            }
            list.add("");
        } else {
            list.add("-Hold shift for details-");
        }
    }

    @Override
    public void addTension(ItemStack is, int tension) {
        TensionHelper.addTension(is, tension);
    }

    @Override
    public void removeTension(ItemStack is, int tension) {
        TensionHelper.removeTension(is, tension);
    }

    @Override
    public int getMaxTimeSand() {
        return MechanicTweaker.MAX_TIME_SAND_TOOLS;
    }

    @Override
    public int getTimeSand(ItemStack is) {
        return TimeSandHelper.getTimeSand(is);
    }

    @Override
    public int addTimeSand(ItemStack is, int timeSand) {
        return TimeSandHelper.addTimeSand(is, timeSand, this.getMaxTimeSand());
    }

    @Override
    public int removeTimeSand(ItemStack is, int timeSand) {
        return TimeSandHelper.removeTimeSand(is, timeSand);
    }

    @Override
    public int removeTimeSandFromInventory(IInventory inventory, int timeSand) {
        return TimeSandHelper.removeTimeSandFromInventory(inventory, timeSand);
    }

    @Override
    public int getTimeSandFromInventory(IInventory inventory) {
        return TimeSandHelper.getTimeSandFromInventory(inventory);
    }

    @Override
    public void disassemble(World world, double x, double y, double z, ItemStack is) {
        NBTTagList tagList;
        if (world.field_72995_K) {
            return;
        }
        int maxTension = NBTHelper.getInt(is, "max_tension");
        if (maxTension != 0) {
            ItemStack mainspring = new ItemStack(ModItems.mainspring);
            NBTHelper.setInteger(mainspring, "max_tension", maxTension);
            NBTHelper.setInteger(mainspring, "tension_energy", 0);
            world.func_72838_d((Entity)new EntityItem(world, x, y, z, mainspring));
        }
        if (NBTHelper.hasTag(is, "cp_clockwork") && (tagList = NBTHelper.getTagList(is, "cp_clockwork")).func_74745_c() > 0) {
            ItemStack clockwork = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(0));
            world.func_72838_d((Entity)new EntityItem(world, x, y, z, clockwork));
        }
        NBTHelper.setInteger(is, "tension_energy", 0);
        NBTHelper.setInteger(is, "max_tension", 0);
        NBTHelper.setInteger(is, "cp_quality", 0);
        NBTHelper.setInteger(is, "cp_speed", 0);
        NBTHelper.setInteger(is, "cp_memory", 0);
        NBTHelper.removeTag(is, "cp_clockwork");
        is.func_77964_b(is.func_77958_k());
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "clockworkphase:", super.func_77658_a().substring(super.func_77658_a().indexOf(46) + 1));
    }

    public String func_77667_c(ItemStack is) {
        return String.format("item.%s%s", "clockworkphase:", super.func_77658_a().substring(super.func_77658_a().indexOf(46) + 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister registry) {
        this.field_77791_bV = registry.func_94245_a(this.func_77658_a().substring(this.func_77658_a().indexOf(".") + 1));
    }

    @Override
    public void useTemporalAbility() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageTemporalItemChange());
    }

    @Override
    public Item getItemChangeTo() {
        return ModItems.temporalClockworkShovel;
    }
}

