/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.machines.emptower;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTile;
import com.builtbroken.mc.api.tile.multiblock.IMultiTileHost;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.core.registry.implement.IRecipeContainer;
import com.builtbroken.mc.framework.multiblock.EnumMultiblock;
import com.builtbroken.mc.framework.multiblock.MultiBlockHelper;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.prefab.gui.ContainerDummy;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.items.ItemBlockBase;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.module.TileModuleInventory;
import icbm.classic.ICBMClassic;
import icbm.classic.content.explosive.Explosives;
import icbm.classic.content.explosive.blast.BlastEMP;
import icbm.classic.prefab.TileICBMMachine;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class TileEMPTower
extends TileICBMMachine
implements IMultiTileHost,
IPacketIDReceiver,
IRecipeContainer,
IGuiTile {
    public static final int MAX_RADIUS = 150;
    public static HashMap<IPos3D, String> tileMapCache = new HashMap();
    public float rotation = 0.0f;
    private float rotationDelta;
    public byte empMode = 0;
    private int cooldownTicks = 0;
    public int empRadius = 60;
    private boolean _destroyingStructure = false;

    public TileEMPTower() {
        super("empTower", Material.field_151573_f);
        this.itemBlock = ItemBlockBase.class;
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.isOpaque = false;
    }

    protected IInventory createInventory() {
        return new TileModuleInventory((IInventoryProvider)this, 2);
    }

    public Tile newTile() {
        return new TileEMPTower();
    }

    @Override
    public void update() {
        super.update();
        if (!this.isReady()) {
            --this.cooldownTicks;
        } else if (this.isIndirectlyPowered()) {
            this.fire();
        }
        if (this.ticks % 20L == 0L && this.getEnergy() > 0) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "icbmclassic:machinehum", 0.5f, 0.85f * (float)this.getEnergy() / (float)this.getEnergyBufferSize());
            this.sendDescPacket();
        }
        this.rotationDelta = (float)(Math.pow(this.getEnergy() / this.getEnergyBufferSize(), 2.0) * 0.5);
        this.rotation += this.rotationDelta;
        if (this.rotation > 360.0f) {
            this.rotation = 0.0f;
        }
    }

    public boolean read(ByteBuf data, int id, EntityPlayer player, PacketType type) {
        if (!super.read(data, id, player, type)) {
            switch (id) {
                case 0: {
                    this.setEnergy(data.readInt());
                    this.empRadius = data.readInt();
                    this.empMode = data.readByte();
                    return true;
                }
                case 1: {
                    this.empRadius = data.readInt();
                    return true;
                }
                case 2: {
                    this.empMode = data.readByte();
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public int getEnergyBufferSize() {
        return Math.max(3000000 * (this.empRadius / 150), 1000000);
    }

    public PacketTile getDescPacket() {
        return new PacketTile((TileEntity)this, new Object[]{0, this.getEnergy(), this.empRadius, this.empMode});
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.empRadius = par1NBTTagCompound.func_74762_e("empRadius");
        this.empMode = par1NBTTagCompound.func_74771_c("empMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("empRadius", this.empRadius);
        par1NBTTagCompound.func_74774_a("empMode", this.empMode);
    }

    public boolean fire() {
        if (this.checkExtract() && this.isReady()) {
            switch (this.empMode) {
                default: {
                    new BlastEMP(this.field_145850_b, null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.2, (double)this.field_145849_e + 0.5, this.empRadius).setEffectBlocks().setEffectEntities().explode();
                    break;
                }
                case 1: {
                    new BlastEMP(this.field_145850_b, null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.2, (double)this.field_145849_e + 0.5, this.empRadius).setEffectEntities().explode();
                    break;
                }
                case 2: {
                    new BlastEMP(this.field_145850_b, null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.2, (double)this.field_145849_e + 0.5, this.empRadius).setEffectBlocks().explode();
                }
            }
            this.extractEnergy();
            this.cooldownTicks = this.getMaxCooldown();
            return true;
        }
        return false;
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            this.openGui(player, (Object)ICBMClassic.INSTANCE);
        }
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean isReady() {
        return this.getCooldown() <= 0;
    }

    public int getCooldown() {
        return this.cooldownTicks;
    }

    public int getMaxCooldown() {
        return 120;
    }

    public void firstTick() {
        super.firstTick();
        MultiBlockHelper.buildMultiBlock((World)this.oldWorld(), (IMultiTileHost)this, (boolean)true, (boolean)true);
    }

    public void onMultiTileAdded(IMultiTile tileMulti) {
        if (tileMulti instanceof TileEntity && tileMapCache.containsKey(new Pos((TileEntity)this).sub((IPos3D)new Pos((TileEntity)tileMulti)))) {
            tileMulti.setHost((IMultiTileHost)this);
        }
    }

    public boolean onMultiTileBroken(IMultiTile tileMulti, Object source, boolean harvest) {
        Pos pos;
        if (!this._destroyingStructure && tileMulti instanceof TileEntity && tileMapCache.containsKey(pos = (Pos)new Pos((TileEntity)tileMulti).sub((IPos3D)new Pos((TileEntity)this)))) {
            MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)harvest, (boolean)true, (boolean)true);
            return true;
        }
        return false;
    }

    public boolean canPlaceBlockAt() {
        return super.canPlaceBlockAt() && this.oldWorld().func_147439_a(this.xi(), this.yi() + 1, this.zi()).isReplaceable((IBlockAccess)this.oldWorld(), this.xi(), this.yi() + 1, this.zi());
    }

    public boolean canPlaceBlockOnSide(ForgeDirection side) {
        return side == ForgeDirection.UP && this.canPlaceBlockAt();
    }

    public boolean removeByPlayer(EntityPlayer player, boolean willHarvest) {
        MultiBlockHelper.destroyMultiBlockStructure((IMultiTileHost)this, (boolean)false, (boolean)true, (boolean)false);
        return super.removeByPlayer(player, willHarvest);
    }

    public void onTileInvalidate(IMultiTile tileMulti) {
    }

    public boolean onMultiTileActivated(IMultiTile tile, EntityPlayer player, int side, float xHit, float yHit, float zHit) {
        return this.onPlayerRightClick(player, side, new Pos((double)xHit, (double)yHit, (double)zHit));
    }

    public void onMultiTileClicked(IMultiTile tile, EntityPlayer player) {
    }

    public HashMap<IPos3D, String> getLayoutOfMultiBlock() {
        return tileMapCache;
    }

    public void genRecipes(List<IRecipe> recipes) {
        Object[] items = new Object[]{"batteryBox", InventoryUtility.getItemStack((String)"IC2:blockElectric", (int)0), InventoryUtility.getItemStack((String)"ThermalExpansion:Frame", (int)5), InventoryUtility.getItemStack((String)"Mekanism:EnergyCube", (int)0)};
        boolean registered = false;
        for (Object object : items) {
            if (object == null || object instanceof String && !OreDictionary.doesOreNameExist((String)((String)object))) continue;
            recipes.add((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockEmpTower, 1, 0), new Object[]{"?W?", "@!@", "?#?", Character.valueOf('?'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('!'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('@'), object, Character.valueOf('#'), UniversalRecipe.MOTOR.get(), Character.valueOf('W'), UniversalRecipe.WIRE.get()}));
            registered = true;
        }
        if (!registered) {
            recipes.add((IRecipe)new ShapedOreRecipe(new ItemStack(ICBMClassic.blockEmpTower, 1, 0), new Object[]{"?W?", "@!@", "?#?", Character.valueOf('?'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('!'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('@'), Explosives.EMP.getItemStack(), Character.valueOf('#'), UniversalRecipe.MOTOR.get(), Character.valueOf('W'), UniversalRecipe.WIRE.get()}));
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player) {
        return new ContainerDummy();
    }

    public Object getClientGuiElement(int ID, EntityPlayer player) {
        return null;
    }

    static {
        tileMapCache.put((IPos3D)new Pos(0.0, 1.0, 0.0), EnumMultiblock.TILE.getTileName());
    }
}

