/*
 * Decompiled with CFR 0.152.
 */
package BloodStuff;

import BloodStuff.APISpellHelper;
import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class PlayerSacrificeHandler {
    public static float scalingOfSacrifice = 0.001f;
    public static int soulFrayDuration = 400;

    public static float getPlayerIncense(EntityPlayer player) {
        return APISpellHelper.getCurrentIncense(player);
    }

    public static void setPlayerIncense(EntityPlayer player, float amount) {
        APISpellHelper.setCurrentIncense(player, amount);
    }

    public static boolean incrementIncense(EntityPlayer player, float min, float max, float increment) {
        float amount = PlayerSacrificeHandler.getPlayerIncense(player);
        if (amount < min || amount >= max) {
            return false;
        }
        amount += Math.min(increment, max - amount);
        PlayerSacrificeHandler.setPlayerIncense(player, amount);
        return true;
    }

    public static boolean sacrificePlayerHealth(EntityPlayer player) {
        float maxHealth;
        float health;
        if (player.func_70644_a(AlchemicalWizardry.customPotionSoulFray)) {
            return false;
        }
        float amount = PlayerSacrificeHandler.getPlayerIncense(player);
        if (amount >= 0.0f && (double)(health = player.func_110143_aJ()) > (double)(maxHealth = player.func_110138_aP()) / 10.0) {
            float sacrificedHealth = health - maxHealth / 10.0f;
            if (PlayerSacrificeHandler.findAndFillAltar(player.func_130014_f_(), player, (int)(sacrificedHealth * 100.0f * PlayerSacrificeHandler.getModifier(amount)))) {
                player.func_70606_j(maxHealth / 10.0f);
                PlayerSacrificeHandler.setPlayerIncense(player, 0.0f);
                player.func_70690_d(new PotionEffect(AlchemicalWizardry.customPotionSoulFray.field_76415_H, soulFrayDuration));
                return true;
            }
        }
        return false;
    }

    public static float getModifier(float amount) {
        return 1.0f + amount * scalingOfSacrifice;
    }

    public static boolean findAndFillAltar(World world, EntityPlayer player, int amount) {
        int posZ;
        int posY;
        int posX = (int)Math.round(player.field_70165_t - 0.5);
        IBloodAltar altarEntity = PlayerSacrificeHandler.getAltar(world, posX, posY = (int)player.field_70163_u, posZ = (int)Math.round(player.field_70161_v - 0.5));
        return altarEntity != null;
    }

    public static IBloodAltar getAltar(World world, int x, int y, int z) {
        TileEntity tileEntity = null;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k <= 1; ++k) {
                    tileEntity = world.func_147438_o(i + x, k + y, j + z);
                    if (!(tileEntity instanceof IBloodAltar)) continue;
                    return (IBloodAltar)tileEntity;
                }
            }
        }
        return null;
    }
}

