/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.integration.fmp;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.minecraft.McMetaPart;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.PacketTileSync;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.utils.ISyncTile;

public abstract class SonarTilePart
extends McMetaPart
implements ISyncTile {
    public Object rend;

    public SonarTilePart() {
    }

    public SonarTilePart(int meta) {
        this.meta = (byte)meta;
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        return Arrays.asList(this.getBounds());
    }

    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.readData(tag, NBTHelper.SyncType.SAVE);
    }

    public void save(NBTTagCompound tag) {
        super.save(tag);
        this.writeData(tag, NBTHelper.SyncType.SAVE);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        ArrayList<ISyncPart> parts = new ArrayList<ISyncPart>();
        this.addSyncParts(parts);
        for (ISyncPart part : parts) {
            if (!part.canSync(type)) continue;
            part.readFromNBT(nbt, type);
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        ArrayList<ISyncPart> parts = new ArrayList<ISyncPart>();
        this.addSyncParts(parts);
        for (ISyncPart part : parts) {
            if (!part.canSync(type)) continue;
            part.writeToNBT(nbt, type);
        }
    }

    public void addSyncParts(List<ISyncPart> parts) {
    }

    public final void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        NBTTagCompound write = new NBTTagCompound();
        this.writeData(write, NBTHelper.SyncType.SAVE);
        packet.writeNBTTagCompound(write);
    }

    public final void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.readData(packet.readNBTTagCompound(), NBTHelper.SyncType.SAVE);
    }

    public void sendSyncPacket(EntityPlayer player) {
        if (this.world().field_72995_K) {
            return;
        }
        if (player != null && player instanceof EntityPlayerMP) {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeData(tag, NBTHelper.SyncType.SYNC);
            if (!tag.func_82582_d()) {
                SonarCore.network.sendTo((IMessage)new PacketTileSync(this.x(), this.y(), this.z(), tag), (EntityPlayerMP)player);
            }
        }
    }

    public void invalidateConvertedTile() {
        TileEntity tile = this.world().func_147438_o(this.x(), this.y(), this.z());
        if (tile instanceof ISyncTile) {
            ISyncTile sync = (ISyncTile)tile;
            NBTTagCompound tag = new NBTTagCompound();
            sync.writeData(tag, NBTHelper.SyncType.SAVE);
            this.readData(tag, NBTHelper.SyncType.SAVE);
        }
    }

    public abstract Object getSpecialRenderer();

    public void onWorldJoin() {
        if (this.world().field_72995_K) {
            this.rend = this.getSpecialRenderer();
        }
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (this.world().field_72995_K && this.rend != null && this.rend instanceof TileEntitySpecialRenderer) {
            ((TileEntitySpecialRenderer)this.rend).func_147500_a((TileEntity)this.tile(), pos.x, pos.y, pos.z, 0.0f);
        }
    }

    public boolean doesTick() {
        return true;
    }

    public void sendAdditionalPackets(EntityPlayer player) {
    }
}

