/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.helpers;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import sonar.core.common.block.SonarBlock;
import sonar.core.helpers.FontHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.integration.fmp.SonarTilePart;

public class RenderHelper {
    private static final ResourceLocation mapBackgroundTextures = new ResourceLocation("textures/map/map_background.png");
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected RenderManager renderManager;

    public static int setMetaData(TileEntity tileentity) {
        TMultiPart part;
        int i;
        if (tileentity.func_145831_w() == null) {
            i = 0;
        } else {
            Block block = tileentity.func_145838_q();
            i = tileentity.func_145832_p();
            if (block != null && i == 0) {
                i = tileentity.func_145832_p();
            }
        }
        if (SonarLoader.forgeMultipartLoaded() && tileentity != null && tileentity.func_145831_w() != null && tileentity instanceof TileMultipart && (part = (TMultiPart)((TileMultipart)tileentity).jPartList().get(0)) != null && part instanceof SonarTilePart) {
            i = ((SonarTilePart)part).meta;
        }
        return i;
    }

    public static void beginRender(double x, double y, double z, int meta, String texture) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(texture));
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)180.0f, (float)0.0f, (float)1.0f);
        int j = 0;
        switch (meta) {
            case 2: {
                j = 180;
                break;
            }
            case 3: {
                j = 0;
                break;
            }
            case 4: {
                j = 90;
                break;
            }
            case 5: {
                j = 270;
            }
        }
        GL11.glRotatef((float)j, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotated((double)-0.625, (double)0.0, (double)1.0, (double)0.0);
    }

    public static void finishRender() {
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static boolean renderItem(ItemStack item, float bobing, float rotation, Random random, TextureManager engine, RenderBlocks renderBlocks, int count) {
        Block block;
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)item, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY);
        if (customRenderer == null) {
            return false;
        }
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.ENTITY_ROTATION)) {
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (!customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.ENTITY_BOBBING)) {
            GL11.glTranslatef((float)0.0f, (float)(-bobing), (float)0.0f);
        }
        boolean is3D = customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        engine.func_110577_a(item.func_94608_d() == 0 ? TextureMap.field_110575_b : TextureMap.field_110576_c);
        Block block2 = block = item.func_77973_b() instanceof ItemBlock ? Block.func_149634_a((Item)item.func_77973_b()) : null;
        if (is3D || block != null && RenderBlocks.func_147739_a((int)block.func_149645_b())) {
            boolean blend;
            int renderType = block != null ? block.func_149645_b() : 1;
            float scale = renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2 ? 0.5f : 0.25f;
            boolean bl = blend = block != null && block.func_149701_w() > 0;
            if (RenderItem.field_82407_g) {
                GL11.glScalef((float)1.25f, (float)1.25f, (float)1.25f);
                GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (blend) {
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            for (int j = 0; j < count; ++j) {
                GL11.glPushMatrix();
                if (j > 0) {
                    GL11.glTranslatef((float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / scale), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / scale), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / scale));
                }
                customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, new Object[]{renderBlocks});
                GL11.glPopMatrix();
            }
            if (blend) {
                GL11.glDisable((int)3042);
            }
        } else {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, new Object[]{renderBlocks});
        }
        return true;
    }

    public static void renderItem(World world, ItemStack stack) {
        if (stack == null) {
            return;
        }
        ItemStack render = stack.func_77946_l();
        if (render != null) {
            TextureAtlasSprite textureatlassprite;
            if (render.func_77973_b() instanceof ItemBlock) {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glTranslated((double)0.0, (double)-0.052, (double)-0.2);
            }
            EntityItem entityitem = new EntityItem(world, 0.0, 0.0, 0.0, render);
            Item item = entityitem.func_92059_d().func_77973_b();
            entityitem.func_92059_d().field_77994_a = 1;
            entityitem.field_70290_d = 0.0f;
            RenderItem.field_82407_g = true;
            RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            RenderItem.field_82407_g = false;
            if (item == Items.field_151111_aL && (textureatlassprite = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110576_c)).func_110572_b(Items.field_151111_aL.func_77650_f(entityitem.func_92059_d()).func_94215_i())).func_110970_k() > 0) {
                textureatlassprite.func_94219_l();
            }
        }
    }

    public static ForgeDirection getHorizontal(ForgeDirection forward) {
        if (forward == ForgeDirection.NORTH) {
            return ForgeDirection.EAST;
        }
        if (forward == ForgeDirection.EAST) {
            return ForgeDirection.SOUTH;
        }
        if (forward == ForgeDirection.SOUTH) {
            return ForgeDirection.WEST;
        }
        if (forward == ForgeDirection.WEST) {
            return ForgeDirection.NORTH;
        }
        return null;
    }

    public static void renderBlockCollisions(World world, int x, int y, int z) {
        SonarBlock block;
        if (world != null && world.func_147439_a(x, y, z) instanceof SonarBlock && (block = (SonarBlock)world.func_147439_a(x, y, z)).hasSpecialCollisionBox()) {
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
            block.getCollisionBoxes(world, x, y, z, list);
            for (AxisAlignedBB axis : list) {
                RenderGlobal.func_147590_a((AxisAlignedBB)axis, (int)-1);
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    public static void renderStoredItemStackOverlay(FontRenderer font, TextureManager tex, ItemStack stack, long stored, int x, int y, String string) {
        if (stack != null) {
            stack.field_77994_a = 1;
            RenderItem.getInstance().func_77021_b(font, tex, stack, x, y);
            if (stored > 0L || string != null) {
                String s1 = string == null ? FontHelper.formatStackSize(stored) : string;
                float scaleFactor = 0.5f;
                float inverseScaleFactor = 2.0f;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glPushMatrix();
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                int X = (int)(((float)x + 15.0f - (float)font.func_78256_a(s1) * 0.5f) * 2.0f);
                int Y = (int)(((float)y + 15.0f - 3.5f) * 2.0f);
                font.func_78261_a(s1, X, Y, 0xFFFFFF);
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
        }
    }

    public static void renderFluidInGUI(FontRenderer font, TextureManager tex, FluidStack stack, long stored, int x, int y, String string) {
        if (stack != null) {
            RenderItem.getInstance().func_94149_a(x, y, stack.getFluid().getIcon(), 16, 16);
            if (stored > 0L || string != null) {
                String s1 = string == null ? FontHelper.formatFluidSize(stored) : string;
                float scaleFactor = 0.5f;
                float inverseScaleFactor = 2.0f;
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                GL11.glPushMatrix();
                GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
                int X = (int)(((float)x + 15.0f - (float)font.func_78256_a(s1) * 0.5f) * 2.0f);
                int Y = (int)(((float)y + 15.0f - 3.5f) * 2.0f);
                font.func_78261_a(s1, X, Y, 0xFFFFFF);
                GL11.glPopMatrix();
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
        }
    }

    public static void doRenderItem(ItemStack itemstack, World world, boolean normalSize) {
        if (itemstack != null) {
            EntityItem entityitem = new EntityItem(world, 0.0, 0.0, 0.0, itemstack);
            entityitem.func_92059_d().field_77994_a = 1;
            entityitem.field_70290_d = 0.0f;
            entityitem.field_70292_b = 0;
            entityitem.field_70177_z = 0.0f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (itemstack.func_77948_v() || itemstack.func_77973_b().func_77623_v()) {
                IItemRenderer customRenderer;
                GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)-0.25f);
                GL11.glScalef((float)0.6666667f, (float)0.6666667f, (float)0.6666667f);
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)(normalSize ? 1.0f : 0.005f));
                Block block = Block.func_149634_a((Item)itemstack.func_77973_b());
                if (itemstack.func_94608_d() == 0 && block != null && RenderBlocks.func_147739_a((int)block.func_149645_b())) {
                    GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if ((customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.ENTITY)) != null && !(itemstack.func_77973_b() instanceof ItemBlock)) {
                    if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D)) {
                        GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
                        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
                        GL11.glRotatef((float)35.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                } else if (itemstack.func_77973_b() instanceof ItemBlock) {
                    GL11.glTranslatef((float)0.0f, (float)-0.04f, (float)0.0f);
                    GL11.glScalef((float)1.1f, (float)1.1f, (float)1.1f);
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                } else {
                    GL11.glTranslatef((float)0.0f, (float)-0.14f, (float)0.0f);
                    GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                }
                RenderItem.field_82407_g = true;
                RenderManager.field_78727_a.func_147940_a((Entity)entityitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                RenderItem.field_82407_g = false;
            } else {
                GL11.glScalef((float)0.023809524f, (float)0.023809524f, (float)0.023809524f);
                GL11.glTranslated((double)-8.0, (double)-10.2, (double)-10.4);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)(normalSize ? 1.0f : 0.01f));
                RenderItem.field_82407_g = false;
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)RenderBlocks.getInstance(), (TextureManager)Minecraft.func_71410_x().field_71446_o, (ItemStack)itemstack, (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                    RenderItem.getInstance().renderItemIntoGUI(fr, Minecraft.func_71410_x().field_71446_o, itemstack, 0, 0, false);
                }
            }
            GL11.glPopMatrix();
        }
    }

    public static void drawTexturedModalRect(double minX, double minY, double maxY, double width, double height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        double widthnew = 0.0 + width * 2.0;
        double heightnew = 0.0 + height * 2.0;
        tessellator.func_78374_a(minX + 0.0, maxY / 2.0, 0.0, 0.0, heightnew);
        tessellator.func_78374_a(minX + width, maxY / 2.0, 0.0, widthnew, heightnew);
        tessellator.func_78374_a(minX + width, minY + 0.0, 0.0, widthnew, 0.0);
        tessellator.func_78374_a(minX + 0.0, minY + 0.0, 0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public void drawTexturedModelRectFromIcon(int p_94065_1_, int p_94065_2_, IIcon p_94065_3_, int p_94065_4_, int p_94065_5_) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(p_94065_1_ + 0), (double)(p_94065_2_ + p_94065_5_), 0.0, (double)p_94065_3_.func_94209_e(), (double)p_94065_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94065_1_ + p_94065_4_), (double)(p_94065_2_ + p_94065_5_), 0.0, (double)p_94065_3_.func_94212_f(), (double)p_94065_3_.func_94210_h());
        tessellator.func_78374_a((double)(p_94065_1_ + p_94065_4_), (double)(p_94065_2_ + 0), 0.0, (double)p_94065_3_.func_94212_f(), (double)p_94065_3_.func_94206_g());
        tessellator.func_78374_a((double)(p_94065_1_ + 0), (double)(p_94065_2_ + 0), 0.0, (double)p_94065_3_.func_94209_e(), (double)p_94065_3_.func_94206_g());
        tessellator.func_78381_a();
    }
}

