/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tileentity;

import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import sonar.core.common.tileentity.TileEntitySonar;
import sonar.core.helpers.NBTHelper;
import sonar.core.integration.SonarLoader;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncEnergyStorage;

public class TileEntityEnergy
extends TileEntitySonar
implements IEnergyTile {
    public SyncEnergyStorage storage;
    public int maxTransfer;

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        if (type == NBTHelper.SyncType.DROP) {
            this.storage.setEnergyStored(nbt.func_74762_e("energy"));
        }
    }

    @Override
    public void writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        if (type == NBTHelper.SyncType.DROP) {
            nbt.func_74768_a("energy", this.storage.getEnergyStored());
        }
    }

    @Override
    public void addSyncParts(List<ISyncPart> parts) {
        super.addSyncParts(parts);
        parts.add(this.storage);
    }

    @Override
    public void onLoaded() {
        if (!this.field_145850_b.field_72995_K && SonarLoader.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && SonarLoader.ic2Loaded()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }
}

