/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.render;

import cpw.mods.fml.client.FMLClientHandler;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderPlanet {
    private static TextureManager renderEngine = FMLClientHandler.instance().getClient().field_71446_o;
    private static ResourceLocation textureEuropa = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/misc/planets/europa.png");
    private static ResourceLocation textureGanymede = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/misc/planets/ganymede.png");
    private static ResourceLocation textureIo = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/misc/planets/io.png");
    private static ResourceLocation textureSaturn = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/misc/planets/saturn.png");
    private static ResourceLocation textureJupiterInner = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/misc/planets/jupiterInner.png");
    private static ResourceLocation textureJupiterUpper = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/misc/planets/jupiterUpper.png");

    public static void renderPlanet(int textureId, float scale, float ticks, float relSize) {
        GL11.glBindTexture((int)3553, (int)textureId);
        float size = relSize / 70.0f * scale;
        ticks = (float)System.nanoTime() / 5.0E7f;
        RenderPlanet.drawTexturedRectUV(-size / 2.0f, -size / 2.0f, size, size, ticks);
    }

    public static void renderPlanet(ResourceLocation texture, float scale, float ticks, float relSize) {
        renderEngine.func_110577_a(texture);
        float size = relSize / 70.0f * scale;
        ticks = (float)System.nanoTime() / 5.0E7f;
        RenderPlanet.drawTexturedRectUV(-size / 2.0f, -size / 2.0f, size, size, ticks);
    }

    public static void renderID(int id, float scale, float ticks) {
        ResourceLocation texture;
        switch (id) {
            case 0: {
                texture = textureEuropa;
                break;
            }
            case 1: {
                texture = textureGanymede;
                break;
            }
            case 2: {
                texture = textureIo;
                break;
            }
            case 3: {
                texture = textureJupiterInner;
                break;
            }
            case 4: {
                texture = textureSaturn;
                break;
            }
            default: {
                texture = textureGanymede;
            }
        }
        if (id == 3) {
            float relSize = 48.0f;
            float size = relSize / 70.0f * scale;
            renderEngine.func_110577_a(texture);
            RenderPlanet.drawTexturedRectUV(-size / 2.0f, -size / 2.0f, size, size, ticks);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.001f);
            renderEngine.func_110577_a(textureJupiterUpper);
            RenderPlanet.drawTexturedRectUV(-(size *= 1.001f) / 2.0f, -size / 2.0f, size, size, ticks * 0.85f);
        } else {
            RenderPlanet.renderPlanet(texture, scale, ticks, 8.0f);
        }
    }

    public static void drawTexturedRectUV(float x, float y, float width, float height, float ticks) {
        for (int ysect = 0; ysect < 6; ++ysect) {
            float factor = 1.0f + MathHelper.func_76134_b((float)((7.5f + 10.0f * (float)ysect) / 62.0f));
            RenderPlanet.drawTexturedRectUVSixth(x, y, width, height, ticks / 1100.0f % 1.0f - (1.0f - factor) * 0.15f, (float)ysect / 6.0f, 0.16f * factor);
        }
    }

    public static void drawTexturedRectUVSixth(float x, float y, float width, float height, float prog, float y0, float span) {
        y0 /= 2.0f;
        if (prog < 0.0f) {
            prog += 1.0f;
        }
        prog = 1.0f - prog;
        float y1 = y0 + 0.083333336f;
        float y2 = 1.0f - y1;
        float y3 = 1.0f - y0;
        float yaa = y + height * y0;
        float yab = y + height * y1;
        float yba = y + height * y2;
        float ybb = y + height * y3;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (prog <= 1.0f - span) {
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)yab, 0.0, (double)prog, (double)y1);
            tessellator.func_78374_a((double)(x + width), (double)yab, 0.0, (double)(prog + span), (double)y1);
            tessellator.func_78374_a((double)(x + width), (double)yaa, 0.0, (double)(prog + span), (double)y0);
            tessellator.func_78374_a((double)x, (double)yaa, 0.0, (double)prog, (double)y0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)ybb, 0.0, (double)prog, (double)y3);
            tessellator.func_78374_a((double)(x + width), (double)ybb, 0.0, (double)(prog + span), (double)y3);
            tessellator.func_78374_a((double)(x + width), (double)yba, 0.0, (double)(prog + span), (double)y2);
            tessellator.func_78374_a((double)x, (double)yba, 0.0, (double)prog, (double)y2);
            tessellator.func_78381_a();
        } else {
            double xp = x + width * (1.0f - prog) / span;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)yab, 0.0, (double)prog, (double)y1);
            tessellator.func_78374_a(xp, (double)yab, 0.0, 1.0, (double)y1);
            tessellator.func_78374_a(xp, (double)yaa, 0.0, 1.0, (double)y0);
            tessellator.func_78374_a((double)x, (double)yaa, 0.0, (double)prog, (double)y0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)ybb, 0.0, (double)prog, (double)y3);
            tessellator.func_78374_a(xp, (double)ybb, 0.0, 1.0, (double)y3);
            tessellator.func_78374_a(xp, (double)yba, 0.0, 1.0, (double)y2);
            tessellator.func_78374_a((double)x, (double)yba, 0.0, (double)prog, (double)y2);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78374_a(xp, (double)yab, 0.0, 0.0, (double)y1);
            tessellator.func_78374_a((double)(x + width), (double)yab, 0.0, (double)(prog - 1.0f + span), (double)y1);
            tessellator.func_78374_a((double)(x + width), (double)yaa, 0.0, (double)(prog - 1.0f + span), (double)y0);
            tessellator.func_78374_a(xp, (double)yaa, 0.0, 0.0, (double)y0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78374_a(xp, (double)ybb, 0.0, 0.0, (double)y3);
            tessellator.func_78374_a((double)(x + width), (double)ybb, 0.0, (double)(prog - 1.0f + span), (double)y3);
            tessellator.func_78374_a((double)(x + width), (double)yba, 0.0, (double)(prog - 1.0f + span), (double)y2);
            tessellator.func_78374_a(xp, (double)yba, 0.0, 0.0, (double)y2);
            tessellator.func_78381_a();
        }
    }
}

