/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.tileentity;

import com.dynious.refinedrelocation.api.item.IItemRelocatorModule;
import com.dynious.refinedrelocation.api.relocator.IRelocatorModule;
import com.dynious.refinedrelocation.compat.FMPHelper;
import com.dynious.refinedrelocation.grid.relocator.RelocatorGridLogic;
import com.dynious.refinedrelocation.grid.relocator.RelocatorModuleRegistry;
import com.dynious.refinedrelocation.grid.relocator.RelocatorMultiModule;
import com.dynious.refinedrelocation.grid.relocator.TravellingItem;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.helper.DirectionHelper;
import com.dynious.refinedrelocation.helper.IOHelper;
import com.dynious.refinedrelocation.helper.ItemStackHelper;
import com.dynious.refinedrelocation.helper.LogHelper;
import com.dynious.refinedrelocation.lib.Mods;
import com.dynious.refinedrelocation.lib.Settings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.MessageItemList;
import com.dynious.refinedrelocation.tileentity.IRelocator;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import gnu.trove.map.TByteObjectMap;
import gnu.trove.map.hash.TByteObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRelocator
extends TileEntity
implements IRelocator,
ISidedInventory {
    public boolean shouldUpdate = true;
    public boolean isBeingPowered = false;
    private boolean isFirstTick = true;
    private boolean neighborChanged = false;
    private TileEntity[] inventories = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
    private IRelocator[] relocators = new IRelocator[ForgeDirection.VALID_DIRECTIONS.length];
    private IRelocatorModule[] modules = new IRelocatorModule[ForgeDirection.VALID_DIRECTIONS.length];
    private List<ItemStack>[] stuffedItems;
    private boolean[] isConnected = new boolean[6];
    private byte renderType = 0;
    private boolean[] isStuffed = new boolean[6];
    private TravellingItem cachedTravellingItem;
    private int maxStackSize = 64;
    private List<TravellingItem> items = new ArrayList<TravellingItem>();
    private List<TravellingItem> itemsToAdd = new ArrayList<TravellingItem>();
    private TByteObjectMap<StackAndCounter> cachedItems = new TByteObjectHashMap();
    private byte ticker = 0;
    private byte lastID = (byte)(new Random().nextInt(512) - 256);

    public TileRelocator() {
        this.stuffedItems = new ArrayList[ForgeDirection.VALID_DIRECTIONS.length];
        for (int i = 0; i < this.stuffedItems.length; ++i) {
            this.stuffedItems[i] = new ArrayList<ItemStack>();
        }
    }

    public static void markUpdate(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        if (Mods.IS_FMP_LOADED) {
            FMPHelper.updateBlock(world, x, y, z);
        } else {
            world.func_147471_g(x, y, z);
        }
    }

    public static void markUpdateAndNotify(World world, int x, int y, int z) {
        TileRelocator.markUpdate(world, x, y, z);
        world.func_147459_d(x, y, z, world.func_147439_a(x, y, z));
    }

    public void func_145845_h() {
        super.func_145845_h();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            this.modules[i].onUpdate(this, i);
        }
        if (this.field_145850_b.field_72995_K) {
            this.clientSideUpdate();
        } else {
            this.serverSideUpdate();
        }
    }

    private void serverSideUpdate() {
        if (this.isFirstTick) {
            this.discoverNeighbours();
            this.isFirstTick = false;
            this.neighborChanged = false;
        }
        if (this.neighborChanged) {
            this.neighborChangeUpdate();
            this.neighborChanged = false;
        }
        if (this.shouldUpdate) {
            TileRelocator.markUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.shouldUpdate = false;
        }
        if (!this.itemsToAdd.isEmpty()) {
            block0: for (TravellingItem item : this.itemsToAdd) {
                if (item.sync) {
                    item.id = this.lastID = (byte)(this.lastID + 1);
                    continue;
                }
                for (TravellingItem i : this.items) {
                    if (i.id != item.id) continue;
                    item.lastId = item.id;
                    item.id = this.lastID = (byte)(this.lastID + 1);
                    continue block0;
                }
            }
            this.items.addAll(this.itemsToAdd);
            NetworkHandler.INSTANCE.sendToAllAround((IMessage)new MessageItemList(this, this.itemsToAdd), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 16.0));
            for (TravellingItem item : this.itemsToAdd) {
                item.sync = false;
                item.lastId = null;
            }
            this.itemsToAdd.clear();
        }
        Iterator<TravellingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravellingItem item;
            item = iterator.next();
            item.counter = (byte)(item.counter + 1);
            if (item.counter > 10) {
                iterator.remove();
                this.outputToSide(item, item.onOutput());
                continue;
            }
            if (item.counter != 5 || this.connectsToSide(item.getOutputSide())) continue;
            iterator.remove();
            this.retryOutput(item, -1);
        }
        this.ticker = (byte)(this.ticker + 1);
        if (this.ticker >= Settings.RELOCATOR_MIN_TICKS_BETWEEN_EXTRACTION) {
            this.ticker = 0;
            for (int side = 0; side < this.stuffedItems.length; side = (int)((byte)(side + 1))) {
                if (this.stuffedItems[side].isEmpty()) continue;
                ArrayList<ItemStack> stacksUnableToAdd = new ArrayList<ItemStack>();
                ListIterator<ItemStack> iterator2 = this.stuffedItems[side].listIterator();
                while (iterator2.hasNext()) {
                    ItemStack stack = iterator2.next();
                    if (stacksUnableToAdd.contains(stack) || this.modules[side] != null && !this.modules[side].passesFilter(this, side, stack, false, true)) continue;
                    IRelocator relocator = this.getConnectedRelocators()[side];
                    if (relocator != null) {
                        IRelocatorModule module = relocator.getRelocatorModule(ForgeDirection.OPPOSITES[side]);
                        if (module == null || module.passesFilter(relocator, ForgeDirection.OPPOSITES[side], stack, true, true)) {
                            if (module != null && module.isItemDestination()) {
                                stack = module.receiveItemStack(relocator, ForgeDirection.OPPOSITES[side], stack.func_77946_l(), true, false);
                            } else {
                                TravellingItem item = RelocatorGridLogic.findOutput(stack, relocator, ForgeDirection.OPPOSITES[side]);
                                if (item != null) {
                                    stack.field_77994_a -= item.getStackSize();
                                    relocator.receiveTravellingItem(item);
                                }
                            }
                        }
                    } else {
                        stack = this.getRelocatorModule(side) != null ? this.getRelocatorModule(side).outputToSide(this, side, this.getConnectedInventories()[side], stack.func_77946_l(), false) : IOHelper.insert(this.getConnectedInventories()[side], stack.func_77946_l(), ForgeDirection.getOrientation((int)side).getOpposite(), false);
                    }
                    if (stack == null || stack.field_77994_a == 0) {
                        iterator2.remove();
                        continue;
                    }
                    iterator2.set(stack);
                    stacksUnableToAdd.add(stack.func_77946_l());
                }
                if (!this.stuffedItems[side].isEmpty()) continue;
                this.shouldUpdate = true;
            }
        }
        this.cachedTravellingItem = null;
        this.maxStackSize = 64;
    }

    private void clientSideUpdate() {
        Iterator<TravellingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravellingItem item = iterator.next();
            item.counter = (byte)(item.counter + 1);
            if (item.counter > 11) {
                iterator.remove();
                continue;
            }
            if (item.counter != 5) continue;
            this.cachedItems.put(item.id, (Object)new StackAndCounter(item.getItemStack()));
            if (this.connectsToSide(item.getOutputSide())) continue;
            iterator.remove();
        }
        iterator = this.cachedItems.valueCollection().iterator();
        while (iterator.hasNext()) {
            StackAndCounter stackAndCounter = (StackAndCounter)((Object)iterator.next());
            stackAndCounter.counter = (byte)(stackAndCounter.counter - 1);
            if (stackAndCounter.counter > 0) continue;
            iterator.remove();
        }
    }

    public void updateRedstone() {
        boolean newPowerState;
        boolean bl = newPowerState = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) || BlockHelper.isDirectlyPowered(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (newPowerState && !this.isBeingPowered || !newPowerState && this.isBeingPowered) {
            this.isBeingPowered = newPowerState;
            for (IRelocatorModule module : this.modules) {
                if (module == null) continue;
                module.onRedstonePowerChange(this.isBeingPowered);
            }
        }
    }

    @Override
    public boolean getRedstoneState() {
        return this.isBeingPowered;
    }

    public boolean shouldConnectToRedstone() {
        for (IRelocatorModule module : this.modules) {
            if (module == null || !module.connectsToRedstone()) continue;
            return true;
        }
        return false;
    }

    public int isProvidingStrongPower(int side) {
        for (IRelocatorModule module : this.modules) {
            if (module == null) continue;
            return module.strongRedstonePower(side);
        }
        return 0;
    }

    public boolean leftClick(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        int side = hit.subHit;
        if (side < 6 && this.isStuffedOnSide(side)) {
            for (int i = 0; i < Math.min(this.stuffedItems[side].size(), 5); ++i) {
                IOHelper.spawnItemInWorld(this.field_145850_b, this.stuffedItems[side].get(i), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            TileRelocator.markUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return false;
        }
        return true;
    }

    public boolean onActivated(EntityPlayer player, MovingObjectPosition hit, ItemStack stack) {
        if (hit.subHit < 6) {
            return this.sideHit(player, hit.subHit, stack);
        }
        return false;
    }

    public boolean sideHit(EntityPlayer player, int side, ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof IItemRelocatorModule && this.modules[side] == null) {
            IRelocatorModule module = ((IItemRelocatorModule)stack.func_77973_b()).getRelocatorModule(stack);
            if (module != null) {
                this.modules[side] = module;
                module.init(this, side);
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                TileRelocator.markUpdateAndNotify(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
        } else if (this.modules[side] != null) {
            if (player.func_70093_af()) {
                List<ItemStack> list = this.modules[side].getDrops(this, side);
                if (list != null && !player.field_71075_bZ.field_75098_d) {
                    for (ItemStack stack1 : list) {
                        IOHelper.spawnItemInWorld(this.field_145850_b, stack1, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    }
                }
                this.modules[side] = null;
                TileRelocator.markUpdateAndNotify(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return true;
            }
            return this.modules[side].onActivated(this, player, side, stack);
        }
        return false;
    }

    public void emptySide(int side) {
        TravellingItem item;
        if (this.modules[side] != null) {
            for (ItemStack stack : this.modules[side].getDrops(this, side)) {
                IOHelper.spawnItemInWorld(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.modules[side] = null;
        }
        if (this.stuffedItems[side] != null) {
            for (ItemStack stack : this.stuffedItems[side]) {
                IOHelper.spawnItemInWorld(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            this.stuffedItems[side].clear();
        }
        Iterator<TravellingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            item = iterator.next();
            if ((item.getInputSide() != side || item.counter >= 5) && (item.getOutputSide() != side || item.counter <= 5)) continue;
            IOHelper.spawnItemInWorld(this.field_145850_b, item.getItemStack(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            iterator.remove();
        }
        iterator = this.itemsToAdd.iterator();
        while (iterator.hasNext()) {
            item = iterator.next();
            if (item.getInputSide() != side) continue;
            IOHelper.spawnItemInWorld(this.field_145850_b, item.getItemStack(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
            iterator.remove();
        }
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (TravellingItem travellingItem : this.getItems(true)) {
            items.add(travellingItem.getItemStack());
        }
        for (int i = 0; i < this.modules.length; ++i) {
            IRelocatorModule module = this.modules[i];
            if (module == null) continue;
            items.addAll(module.getDrops(this, i));
        }
        for (List<ItemStack> stuffedItem : this.stuffedItems) {
            items.addAll(stuffedItem);
        }
        return items;
    }

    public void discoverNeighbours() {
        this.inventories = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        this.relocators = new IRelocator[ForgeDirection.VALID_DIRECTIONS.length];
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile;
            if (!((IRelocator)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e)).canConnectOnSide(direction.ordinal()) || (tile = DirectionHelper.getTileAtSide(this, direction)) == null) continue;
            if (tile instanceof IRelocator) {
                if (!((IRelocator)tile).canConnectOnSide(direction.getOpposite().ordinal())) continue;
                this.relocators[direction.ordinal()] = (IRelocator)tile;
                continue;
            }
            if (!IOHelper.canInterfaceWith(tile, direction.getOpposite())) continue;
            this.inventories[direction.ordinal()] = tile;
        }
    }

    public void onBlocksChanged() {
        this.neighborChanged = true;
    }

    private void neighborChangeUpdate() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.discoverNeighbours();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.relocators[direction.ordinal()] != null || this.inventories[direction.ordinal()] != null) continue;
            this.emptySide(direction.ordinal());
        }
        this.updateRedstone();
        TileRelocator.markUpdate(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public GuiScreen getGUI(int side, EntityPlayer player) {
        IRelocatorModule module = this.modules[side];
        if (module instanceof RelocatorMultiModule) {
            return ((RelocatorMultiModule)module).getCurrentModule().getGUI(this, side, player);
        }
        return module.getGUI(this, side, player);
    }

    @Override
    public Container getContainer(int side, EntityPlayer player) {
        IRelocatorModule module = this.modules[side];
        if (module instanceof RelocatorMultiModule) {
            return ((RelocatorMultiModule)module).getCurrentModule().getContainer(this, side, player);
        }
        return module.getContainer(this, side, player);
    }

    @Override
    public boolean canConnectOnSide(int side) {
        return true;
    }

    @Override
    public IRelocator[] getConnectedRelocators() {
        return this.relocators;
    }

    @Override
    public boolean passesFilter(ItemStack itemStack, int side, boolean input, boolean simulate) {
        return this.stuffedItems[side].isEmpty() && (this.modules[side] == null || this.modules[side].passesFilter(this, side, itemStack, input, simulate));
    }

    @Override
    public TileEntity[] getConnectedInventories() {
        return this.inventories;
    }

    @Override
    public List<TravellingItem> getItems(boolean includeItemsToAdd) {
        if (includeItemsToAdd) {
            ArrayList<TravellingItem> list = new ArrayList<TravellingItem>(this.items);
            list.addAll(this.itemsToAdd);
            return list;
        }
        return this.items;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public void receiveTravellingItem(TravellingItem item) {
        if (this.field_145850_b.field_72995_K) {
            if (!item.getPath().isEmpty()) {
                this.items.add(item);
            }
        } else if (item.getPath().isEmpty()) {
            this.retryOutput(item, item.input);
        } else {
            this.itemsToAdd.add(item);
        }
    }

    public void outputToSide(TravellingItem item, byte side) {
        if (this.modules[side] == null || this.modules[side].passesFilter(this, side, item.getItemStack(), false, false)) {
            if (this.modules[side] != null && this.modules[side].isItemDestination()) {
                ItemStack stack = this.modules[side].receiveItemStack(this, side, item.getItemStack(), false, false);
                if (stack != null && stack.field_77994_a > 0) {
                    item.getItemStack().field_77994_a = stack.field_77994_a;
                    this.retryOutput(item, side);
                }
                return;
            }
            IRelocator relocator = this.getConnectedRelocators()[side];
            if (relocator != null) {
                int side2 = ForgeDirection.OPPOSITES[side];
                IRelocatorModule module = relocator.getRelocatorModule(side2);
                if (module == null || module.passesFilter(relocator, side2, item.getItemStack(), true, false)) {
                    if (module != null && module.isItemDestination()) {
                        ItemStack stack = module.receiveItemStack(this, side, item.getItemStack(), true, false);
                        if (stack != null && stack.field_77994_a > 0) {
                            item.getItemStack().field_77994_a = stack.field_77994_a;
                            this.retryOutput(item, side);
                        }
                        return;
                    }
                    relocator.receiveTravellingItem(item);
                    return;
                }
            } else if (this.getConnectedInventories()[side] != null) {
                ItemStack stack = this.getRelocatorModule(side) != null ? this.getRelocatorModule(side).outputToSide(this, side, this.getConnectedInventories()[side], item.getItemStack().func_77946_l(), false) : IOHelper.insert(this.getConnectedInventories()[side], item.getItemStack().func_77946_l(), ForgeDirection.getOrientation((int)side).getOpposite(), false);
                if (stack != null && stack.field_77994_a > 0) {
                    item.getItemStack().field_77994_a = stack.field_77994_a;
                    this.retryOutput(item, side);
                }
                return;
            }
        }
        this.retryOutput(item, side);
    }

    public void retryOutput(TravellingItem item, int side) {
        ItemStack stack = item.getItemStack();
        TravellingItem travellingItem = RelocatorGridLogic.findOutput(item.getItemStack(), this, side);
        if (travellingItem != null) {
            this.receiveTravellingItem(travellingItem);
            stack.field_77994_a -= item.getStackSize();
            if (stack.field_77994_a <= 0) {
                stack = null;
            }
        }
        if (stack != null) {
            if (side != -1) {
                for (ItemStack stack1 : this.stuffedItems[side]) {
                    if (stack1.field_77994_a == stack1.func_77976_d() || !ItemStackHelper.areItemStacksEqual(stack1, stack)) continue;
                    int amount = Math.min(stack.field_77994_a, stack1.func_77976_d() - stack1.field_77994_a);
                    stack1.field_77994_a += amount;
                    stack.field_77994_a -= amount;
                    if (stack.field_77994_a != 0) continue;
                    stack = null;
                    break;
                }
                if (stack != null) {
                    if (this.stuffedItems[side].isEmpty()) {
                        this.shouldUpdate = true;
                    }
                    this.stuffedItems[side].add(stack);
                }
            } else {
                IOHelper.spawnItemInWorld(this.field_145850_b, stack, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    @Override
    public ItemStack insert(ItemStack itemStack, int side, boolean simulate) {
        TravellingItem item;
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return null;
        }
        if (this.passesFilter(itemStack, side, true, true) && (item = RelocatorGridLogic.findOutput(itemStack.func_77946_l(), this, side)) != null) {
            if (!simulate) {
                this.receiveTravellingItem(item);
            }
            itemStack.field_77994_a -= item.getStackSize();
            if (itemStack.field_77994_a <= 0) {
                return null;
            }
        }
        return itemStack;
    }

    @Override
    public boolean connectsToSide(int side) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return this.relocators[side] != null || this.inventories[side] != null;
        }
        return this.isConnected[side];
    }

    @Override
    public boolean isStuffedOnSide(int side) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return !this.stuffedItems[side].isEmpty();
        }
        return this.isStuffed[side];
    }

    @Override
    public IRelocatorModule getRelocatorModule(int side) {
        return this.modules[side];
    }

    public void func_145839_a(NBTTagCompound compound) {
        TravellingItem readTravellingStack;
        NBTTagCompound nbttagcompound1;
        int i;
        NBTTagList nbttaglist;
        super.func_145839_a(compound);
        this.isBeingPowered = compound.func_74767_n("redstone");
        if (compound.func_74764_b("Items")) {
            nbttaglist = compound.func_150295_c("Items", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                readTravellingStack = TravellingItem.createFromNBT(nbttagcompound1);
                if (readTravellingStack == null) continue;
                this.items.add(readTravellingStack);
            }
        }
        if (compound.func_74764_b("ItemsToAdd")) {
            nbttaglist = compound.func_150295_c("ItemsToAdd", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                readTravellingStack = TravellingItem.createFromNBT(nbttagcompound1);
                if (readTravellingStack == null) continue;
                this.itemsToAdd.add(readTravellingStack);
            }
        }
        if (compound.func_74764_b("StuffedItems")) {
            nbttaglist = compound.func_150295_c("StuffedItems", 10);
            for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
                nbttagcompound1 = nbttaglist.func_150305_b(i);
                byte side = nbttagcompound1.func_74771_c("Side");
                ItemStack readStack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
                if (readStack == null) continue;
                this.stuffedItems[side].add(readStack);
            }
        }
        this.readModules(compound, false);
    }

    public void func_145841_b(NBTTagCompound compound) {
        NBTTagCompound nbttagcompound1;
        NBTTagList nbttaglist;
        super.func_145841_b(compound);
        compound.func_74757_a("redstone", this.isBeingPowered);
        if (!this.items.isEmpty()) {
            nbttaglist = new NBTTagList();
            for (TravellingItem item : this.items) {
                if (item == null) continue;
                nbttagcompound1 = new NBTTagCompound();
                item.writeToNBT(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
        if (!this.itemsToAdd.isEmpty()) {
            nbttaglist = new NBTTagList();
            for (TravellingItem item : this.itemsToAdd) {
                if (item == null) continue;
                nbttagcompound1 = new NBTTagCompound();
                item.writeToNBT(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            compound.func_74782_a("ItemsToAdd", (NBTBase)nbttaglist);
        }
        nbttaglist = new NBTTagList();
        for (byte i = 0; i < this.stuffedItems.length; i = (byte)((byte)(i + 1))) {
            List<ItemStack> stuffedItemList = this.stuffedItems[i];
            if (stuffedItemList.isEmpty()) continue;
            for (ItemStack item : stuffedItemList) {
                if (item == null) continue;
                NBTTagCompound nbttagcompound12 = new NBTTagCompound();
                nbttagcompound12.func_74774_a("Side", i);
                item.func_77955_b(nbttagcompound12);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound12);
            }
        }
        compound.func_74782_a("StuffedItems", (NBTBase)nbttaglist);
        this.saveModules(compound, false);
    }

    public Packet func_145844_m() {
        int i;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("redstone", this.isBeingPowered);
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (!this.connectsToSide(i)) continue;
            tag.func_74757_a("c" + i, true);
        }
        this.saveModules(tag, true);
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (this.stuffedItems[i].isEmpty()) continue;
            tag.func_74757_a("s" + i, true);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        int i;
        NBTTagCompound tag = pkt.func_148857_g();
        this.isBeingPowered = tag.func_74767_n("redstone");
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.isConnected[i] = tag.func_74764_b("c" + i);
        }
        this.calculateRenderType();
        this.modules = new IRelocatorModule[ForgeDirection.VALID_DIRECTIONS.length];
        this.readModules(tag, true);
        for (i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.isStuffed[i] = tag.func_74764_b("s" + i);
        }
        this.removeFloatingItems();
    }

    public void saveModules(NBTTagCompound compound, boolean client) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.modules.length; ++i) {
            if (this.modules[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74778_a("clazzIdentifier", RelocatorModuleRegistry.getIdentifier(this.modules[i].getClass()));
            nbttagcompound1.func_74774_a("place", (byte)i);
            if (client) {
                this.modules[i].writeClientData(this, i, nbttagcompound1);
            } else {
                this.modules[i].writeToNBT(this, i, nbttagcompound1);
            }
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("modules", (NBTBase)nbttaglist);
    }

    public void readModules(NBTTagCompound compound, boolean client) {
        NBTTagList nbttaglist = compound.func_150295_c("modules", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte place = nbttagcompound1.func_74771_c("place");
            IRelocatorModule module = RelocatorModuleRegistry.getModule(nbttagcompound1.func_74779_i("clazzIdentifier"));
            if (module == null) continue;
            module.init(this, place);
            this.modules[place] = module;
            if (client) {
                this.modules[place].readClientData(this, i, nbttagcompound1);
                continue;
            }
            this.modules[place].readFromNBT(this, i, nbttagcompound1);
        }
    }

    public void calculateRenderType() {
        this.renderType = this.isConnected[0] && this.isConnected[1] && !this.isConnected[2] && !this.isConnected[3] && !this.isConnected[4] && !this.isConnected[5] ? (byte)1 : (!this.isConnected[0] && !this.isConnected[1] && this.isConnected[2] && this.isConnected[3] && !this.isConnected[4] && !this.isConnected[5] ? (byte)2 : (!this.isConnected[0] && !this.isConnected[1] && !this.isConnected[2] && !this.isConnected[3] && this.isConnected[4] && this.isConnected[5] ? (byte)3 : (byte)0));
    }

    @Override
    public byte getRenderType() {
        return this.renderType;
    }

    @Override
    public ItemStack getItemStackWithId(byte id) {
        if (this.field_145850_b.field_72995_K) {
            StackAndCounter item = (StackAndCounter)this.cachedItems.get(id);
            return item == null ? null : item.stack;
        }
        for (TravellingItem item : this.items) {
            if (item.id != id) continue;
            return item.getItemStack();
        }
        return null;
    }

    public void removeFloatingItems() {
        Iterator<TravellingItem> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            TravellingItem item = iterator.next();
            if ((item.counter - 1 >= 5 || this.connectsToSide(item.getInputSide() < 0 ? (byte)0 : item.getInputSide())) && (item.counter - 1 <= 5 || this.connectsToSide(item.getOutputSide()))) continue;
            iterator.remove();
        }
        for (int i = 0; i < this.isStuffed.length; ++i) {
            if (this.connectsToSide(i)) continue;
            this.isStuffed[i] = false;
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{side};
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return false;
        }
        if (this.connectsToSide(side) && this.passesFilter(itemStack, side, true, true)) {
            this.cachedTravellingItem = RelocatorGridLogic.findOutput(itemStack.func_77946_l(), this, side);
            if (this.cachedTravellingItem != null) {
                this.maxStackSize = this.cachedTravellingItem.getStackSize();
                return true;
            }
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return false;
    }

    public int func_70302_i_() {
        return 6;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int side, ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a == 0) {
            return;
        }
        ItemStack itemStackCopy = itemstack.func_77946_l();
        if (this.cachedTravellingItem != null && side == this.cachedTravellingItem.input && this.cachedTravellingItem.isItemSameAs(itemStackCopy)) {
            if (this.cachedTravellingItem.getStackSize() > itemStackCopy.field_77994_a) {
                this.cachedTravellingItem.getItemStack().field_77994_a = itemStackCopy.field_77994_a;
            }
            itemStackCopy.field_77994_a -= this.cachedTravellingItem.getStackSize();
            this.receiveTravellingItem(this.cachedTravellingItem);
        }
        if (itemStackCopy.field_77994_a > 0) {
            TravellingItem travellingItem = RelocatorGridLogic.findOutput(itemStackCopy.func_77946_l(), this, side);
            if (travellingItem != null) {
                itemStackCopy.field_77994_a -= travellingItem.getStackSize();
                if (itemStackCopy.field_77994_a > 0) {
                    travellingItem.getItemStack().field_77994_a += itemStackCopy.field_77994_a;
                }
                this.receiveTravellingItem(travellingItem);
            } else {
                TileEntity tile = DirectionHelper.getTileAtSide(this, ForgeDirection.getOrientation((int)side));
                LogHelper.warning(String.format("Tileentity at %s:%s:%s inserted ItemStack wrongly into Relocator!!", tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
                IOHelper.spawnItemInWorld(this.field_145850_b, itemStackCopy, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public String func_145825_b() {
        return "tile.relocator.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.maxStackSize;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return true;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.5, 0.5, 0.5);
    }

    @Optional.Method(modid="CoFHAPI|transport")
    public ItemStack insertItem(ForgeDirection forgeDirection, ItemStack itemStack) {
        return this.insert(itemStack, forgeDirection.ordinal(), false);
    }

    private static class StackAndCounter {
        public ItemStack stack;
        public byte counter = (byte)20;

        public StackAndCounter(ItemStack stack) {
            this.stack = stack;
        }
    }
}

