/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.item;

import com.dynious.refinedrelocation.RefinedRelocation;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.helper.BlockHelper;
import com.dynious.refinedrelocation.helper.DistanceHelper;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.IDisguisable;
import com.dynious.refinedrelocation.tileentity.ILinkable;
import com.dynious.refinedrelocation.tileentity.TileWirelessBlockExtender;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemLinker
extends Item {
    private IIcon iconUnlinked;
    private IIcon iconLink;
    private IIcon iconCopy;

    public ItemLinker() {
        this.func_77655_b("linker");
        this.func_77637_a(RefinedRelocation.tabRefinedRelocation);
        this.func_77625_d(1);
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item.linker" + this.getMode(itemStack);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean flag) {
        if (this.isLinked(itemStack)) {
            NBTTagCompound linkCompound = itemStack.func_77978_p().func_74775_l("Link");
            int linkedX = linkCompound.func_74762_e("tileX");
            int linkedY = linkCompound.func_74762_e("tileY");
            int linkedZ = linkCompound.func_74762_e("tileZ");
            Block linkedBlock = entityPlayer.func_130014_f_().func_147439_a(linkedX, linkedY, linkedZ);
            int linkedMetadata = entityPlayer.func_130014_f_().func_72805_g(linkedX, linkedY, linkedZ);
            list.add("\u00a7a" + StatCollector.func_74838_a((String)Strings.LINKED_POS) + " \u00a7f" + linkedX + ", " + linkedY + ", " + linkedZ + " (" + BlockHelper.getBlockDisplayName(linkedBlock, linkedMetadata) + ")");
        } else {
            list.add(StatCollector.func_74838_a((String)Strings.UNLINKED));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            String[] tooltipLines;
            for (String s : tooltipLines = StatCollector.func_74838_a((String)(this.func_77658_a() + ".tooltip")).split("\\\\n")) {
                list.add("\u00a73" + s);
            }
        } else {
            list.add("\u00a76" + StatCollector.func_74838_a((String)Strings.TOOLTIP_SHIFT));
        }
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        int mode = this.getMode(itemStack);
        if (mode == 0) {
            if (tileEntity instanceof IDisguisable && ((IDisguisable)tileEntity).canDisguise()) {
                IDisguisable disguisable = (IDisguisable)tileEntity;
                Block block = world.func_147439_a(x, y, z);
                int metadata = world.func_72805_g(x, y, z);
                if (this.isLinked(itemStack)) {
                    NBTTagCompound linkCompound = itemStack.func_77978_p().func_74775_l("Link");
                    int linkedX = linkCompound.func_74762_e("tileX");
                    int linkedY = linkCompound.func_74762_e("tileY");
                    int linkedZ = linkCompound.func_74762_e("tileZ");
                    Block linkedBlock = world.func_147439_a(linkedX, linkedY, linkedZ);
                    int linkedMetadata = world.func_72805_g(linkedX, linkedY, linkedZ);
                    TileEntity linkedTile = world.func_147438_o(linkedX, linkedY, linkedZ);
                    if (linkedTile != null && linkedTile instanceof IDisguisable) {
                        linkedBlock = ((IDisguisable)linkedTile).getDisguise();
                        linkedMetadata = ((IDisguisable)linkedTile).getDisguiseMeta();
                    }
                    if (linkedBlock != null && disguisable.canDisguiseAs(linkedBlock, linkedMetadata)) {
                        disguisable.setDisguise(linkedBlock, linkedMetadata);
                        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.DISGUISED_AS, (Object[])new Object[]{BlockHelper.getBlockDisplayName(block, metadata), BlockHelper.getBlockDisplayName(linkedBlock, linkedMetadata)})));
                    } else {
                        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.CANNOT_DISGUISE_AS, (Object[])new Object[]{BlockHelper.getBlockDisplayName(linkedBlock, linkedMetadata)})));
                    }
                    return true;
                }
                if (disguisable.getDisguise() != null) {
                    disguisable.clearDisguise();
                    entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.UNDISGUISED) + " " + BlockHelper.getBlockDisplayName(block, metadata)));
                    return true;
                }
            } else if (tileEntity instanceof ILinkable) {
                ILinkable linkable = (ILinkable)tileEntity;
                if (this.isLinked(itemStack)) {
                    NBTTagCompound linkCompound = itemStack.func_77978_p().func_74775_l("Link");
                    int linkedX = linkCompound.func_74762_e("tileX");
                    int linkedY = linkCompound.func_74762_e("tileY");
                    int linkedZ = linkCompound.func_74762_e("tileZ");
                    Block linkedBlock = world.func_147439_a(linkedX, linkedY, linkedZ);
                    int linkedMetadata = world.func_72805_g(linkedX, linkedY, linkedZ);
                    if (x == linkedX && y == linkedY && z == linkedZ) {
                        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.NO_LINK_TO_SELF)));
                        return true;
                    }
                    if (linkable.getMaxLinkRange() > 0 && (double)DistanceHelper.getDistanceSq(x, y, z, linkedX, linkedY, linkedZ) > Math.pow(linkable.getMaxLinkRange(), 2.0)) {
                        String tileDisplayName = BlockHelper.getTileEntityDisplayName(tileEntity);
                        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.TOO_FAR, (Object[])new Object[]{tileDisplayName, linkable.getMaxLinkRange()})));
                        return true;
                    }
                    linkable.linkTo(world, linkedX, linkedY, linkedZ, entityPlayer);
                    String tileDisplayName = BlockHelper.getTileEntityDisplayName(tileEntity);
                    String blockDisplayName = BlockHelper.getBlockDisplayName(linkedBlock, linkedMetadata);
                    entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.LINKED_WITH, (Object[])new Object[]{tileDisplayName, blockDisplayName, linkedX, linkedY, linkedZ})));
                    return true;
                }
                if (linkable.isLinked()) {
                    linkable.clearLink(entityPlayer);
                    String tileDisplayName = BlockHelper.getTileEntityDisplayName(tileEntity);
                    entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.NO_LONGER_LINKED, (Object[])new Object[]{tileDisplayName})));
                    return true;
                }
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.NO_LINK)));
                return true;
            }
            return true;
        }
        if (mode == 1) {
            if (!(tileEntity instanceof IFilterTileGUI)) {
                return false;
            }
            IFilterTileGUI multiFilter = (IFilterTileGUI)tileEntity;
            if (this.isLinked(itemStack)) {
                if (multiFilter.getFilter().getFilterCount() > 0) {
                    entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.CANNOT_COPY_NOT_EMPTY)));
                    return true;
                }
                NBTTagCompound linkCompound = itemStack.func_77978_p().func_74775_l("Link");
                int linkedX = linkCompound.func_74762_e("tileX");
                int linkedY = linkCompound.func_74762_e("tileY");
                int linkedZ = linkCompound.func_74762_e("tileZ");
                Block linkedBlock = world.func_147439_a(linkedX, linkedY, linkedZ);
                int linkedMetadata = world.func_72805_g(linkedX, linkedY, linkedZ);
                TileEntity linkedTile = world.func_147438_o(linkedX, linkedY, linkedZ);
                if (!(linkedTile instanceof IFilterTileGUI)) {
                    entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)Strings.CANNOT_COPY_NO_LINK)));
                    this.unlink(itemStack);
                    return true;
                }
                IFilterTileGUI linkedMultiFilter = (IFilterTileGUI)linkedTile;
                NBTTagCompound copyCompound = new NBTTagCompound();
                linkedMultiFilter.getFilter().writeToNBT(copyCompound);
                multiFilter.getFilter().readFromNBT(copyCompound);
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.COPIED_FROM, (Object[])new Object[]{BlockHelper.getBlockDisplayName(linkedBlock, linkedMetadata), BlockHelper.getBlockDisplayName(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z))})));
                return true;
            }
            entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.CANNOT_COPY_NO_LINK, (Object[])new Object[0])));
            return true;
        }
        return false;
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!entityPlayer.func_70093_af()) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        TileEntity tile = world.func_147438_o(x, y, z);
        int mode = this.getMode(itemStack);
        if (mode == 0) {
            if (tile instanceof TileWirelessBlockExtender) {
                return true;
            }
        } else if (mode == 1) {
            if (!(tile instanceof IFilterTileGUI)) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.CANNOT_COPY_INVALID, (Object[])new Object[]{x, y, z, BlockHelper.getBlockDisplayName(block, metadata)})));
                return true;
            }
            if (((IFilterTileGUI)tile).getFilter().getFilterCount() == 0) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.CANNOT_COPY_INVALID, (Object[])new Object[]{x, y, z, BlockHelper.getBlockDisplayName(block, metadata)})));
                return true;
            }
        }
        this.linkTileAtPosition(itemStack, x, y, z);
        entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.LINKER_SET, (Object[])new Object[]{x, y, z, BlockHelper.getBlockDisplayName(block, metadata)})));
        return true;
    }

    private void linkTileAtPosition(ItemStack itemStack, int x, int y, int z) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("tileX", x);
        tagCompound.func_74768_a("tileY", y);
        tagCompound.func_74768_a("tileZ", z);
        itemStack.func_77978_p().func_74782_a("Link", (NBTBase)tagCompound);
    }

    private void setMode(ItemStack itemStack, int mode) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74774_a("Mode", (byte)mode);
    }

    private int getMode(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return itemStack.func_77978_p().func_74771_c("Mode");
        }
        return 0;
    }

    private void unlink(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_82580_o("Link");
        }
    }

    public boolean isLinked(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("Link");
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (entityPlayer.func_70093_af()) {
            ItemStack newItemStack = itemStack.func_77946_l();
            this.unlink(newItemStack);
            switch (this.getMode(newItemStack)) {
                case 0: {
                    this.setMode(newItemStack, 1);
                    break;
                }
                case 1: {
                    this.setMode(newItemStack, 0);
                }
            }
            return newItemStack;
        }
        if (this.isLinked(itemStack)) {
            entityPlayer.func_71038_i();
            this.unlink(itemStack);
            if (world.field_72995_K) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)Strings.NO_LONGER_LINKED, (Object[])new Object[]{this.func_77653_i(itemStack)})));
            }
            return itemStack;
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = this.iconLink = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "linker" + "_link");
        this.iconUnlinked = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "linker" + "_unlinked");
        this.iconCopy = iconRegister.func_94245_a(Resources.MOD_ID + ":" + "linker" + "_copy");
    }

    public IIcon getIcon(ItemStack itemStack, int pass) {
        return this.func_77650_f(itemStack);
    }

    public IIcon func_77650_f(ItemStack itemStack) {
        switch (this.getMode(itemStack)) {
            case 0: {
                return this.iconLink;
            }
            case 1: {
                return this.iconCopy;
            }
        }
        return this.iconUnlinked;
    }
}

