/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.helper;

import com.dynious.refinedrelocation.lib.Strings;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHelper {
    public static final String nullBlockString = StatCollector.func_74838_a((String)Strings.AIR);

    @SideOnly(value=Side.CLIENT)
    public static String getBlockDisplayName(World world, int x, int y, int z, ForgeDirection side) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            Vec3 endpos;
            Vec3 midpos = Vec3.func_72443_a((double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5));
            ForgeDirection opposite = side.getOpposite();
            Vec3 startpos = midpos.func_72441_c((double)opposite.offsetX * 0.5, (double)opposite.offsetY * 0.5, (double)opposite.offsetZ * 0.5);
            MovingObjectPosition hit = world.func_72933_a(startpos, endpos = midpos.func_72441_c((double)side.offsetX * 0.5, (double)side.offsetY * 0.5, (double)side.offsetZ * 0.5));
            if (hit != null) {
                try {
                    ItemStack pickedItemStack = block.getPickBlock(hit, world, x, y, z);
                    if (pickedItemStack != null) {
                        return BlockHelper.getItemStackDisplayName(pickedItemStack);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return BlockHelper.getBlockDisplayName(world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public static String getBlockDisplayName(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null) {
            ArrayList dropped;
            Vec3 endpos;
            Vec3 startpos = Vec3.func_72443_a((double)x, (double)y, (double)z);
            MovingObjectPosition hit = world.func_72933_a(startpos, endpos = Vec3.func_72443_a((double)(x + 1), (double)(y + 1), (double)(z + 1)));
            if (hit != null) {
                try {
                    ItemStack pickedItemStack = block.getPickBlock(hit, world, x, y, z);
                    if (pickedItemStack != null) {
                        return BlockHelper.getItemStackDisplayName(pickedItemStack);
                    }
                }
                catch (Exception pickedItemStack) {
                    // empty catch block
                }
            }
            if ((dropped = block.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0)) != null && !dropped.isEmpty()) {
                Collections.sort(dropped, new Comparator<ItemStack>(){

                    @Override
                    public int compare(ItemStack stack0, ItemStack stack1) {
                        return stack1.func_77960_j() - stack0.func_77960_j();
                    }
                });
                return BlockHelper.getItemStackDisplayName((ItemStack)dropped.get(0));
            }
            return BlockHelper.getBlockDisplayName(block, world.func_72805_g(x, y, z));
        }
        return nullBlockString;
    }

    public static String getTileEntityDisplayName(TileEntity tile) {
        if (tile != null) {
            return BlockHelper.getBlockDisplayName(tile.field_145854_h, tile.field_145847_g);
        }
        return nullBlockString;
    }

    public static String getBlockDisplayName(Block block, int blockMeta) {
        if (block != null) {
            ItemStack itemstack = new ItemStack(block, 1, blockMeta);
            return BlockHelper.getItemStackDisplayName(itemstack);
        }
        return nullBlockString;
    }

    public static String getItemStackDisplayName(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77973_b() != null) {
            return itemstack.func_82833_r();
        }
        return nullBlockString;
    }

    public static boolean isDirectlyPowered(World world, int x, int y, int z) {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (world.func_72879_k(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ, direction.getOpposite().ordinal()) > 0) {
                return true;
            }
            if (direction == ForgeDirection.DOWN || world.func_147439_a(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ) != Blocks.field_150488_af || world.func_72805_g(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ) <= 0) continue;
            return true;
        }
        return false;
    }
}

