/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid.relocator;

import com.dynious.refinedrelocation.api.relocator.IItemRelocator;
import com.dynious.refinedrelocation.api.relocator.RelocatorModuleBase;
import com.dynious.refinedrelocation.item.ModItems;
import com.dynious.refinedrelocation.lib.Resources;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileRelocator;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class RelocatorModuleRedstoneBlock
extends RelocatorModuleBase {
    private static IIcon[] icons = new IIcon[4];
    private boolean blockOnSignal = true;

    public RelocatorModuleRedstoneBlock() {
        super(new ItemStack((Item)ModItems.relocatorModule, 1, 7));
    }

    @Override
    public boolean passesFilter(IItemRelocator relocator, int side, ItemStack stack, boolean input, boolean simulate) {
        return this.blockOnSignal ? !relocator.getRedstoneState() : relocator.getRedstoneState();
    }

    @Override
    public boolean onActivated(IItemRelocator relocator, EntityPlayer player, int side, ItemStack stack) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        this.blockOnSignal = !this.blockOnSignal;
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)(this.blockOnSignal ? Strings.REDSTONE_BLOCK_ENABLED_CHAT : Strings.REDSTONE_BLOCK_DISABLED_CHAT))));
        TileRelocator.markUpdate(relocator.getTileEntity().func_145831_w(), relocator.getTileEntity().field_145851_c, relocator.getTileEntity().field_145848_d, relocator.getTileEntity().field_145849_e);
        return true;
    }

    @Override
    public boolean connectsToRedstone() {
        return true;
    }

    @Override
    public List<ItemStack> getDrops(IItemRelocator relocator, int side) {
        return Arrays.asList(new ItemStack((Item)ModItems.relocatorModule, 1, 7));
    }

    @Override
    public void readFromNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        this.blockOnSignal = compound.func_74767_n("blockOnSignal");
    }

    @Override
    public void writeToNBT(IItemRelocator relocator, int side, NBTTagCompound compound) {
        compound.func_74757_a("blockOnSignal", this.blockOnSignal);
    }

    @Override
    public void readClientData(IItemRelocator relocator, int side, NBTTagCompound compound) {
        this.readFromNBT(relocator, side, compound);
    }

    @Override
    public void writeClientData(IItemRelocator relocator, int side, NBTTagCompound compound) {
        this.writeToNBT(relocator, side, compound);
    }

    @Override
    public IIcon getIcon(IItemRelocator relocator, int side) {
        return relocator.getRedstoneState() ? (this.blockOnSignal ? icons[0] : icons[1]) : (this.blockOnSignal ? icons[2] : icons[3]);
    }

    @Override
    public void registerIcons(IIconRegister register) {
        RelocatorModuleRedstoneBlock.icons[0] = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleRedstoneBlockRSBlock");
        RelocatorModuleRedstoneBlock.icons[1] = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleRedstoneBlockRSPass");
        RelocatorModuleRedstoneBlock.icons[2] = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleRedstoneBlockPass");
        RelocatorModuleRedstoneBlock.icons[3] = register.func_94245_a(Resources.MOD_ID + ":relocatorModuleRedstoneBlockBlock");
    }

    @Override
    public String getDisplayName() {
        return StatCollector.func_74838_a((String)"item.relocatorModule7.name");
    }

    @Override
    public List<String> getWailaInformation(NBTTagCompound nbtData) {
        List<String> information = super.getWailaInformation(nbtData);
        information.add(StatCollector.func_74838_a((String)(nbtData.func_74767_n("blockOnSignal") ? Strings.REDSTONE_BLOCK_ENABLED : Strings.REDSTONE_BLOCK_DISABLED)));
        return information;
    }
}

