/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.grid;

import com.dynious.refinedrelocation.api.filter.IMultiFilter;
import com.dynious.refinedrelocation.api.filter.IMultiFilterChild;
import com.dynious.refinedrelocation.api.tileentity.IFilterTileGUI;
import com.dynious.refinedrelocation.grid.filter.CreativeTabFilter;
import com.dynious.refinedrelocation.grid.filter.CustomUserFilter;
import com.dynious.refinedrelocation.grid.filter.MultiFilterRegistry;
import com.dynious.refinedrelocation.grid.filter.PresetFilter;
import com.dynious.refinedrelocation.helper.StringHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.network.NetworkHandler;
import com.dynious.refinedrelocation.network.packet.filter.MessageSetFilterBoolean;
import com.dynious.refinedrelocation.network.packet.filter.MessageSetFilterBooleanArray;
import com.dynious.refinedrelocation.network.packet.filter.MessageSetFilterString;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class MultiFilter
implements IMultiFilter {
    private IFilterTileGUI tile;
    private boolean isDirty;
    private List<IMultiFilterChild> filterList = new ArrayList<IMultiFilterChild>();

    public MultiFilter(IFilterTileGUI tile) {
        this.tile = tile;
    }

    public static String[] getOreNames(ItemStack itemStack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)itemStack);
        String[] oreNames = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            oreNames[i] = OreDictionary.getOreName((int)ids[i]).toLowerCase().replaceAll("\\s+", "");
        }
        return oreNames;
    }

    @Override
    public boolean passesFilter(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (this.filterList.isEmpty()) {
            return true;
        }
        boolean passses = false;
        for (int i = 0; i < this.filterList.size(); ++i) {
            IMultiFilterChild filter = this.filterList.get(i);
            if (!filter.isInFilter(itemStack)) continue;
            passses = !filter.isBlacklist();
        }
        return passses;
    }

    @Override
    public void filterChanged() {
        this.tile.onFilterChanged();
    }

    @Override
    public List<String> getWAILAInformation(NBTTagCompound nbtData) {
        ArrayList<String> filter = new ArrayList<String>();
        filter.add(StringHelper.getLocalizedString(Strings.MODE) + ": " + (nbtData.func_74767_n("isBlacklisting") ? StringHelper.getLocalizedString(Strings.BLACKLIST) : StringHelper.getLocalizedString(Strings.WHITELIST)));
        return filter;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74774_a("version", (byte)1);
        NBTTagList tagFilterList = new NBTTagList();
        for (IMultiFilterChild filter : this.filterList) {
            NBTTagCompound tagFilter = new NBTTagCompound();
            tagFilter.func_74778_a("type", filter.getTypeName());
            filter.writeToNBT(tagFilter);
            tagFilterList.func_74742_a((NBTBase)tagFilter);
        }
        compound.func_74782_a("filterList", (NBTBase)tagFilterList);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.filterList.clear();
        if (compound.func_74771_c("version") >= 1) {
            NBTTagList tagFilterList = compound.func_150295_c("filterList", 10);
            for (int i = 0; i < tagFilterList.func_74745_c(); ++i) {
                NBTTagCompound tagFilter = tagFilterList.func_150305_b(i);
                String filterType = tagFilter.func_74779_i("type");
                IMultiFilterChild filter = MultiFilterRegistry.getFilter(filterType);
                if (filter == null) continue;
                filter.setParentFilter(this, this.filterList.size());
                filter.readFromNBT(tagFilter);
                this.filterList.add(filter);
            }
        } else {
            boolean isBlacklisting = compound.func_74767_n("blacklists");
            String userFilterString = compound.func_74779_i("userFilter");
            if (!userFilterString.isEmpty()) {
                userFilterString = userFilterString.replace(',', '\n');
                CustomUserFilter userFilter = new CustomUserFilter();
                userFilter.setParentFilter(this, this.filterList.size());
                userFilter.setValue(userFilterString);
                userFilter.setBlacklist(isBlacklisting);
                this.filterList.add(userFilter);
            }
            PresetFilter presetFilter = new PresetFilter();
            presetFilter.setParentFilter(this, this.filterList.size());
            boolean foundActive = false;
            for (int i = 0; i < 14; ++i) {
                if (!compound.func_74767_n("cumstomFilters" + i)) continue;
                foundActive = true;
                presetFilter.setValue(i, true);
            }
            if (foundActive) {
                presetFilter.setBlacklist(isBlacklisting);
                this.filterList.add(presetFilter);
            }
            String creativeTabFilters = compound.func_74779_i("filters");
            CreativeTabFilter creativeTabFilter = new CreativeTabFilter();
            creativeTabFilter.setParentFilter(this, this.filterList.size());
            foundActive = false;
            for (String string : creativeTabFilters.split("\\^\\$")) {
                for (int i = 0; i < CreativeTabFilter.serverSideTabLabels.length; ++i) {
                    if (!string.equals(CreativeTabFilter.serverSideTabLabels[i])) continue;
                    creativeTabFilter.setValue(i, true);
                    foundActive = true;
                }
            }
            if (foundActive) {
                creativeTabFilter.setBlacklist(isBlacklisting);
                this.filterList.add(creativeTabFilter);
            } else {
                int i = 0;
                while (compound.func_74764_b("creativeTabs" + i)) {
                    if (compound.func_74767_n("creativeTabs" + i)) {
                        creativeTabFilter.setValue(i, true);
                        foundActive = true;
                    }
                    ++i;
                }
                if (foundActive) {
                    creativeTabFilter.setBlacklist(isBlacklisting);
                    this.filterList.add(creativeTabFilter);
                }
            }
        }
    }

    @Override
    public int getFilterCount() {
        return this.filterList.size();
    }

    @Override
    public IMultiFilterChild getFilterAtIndex(int index) {
        return this.filterList.get(index);
    }

    @Override
    public IFilterTileGUI getFilterTile() {
        return this.tile;
    }

    @Override
    public void setFilterType(int filterIndex, String filterType) {
        if (filterIndex == -1) {
            filterIndex = this.filterList.size();
        } else if (filterIndex < this.filterList.size() && this.filterList.get(filterIndex).getTypeName().equals(filterType)) {
            return;
        }
        if (filterType.isEmpty()) {
            this.filterList.remove(filterIndex);
            for (int i = filterIndex; i < this.filterList.size(); ++i) {
                this.filterList.get(i).setParentFilter(this, i);
            }
            this.markDirty(true);
        } else {
            IMultiFilterChild filter = MultiFilterRegistry.getFilter(filterType);
            if (filter != null) {
                filter.setParentFilter(this, filterIndex);
                this.markDirty(true);
                if (filterIndex < this.filterList.size()) {
                    this.filterList.set(filterIndex, filter);
                } else {
                    this.filterList.add(filter);
                }
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void markDirty(boolean dirty) {
        this.isDirty = dirty;
        this.filterChanged();
    }

    @Override
    public void sendStringToPlayer(IMultiFilterChild receiver, EntityPlayerMP player, int index, String value) {
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSetFilterString(receiver.getFilterIndex(), index, value), player);
    }

    @Override
    public void sendStringToServer(IMultiFilterChild receiver, int index, String value) {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSetFilterString(receiver.getFilterIndex(), index, value));
    }

    @Override
    public void sendBooleanToPlayer(IMultiFilterChild receiver, EntityPlayerMP player, int index, boolean value) {
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSetFilterBoolean(receiver.getFilterIndex(), index, value), player);
    }

    @Override
    public void sendBooleanToServer(IMultiFilterChild receiver, int index, boolean value) {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSetFilterBoolean(receiver.getFilterIndex(), index, value));
    }

    @Override
    public void sendBooleanArrayToPlayer(IMultiFilterChild receiver, EntityPlayerMP player, int index, boolean[] value) {
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageSetFilterBooleanArray(receiver.getFilterIndex(), index, value), player);
    }

    @Override
    public void sendBooleanArrayToServer(IMultiFilterChild receiver, int index, boolean[] value) {
        NetworkHandler.INSTANCE.sendToServer((IMessage)new MessageSetFilterBooleanArray(receiver.getFilterIndex(), index, value));
    }
}

