/*
 * Decompiled with CFR 0.152.
 */
package com.dynious.refinedrelocation.client.gui.widget.button;

import com.dynious.refinedrelocation.client.gui.IGuiParent;
import com.dynious.refinedrelocation.client.gui.widget.button.GuiButtonToggle;
import com.dynious.refinedrelocation.helper.GuiHelper;
import com.dynious.refinedrelocation.lib.Strings;
import com.dynious.refinedrelocation.tileentity.TileBlockExtender;
import java.util.List;
import net.minecraft.util.StatCollector;

public class GuiButtonRedstoneSignalStatus
extends GuiButtonToggle {
    protected TileBlockExtender tile;

    public GuiButtonRedstoneSignalStatus(IGuiParent parent, int x, int y, TileBlockExtender tile) {
        super(parent, x, y, 24, 20, "button_redstone_inactive", "button_redstone_active", null, null);
        this.tile = tile;
        this.update();
        this.setAdventureModeRestriction(true);
    }

    @Override
    public void getTooltip(List<String> tooltip, int mouseX, int mouseY) {
        super.getTooltip(tooltip, mouseX, mouseY);
        if (this.isInsideBounds(mouseX, mouseY)) {
            String[] tooltipLines;
            tooltip.add(StatCollector.func_74838_a((String)Strings.REDSTONE_TRANSMISSION));
            for (String tooltipLine : tooltipLines = StatCollector.func_74838_a((String)(this.tile.isRedstoneTransmissionEnabled() ? Strings.REDSTONE_TRANSMISSION_ON_DESC : Strings.REDSTONE_TRANSMISSION_OFF_DESC)).split("\\\\n")) {
                tooltip.add("\u00a77" + tooltipLine);
            }
            tooltip.add("\u00a7e" + StatCollector.func_74838_a((String)Strings.CLICK_TO_TOGGLE));
        }
    }

    @Override
    protected void onStateChangedByUser(boolean newState) {
        if (this.tile == null) {
            return;
        }
        this.tile.setRedstoneTransmissionEnabled(newState);
        GuiHelper.sendBooleanMessage(9, newState);
    }

    @Override
    public void update() {
        if (this.tile != null) {
            this.setState(this.tile.isRedstoneTransmissionEnabled());
        }
        super.update();
    }
}

