/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common;

import appeng.api.AEApi;
import appeng.api.movable.IMovableRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.common.config.ConfigItems;
import thaumicenergistics.common.blocks.BlockEnum;
import thaumicenergistics.common.fluids.GaseousEssentia;
import thaumicenergistics.common.items.ItemEnum;
import thaumicenergistics.common.items.ItemMaterial;
import thaumicenergistics.common.registries.FeatureRegistry;
import thaumicenergistics.common.tiles.TileEnum;

public class CommonProxy {
    public void registerBlocks() {
        for (BlockEnum block : BlockEnum.VALUES) {
            GameRegistry.registerBlock((Block)block.getBlock(), block.itemBlockClass, (String)block.getUnlocalizedName());
        }
    }

    public void registerFeatures() {
        FeatureRegistry.instance().registerFeatures();
    }

    public void registerFluids() {
        GaseousEssentia.registerGases();
    }

    public void registerItems() {
        for (ItemEnum item : ItemEnum.VALUES) {
            GameRegistry.registerItem((Item)item.getItem(), (String)item.getInternalName());
        }
        OreDictionary.registerOre((String)"gearIron", (ItemStack)ItemMaterial.MaterialTypes.IRON_GEAR.getStack());
        OreDictionary.registerOre((String)"materialAspectShard", (ItemStack)new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE));
    }

    public void registerRenderers() {
    }

    public void registerSpatialIOMovables() {
        IMovableRegistry movableRegistry = AEApi.instance().registries().movable();
        for (TileEnum tile : TileEnum.values()) {
            movableRegistry.whiteListTileEntity(tile.getTileClass());
        }
    }

    public void registerTileEntities() {
        for (TileEnum tile : TileEnum.values()) {
            GameRegistry.registerTileEntity((Class)tile.getTileClass(), (String)tile.getTileID());
        }
    }
}

