/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.structure.util;

import java.util.LinkedList;
import java.util.List;

public class Structure {
    public final String name;
    private final List<int[][][][]> blockArrayList = new LinkedList<int[][][][]>();
    private int facing = 3;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;

    public Structure() {
        this.name = "";
    }

    public Structure(String n) {
        this.name = n;
    }

    public final List<int[][][][]> blockArrayList() {
        return this.blockArrayList;
    }

    public final int getFacing() {
        return this.facing;
    }

    public final void setFacing(int f) {
        this.facing = f;
    }

    public final void addBlockArray(int[][][][] blocks) {
        this.blockArrayList.add(blocks);
    }

    public final void addBlockArrayList(List<int[][][][]> list) {
        this.blockArrayList.addAll(list);
    }

    public final int getWidthX() {
        return this.blockArrayList.size() > 0 ? this.blockArrayList.get(0)[0].length : 0;
    }

    public final int getWidthZ() {
        return this.blockArrayList != null ? this.blockArrayList.get(0)[0][0].length : 0;
    }

    public final int getHeight() {
        int sum = 0;
        for (int[][][][] blockArray : this.blockArrayList) {
            sum += blockArray.length;
        }
        return sum;
    }

    public final int getOffsetX() {
        return this.offsetX;
    }

    public final int getOffsetY() {
        return this.offsetY;
    }

    public final int getOffsetZ() {
        return this.offsetZ;
    }

    public final void setStructureOffset(int x, int y, int z) {
        this.offsetX = x;
        this.offsetZ = z;
        this.offsetY = y;
    }
}

