/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.vec;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.vec.Vec3d;

public class ImmutableVec3d
extends Vec3d {
    private Block b;
    private int meta;
    private World w;
    private TileEntity te;

    protected ImmutableVec3d(Vec3d v) {
        super(v.x, v.y, v.z, v.getWorld());
        if (v instanceof ImmutableVec3d) {
            this.b = ((ImmutableVec3d)v).b;
            this.meta = ((ImmutableVec3d)v).meta;
            this.w = ((ImmutableVec3d)v).w;
            this.te = ((ImmutableVec3d)v).te;
        } else {
            this.b = v.getBlock();
            this.meta = v.getBlockMeta();
            this.w = v.getWorld();
            this.te = v.getTileEntity();
        }
    }

    @Override
    public Vec3d add(double x, double y, double z) {
        return this;
    }

    @Override
    public Vec3d add(ForgeDirection dir) {
        return this;
    }

    @Override
    public Vec3d add(Vec3d vec) {
        return this;
    }

    @Override
    public Vec3d div(double multiplier) {
        return this;
    }

    @Override
    public Vec3d div(double x, double y, double z) {
        return this;
    }

    @Override
    public Vec3d div(ForgeDirection direction) {
        return this;
    }

    @Override
    public Block getBlock() {
        return this.b;
    }

    @Override
    public int getBlockMeta() {
        return this.meta;
    }

    @Override
    public TileEntity getTileEntity() {
        return this.te;
    }

    @Override
    public World getWorld() {
        return this.w;
    }

    @Override
    public boolean hasTileEntity() {
        return this.getTileEntity() != null;
    }

    @Override
    public boolean hasWorld() {
        return this.getWorld() != null;
    }

    @Override
    public boolean isBlock(Block b) {
        return super.isBlock(b);
    }

    @Override
    public boolean isBlock(Block b, boolean checkAir) {
        if (this.hasWorld()) {
            Block bl = this.b;
            if (b == null && bl == Blocks.field_150350_a) {
                return true;
            }
            if (b == null && checkAir && bl.func_149688_o() == Material.field_151579_a) {
                return true;
            }
            if (b == null && checkAir && bl.isAir((IBlockAccess)this.w, (int)this.x, (int)this.y, (int)this.z)) {
                return true;
            }
            return bl.getClass().isInstance(b);
        }
        return false;
    }

    @Override
    public Vec3d mul(double multiplier) {
        return this;
    }

    @Override
    public Vec3d mul(double x, double y, double z) {
        return this;
    }

    @Override
    public Vec3d mul(ForgeDirection direction) {
        return this;
    }

    @Override
    public Vec3d setWorld(World world) {
        return this;
    }

    @Override
    public Vec3d sub(double x, double y, double z) {
        return this;
    }

    @Override
    public Vec3d sub(ForgeDirection dir) {
        return this;
    }

    @Override
    public Vec3d sub(Vec3d vec) {
        return this;
    }
}

