/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.lib.handlers;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import theflogat.technomancy.common.items.base.TMItems;
import theflogat.technomancy.common.items.technom.existence.ItemExistenceGem;
import theflogat.technomancy.common.items.technom.existence.ItemTreasure;
import theflogat.technomancy.common.player.PlayerData;
import theflogat.technomancy.common.potions.TMPotions;
import theflogat.technomancy.common.tiles.air.TileFakeAirNG;
import theflogat.technomancy.lib.Conf;
import theflogat.technomancy.lib.Ids;
import theflogat.technomancy.lib.Names;
import theflogat.technomancy.lib.handlers.CompatibilityHandler;
import theflogat.technomancy.lib.handlers.ConfigHandler;
import theflogat.technomancy.lib.handlers.ExistenceConversion;
import theflogat.technomancy.network.PacketHandler;
import theflogat.technomancy.util.Ore;

public class EventRegister {
    public static Map<Block, Item> buckets = new HashMap<Block, Item>();
    public static Random rand = new Random();
    public static PacketHandler pckHandler = new PacketHandler();

    public EventRegister() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlayEvent(TickEvent.RenderTickEvent event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if ((mc.field_71415_G || mc.field_71462_r == null) && !Minecraft.func_71410_x().field_71474_y.field_74330_P && event.phase == TickEvent.Phase.END && Minecraft.func_71410_x().field_71441_e != null && Conf.showHUD) {
            PlayerData.renderHUD((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entityLiving.func_70660_b(TMPotions.drown) != null && event.entityLiving.func_70660_b(TMPotions.drown).func_76459_b() == 0) {
            event.entityLiving.func_82170_o(TMPotions.drown.field_76415_H);
        } else if (event.entityLiving.func_70660_b(TMPotions.slowFall) != null && event.entityLiving.func_70660_b(TMPotions.slowFall).func_76459_b() == 0) {
            event.entityLiving.func_82170_o(TMPotions.slowFall.field_76415_H);
        }
        if (event.entityLiving.func_82165_m(Ids.drown)) {
            int air = event.entityLiving.getEntityData().func_74762_e("idrown");
            this.decreaseAirSupply(air, event.entityLiving);
            event.entityLiving.getEntityData().func_74768_a("idrown", air);
            if (air == -20) {
                air = 0;
                event.entityLiving.getEntityData().func_74768_a("idrown", air);
                event.entityLiving.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else if (event.entityLiving.func_82165_m(Ids.slowFall) && event.entityLiving.field_70143_R > 3.0f) {
            event.entityLiving.field_70143_R = 3.0f;
        }
        if (event.entityLiving instanceof EntityVillager && event.entityLiving.getEntityData().func_74764_b("seal") && event.entityLiving.getEntityData().func_74767_n("seal")) {
            int cooldown;
            if (!event.entityLiving.getEntityData().func_74764_b("cooldown")) {
                event.entityLiving.getEntityData().func_74768_a("cooldown", 80);
            }
            if ((cooldown = event.entityLiving.getEntityData().func_74762_e("cooldown")) == 0) {
                event.entityLiving.getEntityData().func_74768_a("cooldown", 80);
                event.entityLiving.getEntityData().func_74757_a("seal", false);
            } else {
                event.entityLiving.getEntityData().func_74768_a("cooldown", cooldown - 1);
            }
        }
    }

    public int decreaseAirSupply(int i, EntityLivingBase ent) {
        int j = EnchantmentHelper.func_77501_a((EntityLivingBase)ent);
        return j > 0 && rand.nextInt(j + 1) > 0 ? i : i - 1;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            PlayerData.prepareData((EntityPlayer)event.entity);
        }
        if (Ids.treasures && event.entity instanceof EntityVillager && !event.entity.getEntityData().func_74764_b("treasureAttempt")) {
            event.entity.getEntityData().func_74757_a("treasureAttempt", true);
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (int i = 0; i < ItemTreasure.rarity.length; ++i) {
                if (rand.nextInt(10000) > ItemTreasure.rarity[i]) continue;
                l.add(i);
            }
            int c = -1;
            Iterator i$ = l.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (c == -1) {
                    c = i;
                    continue;
                }
                if (ItemTreasure.rarity[i] >= ItemTreasure.rarity[c]) continue;
                c = i;
            }
            if (c != -1) {
                event.entity.getEntityData().func_74778_a("treasure", Names.treasures[c]);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onHurt(LivingHurtEvent event) {
        if (Ids.treasures) {
            if (event.entityLiving instanceof EntityVillager && event.entityLiving.getEntityData().func_74764_b("treasure")) {
                if (!event.entityLiving.getEntityData().func_74764_b("seal") || !event.entityLiving.getEntityData().func_74767_n("seal")) {
                    TMItems.treasures.onUserHit(event, TMItems.treasures.getTreasureId(event.entityLiving.getEntityData().func_74779_i("treasure")));
                }
            } else if (event.entityLiving instanceof EntityPlayer && ((EntityPlayer)event.entityLiving).field_71071_by.func_146028_b((Item)TMItems.treasures)) {
                EntityPlayer player = (EntityPlayer)event.entityLiving;
                for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                    ItemStack stack = player.field_71071_by.field_70462_a[i];
                    if (stack == null || stack.func_77973_b() != TMItems.treasures) continue;
                    TMItems.treasures.onUserHit(event, stack.func_77960_j());
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void entityDeath(LivingDeathEvent event) {
        if (Ids.treasures && event.entityLiving instanceof EntityVillager && event.entityLiving.getEntityData().func_74764_b("treasure") && (!event.entityLiving.getEntityData().func_74764_b("seal") || !event.entityLiving.getEntityData().func_74767_n("seal"))) {
            TMItems.treasures.onTreasureDestroyed(event.entityLiving.field_70170_p, event.entityLiving.field_70165_t, event.entityLiving.field_70163_u, event.entityLiving.field_70161_v, event.entityLiving, TMItems.treasures.getTreasureId(event.entityLiving.getEntityData().func_74779_i("treasure")));
        }
        if (event.source instanceof EntityDamageSource) {
            EntityDamageSource dmger = (EntityDamageSource)event.source;
            if (dmger.field_76373_n == "player") {
                if (((EntityPlayer)dmger.func_76346_g()).field_71071_by.func_146028_b(TMItems.exGem)) {
                    this.tryToFillGem((EntityPlayer)dmger.func_76346_g(), ExistenceConversion.getGem(event.entityLiving));
                } else {
                    PlayerData.addExistencePower(dmger.func_76346_g().field_70170_p.field_73012_v, (EntityPlayer)dmger.func_76346_g());
                }
            }
        }
    }

    public void tryToFillGem(EntityPlayer entityPlayer, int amt) {
        for (int i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
            ItemStack items = entityPlayer.field_71071_by.field_70462_a[i];
            if (items == null || !(items.func_77973_b() instanceof ItemExistenceGem) || items.func_77960_j() == 0) continue;
            entityPlayer.field_71071_by.field_70462_a[i].func_77964_b(Math.max(items.func_77960_j() - amt, 0));
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleBreakAir(PlayerInteractEvent event) {
        if (CompatibilityHandler.th && event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && event.world.func_147438_o(event.x, event.y, event.z) instanceof TileFakeAirNG) {
            ((TileFakeAirNG)event.world.func_147438_o(event.x, event.y, event.z)).getMain().setAirAndDrop();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void stitchEventPost(TextureStitchEvent.Post event) {
        if (event.map.func_130086_a() == 1) {
            Ore.initColors();
            ConfigHandler.initColorConfigs();
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = EventRegister.fillCustomBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    private static ItemStack fillCustomBucket(World world, MovingObjectPosition pos) {
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        Item bucket = buckets.get(block);
        if (bucket != null && world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) == 0) {
            world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
            return new ItemStack(bucket);
        }
        return null;
    }
}

