/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.util;

import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class AspectContainerEssentiaTransport
implements IAspectContainer {
    IEssentiaTransport trans;

    public AspectContainerEssentiaTransport(IEssentiaTransport trans) {
        this.trans = trans;
    }

    public AspectList getAspects() {
        AspectList as = new AspectList();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.trans.getEssentiaType(dir) == null) continue;
            as.add(this.trans.getEssentiaType(dir), this.trans.getEssentiaAmount(dir));
        }
        return as;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        AspectList as = new AspectList();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.trans.getEssentiaType(dir) == null) continue;
            as.add(this.trans.getEssentiaType(dir), 1);
        }
        return as.getAmount(tag) == 1;
    }

    public int addToContainer(Aspect tag, int amount) {
        int amountSent = 0;
        int amountToSend = amount;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int i = this.trans.addEssentia(tag, amountToSend, dir);
            amountSent += i;
            if ((amountToSend -= i) <= 0) break;
        }
        return amount - amountSent;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.trans.getEssentiaType(dir) != tag || this.trans.getEssentiaAmount(dir) < amount) continue;
            this.trans.takeEssentia(tag, amount, dir);
            return true;
        }
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.trans.getEssentiaType(dir) != tag || this.trans.getEssentiaAmount(dir) < amount) continue;
            return true;
        }
        return false;
    }

    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    public int containerContains(Aspect tag) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.trans.getEssentiaType(dir) != tag) continue;
            return this.trans.getEssentiaAmount(dir);
        }
        return 0;
    }
}

