/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXEssentiaSource;
import thaumcraft.common.tiles.TileArcaneBoreBase;
import thaumcraft.common.tiles.TileArcaneLampFertility;
import thaumcraft.common.tiles.TileArcaneLampGrowth;
import thaumcraft.common.tiles.TileThaumatorium;
import thaumcraft.common.tiles.TileThaumatoriumTop;
import thaumcraft.common.tiles.TileTubeBuffer;
import theflogat.technomancy.common.tiles.base.ICouplable;
import theflogat.technomancy.common.tiles.base.TileCoilTransmitter;
import theflogat.technomancy.common.tiles.thaumcraft.util.AspectContainerEssentiaTransport;
import theflogat.technomancy.lib.Conf;
import theflogat.technomancy.lib.compat.Thaumcraft;
import theflogat.technomancy.util.helpers.WorldHelper;

public class TileEssentiaTransmitter
extends TileCoilTransmitter
implements IEssentiaTransport {
    public Aspect aspectFilter = null;
    private boolean onSpecialBlock;
    private boolean onBuffer;

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        if (this.aspectFilter != null) {
            comp.func_74778_a("AspectFilter", this.aspectFilter.getTag());
        }
        comp.func_74757_a("Buffer", this.onBuffer);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.aspectFilter = Aspect.getAspect((String)comp.func_74779_i("AspectFilter"));
        this.onBuffer = comp.func_74767_n("Buffer");
        if (this.onBuffer && this.field_145850_b != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)this.facing);
            this.field_145850_b.func_147471_g(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity te = Thaumcraft.getConnectableAsContainer((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.getOrientation((int)this.facing));
            if (te == null) {
                return;
            }
            if (te instanceof TileArcaneBoreBase || te instanceof TileArcaneLampGrowth || te instanceof TileArcaneLampFertility || te instanceof TileArcaneLampFertility || te instanceof TileThaumatorium || te instanceof TileThaumatoriumTop) {
                this.onSpecialBlock = true;
                return;
            }
            this.onSpecialBlock = false;
            if (te instanceof TileTubeBuffer) {
                this.onBuffer = true;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            Object cont = te instanceof IAspectContainer ? (IAspectContainer)te : new AspectContainerEssentiaTransport((IEssentiaTransport)te);
            boolean flag = false;
            if (!this.boost) {
                if (this.redstoneState) {
                    this.redstoneState = false;
                    flag = true;
                }
            } else if (!Thaumcraft.isFull(cont)) {
                if (!this.redstoneState) {
                    this.redstoneState = true;
                    flag = true;
                }
            } else if (Thaumcraft.isFull(cont) && this.redstoneState) {
                this.redstoneState = false;
                flag = true;
            }
            if (flag) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.set.canRun(this) && !this.sources.isEmpty()) {
                Collections.shuffle(this.sources);
                Iterator sourceIter = this.sources.iterator();
                while (sourceIter.hasNext()) {
                    ChunkCoordinates coords = (ChunkCoordinates)sourceIter.next();
                    TileEntity tile = this.field_145850_b.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                    if (tile != null && !tile.func_145837_r() && tile instanceof IAspectContainer) {
                        IAspectContainer source = (IAspectContainer)tile;
                        AspectList al = source.getAspects();
                        if (al == null) continue;
                        for (int i = 0; i < al.size(); ++i) {
                            Aspect aspect = al.getAspects()[i];
                            if (aspect == null || this.aspectFilter != null && aspect != this.aspectFilter || !cont.doesContainerAccept(aspect) || cont.addToContainer(aspect, 1) != 0) continue;
                            if (source.takeFromContainer(aspect, 1)) {
                                if (!Conf.fancy || this.field_145851_c - tile.field_145851_c > 127 || this.field_145848_d - tile.field_145848_d > 127 || this.field_145849_e - tile.field_145849_e > 127) continue;
                                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXEssentiaSource(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, (byte)(this.field_145851_c - tile.field_145851_c), (byte)(this.field_145848_d - tile.field_145848_d), (byte)(this.field_145849_e - tile.field_145849_e), aspect.getColor()), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, 32.0));
                                continue;
                            }
                            cont.takeFromContainer(aspect, 1);
                        }
                        continue;
                    }
                    if (tile != null && (tile == null || tile.func_145837_r())) continue;
                    sourceIter.remove();
                }
            }
        }
    }

    public boolean isConnectable(ForgeDirection face) {
        return (this.onSpecialBlock || this.onBuffer) && face == ForgeDirection.getOrientation((int)this.facing);
    }

    public boolean canInputFrom(ForgeDirection face) {
        return false;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return this.onSpecialBlock && face == ForgeDirection.getOrientation((int)this.facing);
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection face) {
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.onSpecialBlock && this.set.canRun(this) && !this.sources.isEmpty()) {
            Collections.shuffle(this.sources);
            Iterator sourceIter = this.sources.iterator();
            boolean gotEssentia = false;
            while (sourceIter.hasNext() && !gotEssentia) {
                ChunkCoordinates coords = (ChunkCoordinates)sourceIter.next();
                TileEntity tile = this.field_145850_b.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
                if (tile != null && !tile.func_145837_r() && tile instanceof IAspectContainer) {
                    IAspectContainer source = (IAspectContainer)tile;
                    if (!source.doesContainerContainAmount(aspect, amount) || !(gotEssentia = source.takeFromContainer(aspect, amount))) continue;
                    if (Conf.fancy && this.field_145851_c - tile.field_145851_c <= 127 && this.field_145848_d - tile.field_145848_d <= 127 && this.field_145849_e - tile.field_145849_e <= 127) {
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXEssentiaSource(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, (byte)(this.field_145851_c - tile.field_145851_c), (byte)(this.field_145848_d - tile.field_145848_d), (byte)(this.field_145849_e - tile.field_145849_e), aspect.getColor()), new NetworkRegistry.TargetPoint(tile.func_145831_w().field_73011_w.field_76574_g, (double)tile.field_145851_c, (double)tile.field_145848_d, (double)tile.field_145849_e, 32.0));
                    }
                    return amount;
                }
                if (tile != null && (tile == null || tile.func_145837_r())) continue;
                sourceIter.remove();
            }
        }
        return 0;
    }

    @Override
    public ICouplable.Type getType() {
        return ICouplable.Type.ESSENTIA;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return null;
    }

    public int getEssentiaAmount(ForgeDirection face) {
        return 1;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    @Override
    public boolean onWrenched(boolean sneaking) {
        for (int i = this.facing + 1; i < this.facing + 6; ++i) {
            TileEntity tile = WorldHelper.getAdjacentTileEntity((TileEntity)this, (byte)(i % 6));
            if (!(tile instanceof IAspectContainer)) continue;
            this.facing = (byte)(i % 6);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return true;
        }
        return false;
    }
}

