/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemEssence;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.TileMachineRedstone;
import theflogat.technomancy.lib.compat.Thaumcraft;
import theflogat.technomancy.lib.handlers.Rate;

public class TileEssentiaFusor
extends TileMachineRedstone
implements IAspectContainer,
IEssentiaTransport {
    private HashMap<ForgeDirection, SideInfo> sides = new HashMap();
    private static final int MAX_AMOUNT = 64;

    public TileEssentiaFusor() {
        super(Rate.fusorCost * 10, IRedstoneSensitive.RedstoneSet.HIGH);
        this.sides.put(ForgeDirection.EAST, new SideInfo(ForgeDirection.EAST));
        this.sides.put(ForgeDirection.WEST, new SideInfo(ForgeDirection.WEST));
        this.sides.put(ForgeDirection.NORTH, new SideInfo(ForgeDirection.NORTH));
        this.sides.put(ForgeDirection.SOUTH, new SideInfo(ForgeDirection.SOUTH));
    }

    public void func_145845_h() {
        if (this.fullyMarked()) {
            boolean flag = false;
            flag |= this.fill();
            if (flag |= this.fuse()) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
            }
        }
    }

    private boolean fill() {
        boolean ret = false;
        for (SideInfo side : this.getInputSides()) {
            IEssentiaTransport ic;
            Aspect ta;
            TileEntity te;
            if (side.amount >= 64 || (te = Thaumcraft.getConnectableTile(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, side.side)) == null || (ta = (ic = (IEssentiaTransport)te).getEssentiaType(side.side.getOpposite())) != side.aspect || ic.getEssentiaAmount(side.side.getOpposite()) <= 0 || ic.getSuctionAmount(side.side.getOpposite()) >= this.getSuctionAmount(side.side) || this.getSuctionAmount(side.side) < ic.getMinimumSuction()) continue;
            this.addEssentia(ta, ic.takeEssentia(ta, 1, side.side.getOpposite()), side.side);
            ret = true;
        }
        return ret;
    }

    private boolean fuse() {
        SideInfo[] inputSides;
        boolean ret = false;
        if (this.set.canRun(this) && this.outputMarked() && this.getOutputSideInfo().amount < 64 && this.getEnergyStored(ForgeDirection.UNKNOWN) >= Rate.fusorCost && (inputSides = this.getInputSides()).length == 2 && inputSides[0].amount > 0 && inputSides[1].amount > 0) {
            this.extractEnergy(ForgeDirection.UNKNOWN, Rate.fusorCost, false);
            --inputSides[0].amount;
            --inputSides[1].amount;
            ++this.getOutputSideInfo().amount;
            ret = true;
        }
        return ret;
    }

    public boolean isSideOccupied(ForgeDirection side) {
        return this.sides.get((Object)side).type != SideType.NONE;
    }

    public boolean markSide(ForgeDirection side, ItemStack stack) {
        if (stack.func_77960_j() == 0) {
            if (!this.outputMarked()) {
                this.sides.get((Object)side).type = SideType.OUTPUT;
                this.setOutputAspect();
                return true;
            }
        } else {
            Aspect newAspect;
            Aspect comboAspect;
            SideInfo[] inputSides = this.getInputSides();
            if (inputSides.length == 0) {
                this.sides.get((Object)side).type = SideType.INPUT;
                this.sides.get((Object)side).aspect = TileEssentiaFusor.getAspectFromStack(stack);
                return true;
            }
            if (inputSides.length == 1 && (comboAspect = TileEssentiaFusor.getAspectCombo(newAspect = TileEssentiaFusor.getAspectFromStack(stack), inputSides[0].aspect)) != null) {
                this.sides.get((Object)side).type = SideType.INPUT;
                this.sides.get((Object)side).aspect = newAspect;
                this.setOutputAspect(comboAspect);
                return true;
            }
        }
        return false;
    }

    private void setOutputAspect() {
        SideInfo outputSide = this.getOutputSideInfo();
        SideInfo[] inputSides = this.getInputSides();
        if (outputSide != null && inputSides.length == 2) {
            outputSide.aspect = TileEssentiaFusor.getAspectCombo(inputSides[0].aspect, inputSides[1].aspect);
        }
    }

    private void setOutputAspect(Aspect comboAspect) {
        SideInfo outputSide = this.getOutputSideInfo();
        if (outputSide != null) {
            outputSide.aspect = comboAspect;
        }
    }

    private static Aspect getAspectCombo(Aspect priAspect, Aspect secAspect) {
        if (priAspect != secAspect) {
            for (Aspect curAspect : Aspect.getCompoundAspects()) {
                Aspect aspect1 = curAspect.getComponents()[0];
                Aspect aspect2 = curAspect.getComponents()[1];
                if (aspect1 != priAspect && aspect2 != priAspect || aspect1 != secAspect && aspect2 != secAspect) continue;
                return curAspect;
            }
        }
        return null;
    }

    public ItemStack clearSide(ForgeDirection side) {
        ItemStack output = null;
        SideInfo outputSide = this.getOutputSideInfo();
        if (outputSide == null || outputSide.amount == 0) {
            SideInfo targetSide = this.sides.get(side);
            if (targetSide.amount == 0) {
                output = this.getItemForSlot(side);
                targetSide.type = SideType.NONE;
                targetSide.aspect = null;
                if (outputSide != null) {
                    outputSide.aspect = null;
                }
            }
        }
        return output;
    }

    public ItemStack getItemForSlot(ForgeDirection side) {
        ItemStack output = null;
        SideInfo target = this.sides.get(side);
        if (target.type == SideType.OUTPUT) {
            output = new ItemStack(ConfigItems.itemEssence, 1, 0);
        } else if (target.type == SideType.INPUT) {
            output = new ItemStack(ConfigItems.itemEssence, 1, 1);
            ((ItemEssence)ConfigItems.itemEssence).setAspects(output, new AspectList().add(target.aspect, 8));
        }
        return output;
    }

    public Aspect getOutputAspect() {
        SideInfo output = this.getOutputSideInfo();
        return output == null ? null : output.aspect;
    }

    private boolean outputMarked() {
        return this.getOutputSideInfo() != null;
    }

    public ForgeDirection getOutputSide() {
        SideInfo output = this.getOutputSideInfo();
        return output != null ? output.side : ForgeDirection.UNKNOWN;
    }

    public SideInfo getOutputSideInfo() {
        for (SideInfo side : this.sides.values()) {
            if (side.type != SideType.OUTPUT) continue;
            return side;
        }
        return null;
    }

    private SideInfo[] getInputSides() {
        ArrayList<SideInfo> inputSides = new ArrayList<SideInfo>();
        for (SideInfo side : this.sides.values()) {
            if (side.type != SideType.INPUT) continue;
            inputSides.add(side);
        }
        return inputSides.toArray(new SideInfo[inputSides.size()]);
    }

    private static Aspect getAspectFromStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemEssence) {
            return ((ItemEssence)stack.func_77973_b()).getAspects(stack).getAspects()[0];
        }
        return null;
    }

    private boolean fullyMarked() {
        return this.getInputSides().length == 2 && this.outputMarked();
    }

    private static boolean isValidSide(ForgeDirection side) {
        return side != ForgeDirection.UP && side != ForgeDirection.DOWN;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from != ForgeDirection.UP;
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        NBTTagList list = new NBTTagList();
        for (SideInfo side : this.sides.values()) {
            NBTTagCompound sideVal = side.save();
            list.func_74742_a((NBTBase)sideVal);
        }
        comp.func_74782_a("SideInfo", (NBTBase)list);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        NBTTagList list = comp.func_150295_c("SideInfo", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound sideVal = list.func_150305_b(i);
            this.sides.get(ForgeDirection.getOrientation((int)sideVal.func_74771_c("side"))).load(sideVal);
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int addToContainer(Aspect aspect, int amount) {
        for (SideInfo side : this.sides.values()) {
            if (side.type != SideType.INPUT || side.aspect != aspect || side.amount >= 64) continue;
            int amountToAdd = Math.min(amount, 64 - side.amount);
            side.amount += amountToAdd;
            return amount - amountToAdd;
        }
        return 0;
    }

    public int containerContains(Aspect aspect) {
        for (SideInfo side : this.sides.values()) {
            if (side.type == SideType.NONE || side.aspect != aspect) continue;
            return side.amount;
        }
        return 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        for (SideInfo side : this.sides.values()) {
            if (side.type != SideType.INPUT || side.aspect != aspect || side.amount >= 64) continue;
            return true;
        }
        return false;
    }

    public boolean doesContainerContain(AspectList aspects) {
        for (Aspect aspect : aspects.getAspects()) {
            if (this.doesContainerContainAmount(aspect, aspects.getAmount(aspect))) continue;
            return false;
        }
        return true;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amount) {
        for (SideInfo side : this.sides.values()) {
            if (side.type != SideType.INPUT || side.aspect != aspect || side.amount < amount) continue;
            return true;
        }
        return false;
    }

    public AspectList getAspects() {
        AspectList aspects = new AspectList();
        for (SideInfo side : this.sides.values()) {
            if (side.type == SideType.NONE || side.aspect == null || side.amount <= 0) continue;
            aspects.add(side.aspect, side.amount);
        }
        return aspects;
    }

    public void setAspects(AspectList arg0) {
    }

    public boolean takeFromContainer(AspectList al) {
        return false;
    }

    public boolean takeFromContainer(Aspect aspect, int amount) {
        for (SideInfo side : this.sides.values()) {
            if (side.type == SideType.NONE || aspect != null && side.aspect != aspect || side.amount < amount) continue;
            side.amount -= amount;
            return true;
        }
        return false;
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection side) {
        if (TileEssentiaFusor.isValidSide(side)) {
            SideInfo targetSide = this.sides.get(side);
            if (targetSide.type == SideType.INPUT && targetSide.aspect == aspect) {
                int amountToAdd = Math.min(amount, 64 - targetSide.amount);
                targetSide.amount += amountToAdd;
                return amountToAdd;
            }
        }
        return 0;
    }

    public boolean canInputFrom(ForgeDirection side) {
        return TileEssentiaFusor.isValidSide(side) && this.sides.get((Object)side).type == SideType.INPUT && this.fullyMarked();
    }

    public boolean canOutputTo(ForgeDirection side) {
        return TileEssentiaFusor.isValidSide(side) && (this.sides.get((Object)side).type == SideType.OUTPUT || this.sides.get((Object)side).type == SideType.INPUT && !this.fullyMarked());
    }

    public int getEssentiaAmount(ForgeDirection side) {
        return TileEssentiaFusor.isValidSide(side) && this.sides.get((Object)side).type != SideType.NONE ? this.sides.get((Object)side).amount : 0;
    }

    public Aspect getEssentiaType(ForgeDirection side) {
        return TileEssentiaFusor.isValidSide(side) && this.sides.get((Object)side).type != SideType.NONE ? this.sides.get((Object)side).aspect : null;
    }

    public int getMinimumSuction() {
        return -48;
    }

    public int getSuctionAmount(ForgeDirection side) {
        return TileEssentiaFusor.isValidSide(side) && this.fullyMarked() ? (this.sides.get((Object)side).type == SideType.INPUT ? 48 : (this.sides.get((Object)side).type == SideType.OUTPUT ? -48 : 0)) : 0;
    }

    public Aspect getSuctionType(ForgeDirection side) {
        return TileEssentiaFusor.isValidSide(side) && this.sides.get((Object)side).type != SideType.NONE ? this.sides.get((Object)side).aspect : null;
    }

    public boolean isConnectable(ForgeDirection side) {
        return TileEssentiaFusor.isValidSide(side) && this.sides.get((Object)side).type != SideType.NONE;
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection side) {
        if (side != ForgeDirection.UP && side != ForgeDirection.DOWN) {
            SideInfo curSide = this.sides.get(side);
            if (curSide.type != SideType.NONE && curSide.aspect == aspect) {
                int amountToTake = Math.min(amount, curSide.amount);
                curSide.amount -= amountToTake;
                return amountToTake;
            }
        }
        return 0;
    }

    private class SideInfo {
        public Aspect aspect = null;
        public int amount = 0;
        public SideType type = SideType.NONE;
        public ForgeDirection side = ForgeDirection.UNKNOWN;

        public SideInfo(ForgeDirection side) {
            this.side = side;
        }

        public NBTTagCompound save() {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74768_a("amount", this.amount);
            tags.func_74774_a("type", (byte)this.type.ordinal());
            tags.func_74774_a("side", (byte)this.side.ordinal());
            if (this.aspect != null) {
                tags.func_74778_a("aspect", this.aspect.getTag());
            }
            return tags;
        }

        public void load(NBTTagCompound tags) {
            this.aspect = tags.func_74764_b("aspect") ? Aspect.getAspect((String)tags.func_74779_i("aspect")) : null;
            this.type = SideType.values()[tags.func_74771_c("type")];
            this.amount = tags.func_74762_e("amount");
        }
    }

    private static enum SideType {
        INPUT,
        OUTPUT,
        NONE;

    }
}

