/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.thaumcraft.machine;

import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import me.jezza.thaumicpipes.api.interfaces.IThaumicOutput;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.TileMachineRedstone;
import theflogat.technomancy.lib.handlers.Rate;
import theflogat.technomancy.util.Coords;

@Optional.Interface(iface="me.jezza.thaumicpipes.api.interfaces.IThaumicOutput", modid="ThaumicPipes")
public class TileEldritchConsumer
extends TileMachineRedstone
implements IAspectContainer,
IEssentiaTransport,
IThaumicOutput {
    public Range current = Range.LARGE;
    AspectList list = new AspectList();
    public int cooldown = 0;
    public int time = 0;
    public float panelRotation = 0.0f;
    public int cost = Rate.consumerCost;

    public TileEldritchConsumer() {
        super(Rate.consumerCost * 50, IRedstoneSensitive.RedstoneSet.HIGH);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.set.canRun(this)) {
                if (this.time <= 0) {
                    if (TileEldritchConsumer.canFillList(this.list) && this.getEnergyStored() >= this.cost) {
                        Coords c;
                        boolean flag = this.dealWithMobs();
                        flag |= this.dealWithItems();
                        if (this.getEnergyStored() >= this.cost && (c = this.seekForBlock()) != null) {
                            this.processFromCoords(c);
                            this.extractEnergy(this.cost, false);
                            flag = true;
                        }
                        if (flag) {
                            this.cooldown = 40;
                            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                        } else {
                            this.time = 80;
                        }
                    }
                } else {
                    --this.time;
                }
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        } else {
            this.panelRotation = this.cooldown > 0 ? Math.min(-0.7853982f, this.panelRotation -= 0.02f) : (this.panelRotation > 0.0f ? Math.min(0.0f, this.panelRotation -= 0.02f) : Math.max(0.0f, this.panelRotation += 0.02f));
        }
    }

    private static boolean canFillList(AspectList list) {
        if (list.getAspects().length >= 4) {
            return false;
        }
        boolean flag = true;
        for (Aspect as : list.getAspects()) {
            if (list.getAmount(as) <= 4) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private Coords seekForBlock() {
        for (int yy = this.field_145848_d - 1; yy > (this.current.h == -1 ? 0 : this.field_145848_d - this.current.h - 1); --yy) {
            for (int xx = -this.current.r; xx <= this.current.r; ++xx) {
                for (int zz = -this.current.r; zz <= this.current.r; ++zz) {
                    if (xx == -this.current.r || xx == this.current.r) {
                        this.stopFlows(xx == -this.current.r ? this.field_145851_c + xx - 1 : this.field_145851_c + xx + 1, yy, this.field_145849_e + zz);
                    }
                    if (zz == -this.current.r || zz == this.current.r) {
                        this.stopFlows(this.field_145851_c + xx, yy, zz == -this.current.r ? this.field_145849_e + zz - 1 : this.field_145849_e + zz + 1);
                    }
                    this.dealWithFluid(this.field_145851_c + xx, yy, this.field_145849_e + zz);
                    if (!this.isBlockOk(this.field_145851_c + xx, yy, this.field_145849_e + zz)) continue;
                    return new Coords(this.field_145851_c + xx, yy, this.field_145849_e + zz, this.field_145850_b);
                }
            }
        }
        return null;
    }

    private boolean dealWithMobs() {
        boolean flag = false;
        ArrayList mobs = (ArrayList)this.field_145850_b.func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.current.r), (double)(this.current.h == -1 ? 0.0 : (double)(this.field_145848_d - this.current.h - 1)), (double)(this.field_145849_e - this.current.r), (double)(this.field_145851_c + this.current.r), (double)(this.field_145848_d - 1), (double)(this.field_145849_e + this.current.r)));
        if (!mobs.isEmpty()) {
            for (EntityLiving mob : mobs) {
                if (mob.field_70128_L || mob.field_70725_aQ > 0 || mob.func_85032_ar()) continue;
                if (this.getEnergyStored() < this.cost) break;
                flag = true;
                this.extractEnergy(this.cost, false);
                mob.func_70645_a(DamageSource.field_76376_m);
                mob.func_70106_y();
            }
        }
        return flag;
    }

    private boolean dealWithItems() {
        boolean flag = false;
        ArrayList items = (ArrayList)this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.current.r), (double)(this.current.h == -1 ? 0.0 : (double)(this.field_145848_d - this.current.h - 1)), (double)(this.field_145849_e - this.current.r), (double)(this.field_145851_c + this.current.r), (double)(this.field_145848_d - 1), (double)(this.field_145849_e + this.current.r)));
        if (!items.isEmpty()) {
            for (EntityItem item : items) {
                if (this.getEnergyStored() < this.cost) break;
                flag = true;
                this.extractEnergy(this.cost, false);
                AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)item.func_92059_d());
                al = ThaumcraftCraftingManager.getBonusTags((ItemStack)item.func_92059_d(), (AspectList)al);
                if (--item.func_92059_d().field_77994_a <= 0) {
                    item.func_70106_y();
                }
                for (Aspect as : al.getAspects()) {
                    if (as == null) continue;
                    int amount = al.getAmount(as);
                    this.list.add(as, amount);
                }
            }
        }
        return flag;
    }

    private void dealWithFluid(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block instanceof BlockFluidBase || block instanceof BlockLiquid) {
            this.field_145850_b.func_147468_f(x, y, z);
        }
    }

    private void stopFlows(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block instanceof BlockFluidBase || block instanceof BlockLiquid) {
            this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150348_b, 0, 2);
        }
    }

    private boolean isBlockOk(int x, int y, int z) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        return block != null && !block.isAir((IBlockAccess)this.field_145850_b, x, y, z) && block.func_149712_f(this.field_145850_b, x, y, z) != -1.0f;
    }

    private void processFromCoords(Coords c) {
        ArrayList drops = c.w.func_147439_a(c.x, c.y, c.z).getDrops(this.field_145850_b, c.x, c.y, c.z, c.w.func_72805_g(c.x, c.y, c.z), 0);
        for (ItemStack items : drops) {
            AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)items);
            al = ThaumcraftCraftingManager.getBonusTags((ItemStack)items, (AspectList)al);
            for (Aspect as : al.getAspects()) {
                if (as == null) continue;
                int amount = al.getAmount(as);
                this.list.add(as, amount);
            }
        }
        c.w.func_147439_a(c.x, c.y, c.z).func_149749_a(c.w, c.x, c.y, c.z, c.w.func_147439_a(c.x, c.y, c.z), c.w.func_72805_g(c.x, c.y, c.z));
        c.w.func_147468_f(c.x, c.y, c.z);
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        super.writeSyncData(compound);
        this.list.writeToNBT(compound);
        compound.func_74768_a("cooldown", this.cooldown);
        this.current.writeToNbt(compound);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        super.readSyncData(compound);
        this.list.readFromNBT(compound);
        this.cooldown = compound.func_74762_e("cooldown");
        this.current = Range.readFromNbt(compound);
    }

    public AspectList getAspects() {
        return this.list;
    }

    public void setAspects(AspectList al) {
    }

    public boolean doesContainerAccept(Aspect paramAspect) {
        return false;
    }

    public int addToContainer(Aspect paramAspect, int paramInt) {
        return 0;
    }

    public boolean takeFromContainer(Aspect paramAspect, int paramInt) {
        if (!this.list.aspects.containsKey(paramAspect) || this.list.getAmount(paramAspect) < paramInt) {
            return false;
        }
        this.list.remove(paramAspect, paramInt);
        return true;
    }

    public boolean takeFromContainer(AspectList al) {
        for (Aspect as : al.getAspects()) {
            if (this.takeFromContainer(as, al.getAmount(as))) continue;
            return false;
        }
        return true;
    }

    public boolean doesContainerContainAmount(Aspect as, int amount) {
        return this.list.aspects.containsKey(as) && this.list.getAmount(as) >= amount;
    }

    public boolean doesContainerContain(AspectList al) {
        for (Aspect as : al.getAspects()) {
            if (this.doesContainerContainAmount(as, al.getAmount(as))) continue;
            return false;
        }
        return true;
    }

    public int containerContains(Aspect as) {
        return this.list.aspects.containsKey(as) ? this.list.getAmount(as) : 0;
    }

    public boolean isConnectable(ForgeDirection paramForgeDirection) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection paramForgeDirection) {
        return false;
    }

    public boolean canOutputTo(ForgeDirection paramForgeDirection) {
        return true;
    }

    public void setSuction(Aspect paramAspect, int paramInt) {
    }

    public Aspect getSuctionType(ForgeDirection paramForgeDirection) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection paramForgeDirection) {
        return 0;
    }

    public int takeEssentia(Aspect paramAspect, int paramInt, ForgeDirection paramForgeDirection) {
        int amountToRemove = 0;
        if (this.list.aspects.containsKey(paramAspect)) {
            amountToRemove = Math.min(paramInt, this.list.getAmount(paramAspect));
            this.list.remove(paramAspect, amountToRemove);
        }
        return amountToRemove;
    }

    public int addEssentia(Aspect paramAspect, int paramInt, ForgeDirection paramForgeDirection) {
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection paramForgeDirection) {
        return this.list.getAspects()[0];
    }

    public int getEssentiaAmount(ForgeDirection paramForgeDirection) {
        return this.list.getAmount(this.list.getAspects()[0]);
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return true;
    }

    public static enum Range {
        LARGE(9, -1, 0, "Large"),
        SMALL(1, 1, 1, "Small"),
        TINY(0, 1, 2, "Tiny"),
        MEDIUM(5, -1, 3, "Medium"),
        AVERAGE(4, 9, 4, "Average"),
        GIGANTIC(16, -1, 5, "Gigantic");

        static Range[] ValidRanges;
        private static final String loc = "RangeIdentificator";
        public int r;
        public int h;
        public int id;
        public String chat;

        public String toString() {
            return this.chat;
        }

        private Range(int range, int height, int id, String chat) {
            this.r = range;
            this.h = height;
            this.id = id;
            this.chat = chat;
        }

        public void writeToNbt(NBTTagCompound comp) {
            comp.func_74768_a(loc, this.id);
        }

        public Range getNext() {
            return this == ValidRanges[ValidRanges.length - 1] ? ValidRanges[0] : ValidRanges[this.id + 1];
        }

        public static Range readFromNbt(NBTTagCompound comp) {
            int i = comp.func_74762_e(loc);
            for (Range r : ValidRanges) {
                if (r.id != i) continue;
                return r;
            }
            return LARGE;
        }

        static {
            ValidRanges = new Range[]{LARGE, SMALL, TINY, MEDIUM, AVERAGE, GIGANTIC};
        }
    }
}

