/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.botania.machines;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import theflogat.technomancy.common.blocks.base.TMBlocks;
import theflogat.technomancy.common.tiles.base.TileProcessorBase;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;

public class TileBOProcessor
extends TileProcessorBase
implements IManaReceiver {
    public int mana = 0;
    public static final int maxMana = 1000000;

    public TileBOProcessor() {
        super(1);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.perform();
    }

    @Override
    protected boolean getFuel(ItemStack items, int multiplier, int reprocess) {
        int cost = multiplier * 150 + 1500 * reprocess;
        if (cost > this.mana) {
            return false;
        }
        this.mana -= cost;
        return true;
    }

    protected void perform() {
        if (!this.isFull()) {
            for (int x = -4; x < 5; ++x) {
                for (int z = -4; z < 5; ++z) {
                    IManaPool pool;
                    int toRecieve;
                    TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z);
                    if (!(tile instanceof IManaPool) || (toRecieve = Math.min((pool = (IManaPool)tile).getCurrentMana(), Math.min(1000000 - this.mana, 5000))) <= 0) continue;
                    pool.recieveMana(-toRecieve);
                    this.mana += toRecieve;
                }
            }
        }
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        super.writeSyncData(compound);
        compound.func_74768_a("Mana", this.mana);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        super.readSyncData(compound);
        this.mana = compound.func_74762_e("Mana");
    }

    public boolean isFull() {
        return this.mana >= 1000000;
    }

    public void recieveMana(int mana) {
        this.mana += mana;
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int color = Color.CYAN.getRGB();
        BotaniaAPI.internalHandler.drawSimpleManaHUD(color, this.mana, 1000000, TMBlocks.processorBO.func_149732_F(), res);
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }
}

