/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.botania.dynamos;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import theflogat.technomancy.common.blocks.base.TMBlocks;
import theflogat.technomancy.common.tiles.base.TileDynamoBase;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.mana.IManaReceiver;

public class TileFlowerDynamo
extends TileDynamoBase
implements IManaReceiver {
    public int mana = 0;
    public int maxMana = 100000;

    @Override
    public int extractFuel(int ener) {
        float ratio = (float)ener / 80.0f;
        int val = (int)Math.ceil(20.0f * ratio);
        if (val > this.mana) {
            return 0;
        }
        this.mana -= val;
        return 160;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.mana <= this.maxMana - 100) {
            this.drainMana();
        }
    }

    public void drainMana() {
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                IManaPool pool;
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z);
                if (!(tile instanceof IManaPool) || (pool = (IManaPool)tile).getCurrentMana() < 100 || this.mana > this.maxMana - 100) continue;
                pool.recieveMana(-100);
                this.mana += 100;
            }
        }
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        comp.func_74768_a("Mana", this.mana);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.mana = comp.func_74762_e("Mana");
    }

    public boolean isFull() {
        return this.mana >= this.maxMana;
    }

    public void recieveMana(int mana) {
        mana += mana;
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int color = 0x660000FF;
        BotaniaAPI.internalHandler.drawSimpleManaHUD(color, this.mana, this.maxMana, TMBlocks.flowerDynamo.func_149732_F(), res);
    }
}

