/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.bloodmagic.dynamos;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import theflogat.technomancy.common.tiles.base.TileDynamoBase;
import theflogat.technomancy.lib.compat.BloodMagic;

public class TileBloodDynamo
extends TileDynamoBase
implements IFluidHandler {
    public int liquid = 0;
    public static final int capacity = 8000;

    @Override
    public int extractFuel(int ener) {
        float ratio = (float)ener / 80.0f;
        int val = (int)Math.ceil(100.0f * ratio);
        if (val > this.liquid) {
            return 0;
        }
        this.liquid -= val;
        return 400;
    }

    public boolean emptyBucket() {
        if (this.liquid + 1000 <= 8000) {
            this.liquid += 1000;
            return true;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || from == ForgeDirection.UNKNOWN || from.ordinal() == this.facing) {
            return 0;
        }
        if (resource.getFluid() == BloodMagic.lifeEssenceFluid) {
            int liquid = this.liquid;
            this.liquid += doFill ? Math.min(resource.amount, 8000 - liquid) : 0;
            return Math.min(resource.amount, 8000 - liquid);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(BloodMagic.lifeEssenceFluid, this.liquid), 8000)};
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        comp.func_74768_a("liquid", this.liquid);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.liquid = comp.func_74762_e("liquid");
    }
}

