/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.base;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;
import theflogat.technomancy.common.items.technom.ItemProcessedOre;
import theflogat.technomancy.common.tiles.base.TileTechnomancy;
import theflogat.technomancy.util.Ore;

public abstract class TileProcessorBase
extends TileTechnomancy
implements ISidedInventory {
    public ItemStack[] inv = new ItemStack[2];
    public boolean isActive;
    public int progress = 0;
    public static final int maxTime = 60;
    public String tagCompound;
    protected String[] processors = new String[]{"Thaumcraft", "Botania", "Blood Magic", "Ars Magica", "Witchery", "Totemic"};

    public TileProcessorBase(int tag) {
        this.tagCompound = this.processors[tag];
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.inv[0] == null) {
                this.progress = 0;
                this.isActive = false;
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (this.canProcess(this.inv[0])) {
                if (this.isActive) {
                    if (this.progress == 0) {
                        this.isActive = !this.process();
                    } else {
                        ItemStack stack = this.getOutput(this.inv[0]);
                        if (this.getFuel(stack, stack.func_77960_j(), stack.field_77990_d.func_74762_e(this.tagCompound))) {
                            --this.progress;
                        }
                    }
                } else {
                    this.isActive = true;
                    this.progress = 60;
                }
                this.func_70296_d();
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    protected boolean process() {
        boolean suc;
        ItemStack out = this.getOutput(this.inv[0]);
        if (out == null) {
            return false;
        }
        if (this.inv[1] == null) {
            this.inv[1] = out;
            --this.inv[0].field_77994_a;
            if (this.inv[0].field_77994_a == 0) {
                this.inv[0] = null;
            }
            return true;
        }
        boolean bl = suc = this.inv[1].func_77973_b() == out.func_77973_b() && this.inv[1].func_77960_j() == out.func_77960_j() && ItemStack.func_77970_a((ItemStack)out, (ItemStack)this.inv[1]);
        if (suc && this.inv[1].field_77994_a < 64) {
            ++this.inv[1].field_77994_a;
            --this.inv[0].field_77994_a;
            if (this.inv[0].field_77994_a == 0) {
                this.inv[0] = null;
            }
            return true;
        }
        return false;
    }

    protected ItemStack getOutput(ItemStack items) {
        if (Ore.isProcessableOre(items)) {
            return this.addTag(new ItemStack(this.itemFromOreDictName(items), 1));
        }
        if (this.isProcessed(items) && this.isProcessable(items.field_77990_d)) {
            ItemStack it = items.func_77946_l();
            it.field_77994_a = 1;
            it.func_77964_b(it.func_77960_j() + 1);
            return this.addTag(it);
        }
        return null;
    }

    protected ItemStack addTag(ItemStack items) {
        if (items == null) {
            return null;
        }
        if (items.field_77990_d == null) {
            items.field_77990_d = new NBTTagCompound();
        }
        items.field_77990_d.func_74768_a(this.tagCompound, items.field_77990_d.func_74762_e(this.tagCompound) + 1);
        return items;
    }

    protected boolean canProcess(ItemStack items) {
        return Ore.isProcessableOre(items) || this.isProcessed(items) && items.field_77990_d != null && this.isProcessable(items.field_77990_d);
    }

    protected boolean isProcessable(NBTTagCompound comp) {
        return comp.func_74762_e(this.tagCompound) < 2;
    }

    protected Item itemFromOreDictName(ItemStack items) {
        for (int i : OreDictionary.getOreIDs((ItemStack)items)) {
            for (int j = 0; j < Ore.ores.size(); ++j) {
                if (Ore.ores.get(j).oreName() != OreDictionary.getOreName((int)i)) continue;
                return Ore.ores.get(j).getPure();
            }
        }
        return null;
    }

    protected boolean isProcessed(ItemStack items) {
        return items.func_77973_b() instanceof ItemProcessedOre;
    }

    protected abstract boolean getFuel(ItemStack var1, int var2, int var3);

    @SideOnly(value=Side.CLIENT)
    public int getTimeScaled(int j) {
        return this.progress * j / 60;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c("ItemsTile", 10);
        this.inv = new ItemStack[2];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            byte slot = item.func_74771_c("SlotsTile");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotsTile", (byte)i);
            itemstack.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("ItemsTile", (NBTBase)list);
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        compound.func_74768_a("Time", this.progress);
        compound.func_74757_a("Active", this.isActive);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        this.progress = compound.func_74762_e("Time");
        this.isActive = compound.func_74767_n("Active");
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inv[i] != null) {
            if (this.inv[i].field_77994_a <= j) {
                ItemStack stack = this.inv[i];
                this.inv[i] = null;
                return stack;
            }
            ItemStack stack = this.inv[i].func_77979_a(j);
            if (this.inv[i].field_77994_a == 0) {
                this.inv[i] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return this.inv[i];
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.inv[i] = stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack items) {
        return i == 0 && this.canProcess(items);
    }

    public int[] func_94128_d(int i) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int i, ItemStack stack, int j) {
        return i == 0;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }
}

