/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.base;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import theflogat.technomancy.common.tiles.base.TileTechnomancy;

public abstract class TileMachineBase
extends TileTechnomancy
implements IEnergyHandler,
IEnergyStorage {
    public int energy;
    public int capacity;

    public TileMachineBase(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeSyncData(NBTTagCompound compound) {
        compound.func_74768_a("energy", this.energy);
    }

    @Override
    public void readSyncData(NBTTagCompound compound) {
        this.energy = compound.func_74762_e("energy");
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!simulate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        int energy = this.energy;
        if (!simulate) {
            this.energy += Math.min(maxReceive, this.capacity - energy);
        }
        return Math.min(maxReceive, this.capacity - energy);
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!simulate) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        int energy = this.energy;
        if (!simulate) {
            this.energy -= Math.min(maxExtract, energy);
        }
        return Math.min(maxExtract, energy);
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.capacity;
    }
}

