/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.base;

import cofh.api.energy.IEnergyHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.util.ForgeDirection;
import theflogat.technomancy.common.tiles.base.IRedstoneSensitive;
import theflogat.technomancy.common.tiles.base.IUpgradable;
import theflogat.technomancy.common.tiles.base.IWrenchable;
import theflogat.technomancy.common.tiles.base.TileTechnomancyRedstone;
import theflogat.technomancy.util.helpers.WorldHelper;

public abstract class TileDynamoBase
extends TileTechnomancyRedstone
implements IEnergyHandler,
IUpgradable,
IWrenchable {
    public static final int maxEnergy = 40000;
    public static final int maxExtract = 320;
    public int ener = 0;
    public boolean boost = false;
    public byte facing = 1;
    public int fuel = 0;

    public TileDynamoBase() {
        super(IRedstoneSensitive.RedstoneSet.HIGH);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.set.canRun(this)) {
            if (this.fuel < 32) {
                this.fuel += this.extractFuel(this.calcEner());
            }
            if (this.fuel != 0 && this.ener + this.calcEner() <= 40000) {
                this.ener += this.calcEner();
                --this.fuel;
            }
        }
        this.updateAdjacentHandlers();
    }

    public int calcEner() {
        return Math.min(40000 - this.ener, this.boost ? 320 : 80);
    }

    public void update() {
        this.field_145850_b.func_147463_c(EnumSkyBlock.Block, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void updateAdjacentHandlers() {
        TileEntity tile;
        if (this.ener > 0 && WorldHelper.isEnergyHandlerFromOppFacing(tile = WorldHelper.getAdjacentTileEntity((TileEntity)this, this.facing), this.facing)) {
            this.ener -= ((IEnergyHandler)tile).receiveEnergy(ForgeDirection.VALID_DIRECTIONS[this.facing].getOpposite(), Math.min(320, this.ener), false);
        }
        this.update();
    }

    public String nextRedstoneSet() {
        this.set = this.set.cycle();
        return this.set.id;
    }

    @Override
    public boolean toggleBoost() {
        this.boost = !this.boost;
        return this.boost;
    }

    @Override
    public boolean getBoost() {
        return this.boost;
    }

    @Override
    public void setBoost(boolean newBoost) {
        this.boost = newBoost;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void readCustomNBT(NBTTagCompound comp) {
    }

    @Override
    public void writeSyncData(NBTTagCompound comp) {
        super.writeSyncData(comp);
        comp.func_74768_a("energy", this.ener);
        comp.func_74774_a("face", this.facing);
        comp.func_74768_a("fuel", this.fuel);
        comp.func_74757_a("Boost", this.boost);
    }

    @Override
    public void readSyncData(NBTTagCompound comp) {
        super.readSyncData(comp);
        this.ener = comp.func_74762_e("energy");
        this.facing = comp.func_74771_c("face");
        this.fuel = comp.func_74762_e("fuel");
        this.boost = comp.func_74767_n("Boost");
    }

    public abstract int extractFuel(int var1);

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (from.ordinal() == this.facing) {
            int ener = this.ener;
            this.ener -= simulate ? 0 : Math.min(maxExtract, ener);
            return Math.min(maxExtract, ener);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return from.ordinal() == this.facing;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.ener;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return 40000;
    }

    @Override
    public boolean onWrenched(boolean sneaking) {
        for (int i = this.facing + 1; i < this.facing + 6; ++i) {
            TileEntity tile = WorldHelper.getAdjacentTileEntity((TileEntity)this, (byte)(i % 6));
            if (!WorldHelper.isEnergyHandlerFromOppFacing(tile, (byte)(i % 6))) continue;
            if (!this.field_145850_b.field_72995_K) {
                this.facing = (byte)(i % 6);
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.updateAdjacentHandlers();
            }
            return true;
        }
        return false;
    }

    @Override
    public String getInfo() {
        return "360 RF/t For Four Times The Fuel";
    }
}

