/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.tiles.base;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public interface IRedstoneSensitive {
    public RedstoneSet getCurrentSetting();

    public void setNewSetting(RedstoneSet var1);

    public boolean isModified();

    public boolean canBeModified();

    public static enum RedstoneSet {
        NONE("None"),
        HIGH("High"),
        LOW("Low");

        public static RedstoneSet[] sets;
        public String id;

        private RedstoneSet(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public void save(NBTTagCompound comp) {
            comp.func_74778_a("redstoneSettings", this.id);
        }

        public static RedstoneSet load(NBTTagCompound comp) {
            String oldId = comp.func_74779_i("redstoneSettings");
            for (RedstoneSet set : sets) {
                if (!set.id.equalsIgnoreCase(oldId)) continue;
                return set;
            }
            return HIGH;
        }

        public RedstoneSet cycle() {
            int pos = -1;
            for (int i = 0; i < sets.length; ++i) {
                RedstoneSet set = sets[i];
                if (!this.id.equalsIgnoreCase(set.id)) continue;
                pos = i;
            }
            return sets[++pos % sets.length];
        }

        public boolean canRun(TileEntity tile) {
            if (tile != null && tile.func_145831_w() != null) {
                switch (this) {
                    case HIGH: {
                        return tile.func_145831_w().func_72864_z(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                    }
                    case LOW: {
                        return !tile.func_145831_w().func_72864_z(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                    }
                    case NONE: {
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean canRun(World world, int x, int y, int z) {
            switch (this) {
                case HIGH: {
                    return world.func_72864_z(x, y, z);
                }
                case LOW: {
                    return !world.func_72864_z(x, y, z);
                }
                case NONE: {
                    return true;
                }
            }
            return false;
        }

        static {
            sets = new RedstoneSet[]{NONE, HIGH, LOW};
        }
    }
}

