/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.common.items.thaumcraft;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.wands.IWandFocus;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.tiles.TileNode;
import theflogat.technomancy.Technomancy;
import theflogat.technomancy.common.items.base.ItemBase;

public class ItemFusionFocus
extends ItemBase
implements IWandFocus {
    AspectList aspects = new AspectList();
    NodeType type;
    NodeModifier mod;
    boolean cost = true;
    public IIcon iconFocus;

    public ItemFusionFocus() {
        this.func_77637_a(Technomancy.tabsTM);
    }

    public void func_94581_a(IIconRegister icon) {
        this.iconFocus = icon.func_94245_a("technom:focusFusion");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.iconFocus;
    }

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return true;
    }

    public boolean func_77645_m() {
        return true;
    }

    public int getFocusColor() {
        return Aspect.FIRE.getColor();
    }

    public IWandFocus.WandFocusAnimation getAnimation() {
        return IWandFocus.WandFocusAnimation.WAVE;
    }

    public AspectList getVisCost() {
        return new AspectList().add(Aspect.AIR, 3000).add(Aspect.FIRE, 3000).add(Aspect.WATER, 3000).add(Aspect.EARTH, 3000).add(Aspect.ORDER, 3000).add(Aspect.ENTROPY, 3000);
    }

    public boolean isVisCostPerTick() {
        return false;
    }

    public ItemStack onFocusRightClick(ItemStack stack, World world, EntityPlayer player, MovingObjectPosition mop) {
        if (mop != null && stack != null && this.type != null && this.mod != null && this.aspects != null) {
            this.cost = false;
            ThaumcraftWorldGenerator.createNodeAt((World)world, (int)mop.field_72311_b, (int)mop.field_72312_c, (int)mop.field_72309_d, (NodeType)this.type, (NodeModifier)this.mod, (AspectList)this.aspects);
        }
        return stack;
    }

    public void onUsingFocusTick(ItemStack itemstack, EntityPlayer player, int count) {
    }

    public String getSortingHelper(ItemStack itemstack) {
        Map ench = EnchantmentHelper.func_82781_a((ItemStack)itemstack);
        String out = "";
        for (Integer lvl : ench.values()) {
            out = out + lvl + "";
        }
        return out;
    }

    public void onPlayerStoppedUsingFocus(ItemStack itemstack, World world, EntityPlayer player, int count) {
    }

    public boolean onFocusBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        TileNode node;
        TileEntity entity = player.field_70170_p.func_147438_o(x, y, z);
        if (stack != null && entity != null && entity instanceof TileNode && stack.func_77973_b() instanceof ItemWandCasting && (node = (TileNode)entity).getAspects() != null) {
            AspectList al = node.getAspects();
            for (int i = 0; i < al.size(); ++i) {
                if (this.mod != null && this.mod != node.getNodeModifier() || this.type != null && this.type != node.getNodeType()) continue;
                this.aspects.add(al.getAspects()[i], al.getAmount(al.getAspects()[i]));
                this.mod = node.getNodeModifier();
                this.type = node.getNodeType();
            }
            entity.field_145854_h.func_149749_a(player.field_70170_p, x, y, z, entity.field_145854_h, entity.field_145847_g);
        }
        return false;
    }

    public boolean acceptsEnchant(int id) {
        return id == ThaumcraftApi.enchantFrugal;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        AspectList al = this.getVisCost();
        if (al != null && al.size() > 0) {
            list.add(StatCollector.func_74838_a((String)(this.isVisCostPerTick() ? "item.Focus.cost2" : "item.Focus.cost1")));
            for (Aspect aspect : al.getAspectsSorted()) {
                DecimalFormat myFormatter = new DecimalFormat("#####.##");
                String amount = myFormatter.format((float)al.getAmount(aspect) / 100.0f);
                list.add(" \u00a7" + aspect.getChatcolor() + aspect.getName() + "\u00a7r x " + amount);
            }
        }
    }

    public int func_77619_b() {
        return 5;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public IIcon getFocusDepthLayerIcon() {
        return null;
    }

    public IIcon getOrnament() {
        return null;
    }
}

