/*
 * Decompiled with CFR 0.152.
 */
package theflogat.technomancy.client.gui.tome;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import theflogat.technomancy.client.gui.tome.buttons.ButtonChangePage;
import theflogat.technomancy.client.gui.tome.buttons.ButtonEntry;
import theflogat.technomancy.client.gui.tome.buttons.ButtonTab;

public class GuiTomeTemplate
extends GuiScreen {
    private final ResourceLocation background;
    private final ResourceLocation buttons;
    private static final ResourceLocation page = new ResourceLocation("technom".toLowerCase(), "textures/gui/nextPrevious.png");
    public static ButtonTab[] tabs;
    private static final ButtonChangePage[] pageCh;
    private static final RenderItem itemRender;
    private int xSize;
    private int ySize;
    private int activeTab = -1;
    private int activeEntry = -1;
    private int activePage = 0;
    public int startText = 30;
    public int startTextY = 12;

    public GuiTomeTemplate(String id) {
        this.background = new ResourceLocation("technom".toLowerCase(), "textures/gui/tomeBack" + id + ".png");
        this.buttons = new ResourceLocation("technom".toLowerCase(), "textures/gui/tomeButtons" + id + ".png");
        this.xSize = 256;
        this.ySize = 256;
    }

    public void func_73863_a(int x, int y, float f) {
        int left = (this.field_146294_l - this.xSize) / 2;
        int top = (this.field_146295_m - this.ySize) / 2;
        this.drawBackground(left, top);
        this.drawButtons(left, top);
        if (this.activeEntry != -1) {
            ButtonEntry entry = tabs[this.activeTab].getEntries()[this.activeEntry];
            GL11.glDisable((int)2896);
            entry.drawPage(this, left, top, this.activePage);
            for (ButtonChangePage change : pageCh) {
                if (change.isPointInRegion(x, y, left, top, this)) {
                    GL11.glDisable((int)2896);
                    change.drawHover(left, top, this, page);
                    continue;
                }
                GL11.glDisable((int)2896);
                change.draw(left, top, this, page);
            }
        } else if (this.activeTab != -1) {
            GL11.glDisable((int)2896);
            this.drawTabs(left, top, this.activeTab, x, y);
        }
        this.field_146297_k.field_71446_o.func_110577_a(this.buttons);
        try {
            for (ButtonTab tab : tabs) {
                if (!tab.isPointInRegion(x, y, left, top, this)) continue;
                this.drawHoveringButton(left, top, tab.getX(), tab.getY());
                this.field_146289_q.func_78276_b(tab.getName(), x, y, Color.white.getRGB());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void drawBackground(int left, int top) {
        this.field_146297_k.field_71446_o.func_110577_a(this.background);
        this.func_73729_b(left, top, 0, 0, this.xSize, this.ySize);
    }

    public void drawButtons(int left, int top) {
        this.field_146297_k.field_71446_o.func_110577_a(this.buttons);
        try {
            for (ButtonTab tab : tabs) {
                tab.draw(left, top, this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawTabs(int left, int top, int tabA, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.buttons);
        for (ButtonEntry entry : tabs[tabA].getEntries()) {
            entry.draw(left, top, this, entry.isPointInRegion(mouseX, mouseY, left, top, this));
        }
    }

    public void drawHoveringButton(int left, int top, int ml, int mt) {
        this.func_73729_b(left + ml, top + mt, 16, 0, 16, 16);
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int x, int y, int par3) {
        int left = (this.field_146294_l - this.xSize) / 2;
        int top = (this.field_146295_m - this.ySize) / 2;
        for (ButtonTab tab : tabs) {
            if (!tab.isPointInRegion(x, y, left, top, this)) continue;
            this.activeTab = tab.getId();
            this.activeEntry = -1;
            this.activePage = 0;
        }
        if (this.activeTab != -1) {
            if (this.activeEntry == -1) {
                for (ButtonEntry entry : tabs[this.activeTab].getEntries()) {
                    if (!entry.isPointInRegion(x, y, left, top, this)) continue;
                    this.activeEntry = entry.getId();
                }
            } else {
                for (ButtonChangePage change : pageCh) {
                    if (!change.isPointInRegion(x, y, left, top, this)) continue;
                    this.activePage += change.getId();
                    if (this.activePage >= 0) continue;
                    this.activePage = 0;
                }
                tabs[this.activeTab].getEntries()[this.activeEntry].drawPage(this, left, top, this.activePage);
            }
        }
    }

    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    public ResourceLocation getChangePage() {
        return page;
    }

    public RenderItem getItemRend() {
        return itemRender;
    }

    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    static {
        pageCh = new ButtonChangePage[2];
        itemRender = new RenderItem();
        GuiTomeTemplate.pageCh[0] = new ButtonChangePage(18, 230, 0, 0, 1);
        GuiTomeTemplate.pageCh[1] = new ButtonChangePage(220, 230, 16, 0, -1);
    }
}

