/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier3;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.item.IDatabaseSaveable;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackDatabase;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.init.Config;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageCircuitDatabaseTemplate;
import com.bluepowermod.network.message.MessageSendClientServerTemplates;
import com.bluepowermod.reference.GuiIDs;
import com.bluepowermod.tile.tier2.TileCircuitTable;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileCircuitDatabase
extends TileCircuitTable {
    public IInventory copyInventory = new InventoryBasic("copy inventory", false, 2){

        public void func_70299_a(int slot, ItemStack itemStack) {
            super.func_70299_a(slot, itemStack);
            if (slot == 0 && itemStack != null) {
                TileCircuitDatabase.this.nameTextField = itemStack.func_82833_r();
            }
        }
    };
    public int clientCurrentTab;
    public int curUploadProgress;
    public int curCopyProgress;
    public int selectedShareOption;
    public static final int UPLOAD_AND_COPY_TIME = 20;
    public final ItemStackDatabase stackDatabase = new ItemStackDatabase();
    public static List<ItemStack> serverDatabaseStacks = new ArrayList<ItemStack>();
    private EntityPlayer triggeringPlayer;
    public String nameTextField = "";

    @Override
    protected List<ItemStack> getApplicableItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
            return items;
        }
        items.addAll(this.clientCurrentTab == 1 ? this.stackDatabase.loadItemStacks() : serverDatabaseStacks);
        return items;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        switch (messageId) {
            case 1: {
                player.openGui((Object)BluePower.instance, value == 0 ? GuiIDs.CIRCUITDATABASE_MAIN_ID.ordinal() : GuiIDs.CIRCUITDATABASE_SHARING_ID.ordinal(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                break;
            }
            case 2: {
                if (value == 2 && !TileCircuitDatabase.hasPermissions(player)) {
                    return;
                }
                this.selectedShareOption = value;
                if (this.selectedShareOption > 0) {
                    this.triggeringPlayer = player;
                    this.curUploadProgress = 0;
                    break;
                }
                this.curUploadProgress = -1;
                break;
            }
            case 3: {
                this.triggeringPlayer = player;
                this.curCopyProgress = this.curCopyProgress >= 0 || !this.copy(player, this.copyInventory.func_70301_a(0), this.copyInventory.func_70301_a(1), true) ? -1 : 0;
            }
        }
        super.onButtonPress(player, messageId, value);
    }

    public static boolean hasPermissions(EntityPlayer player) {
        if (Config.serverCircuitSavingOpOnly && !player.func_70003_b(2, "saveTemplate")) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("gui.circuitDatabase.info.opsOnly", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void setText(int textFieldID, String text) {
        if (textFieldID == 1) {
            this.nameTextField = text;
            if (this.copyInventory.func_70301_a(0) != null) {
                this.copyInventory.func_70301_a(0).func_151001_c(this.nameTextField);
            }
        } else {
            super.setText(textFieldID, text);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return textFieldID == 1 ? this.nameTextField : super.getText(textFieldID);
    }

    public boolean copy(EntityPlayer player, ItemStack template, ItemStack target, boolean simulate) {
        IDatabaseSaveable saveable;
        if (template != null && target != null && template.func_77969_a(target) && (saveable = (IDatabaseSaveable)template.func_77973_b()).canCopy(template, target)) {
            if (!player.field_71075_bZ.field_75098_d) {
                List<ItemStack> stacksInTemplate = saveable.getItemsOnStack(template);
                List<ItemStack> stacksInOutput = saveable.getItemsOnStack(target);
                if (stacksInTemplate == null) {
                    stacksInTemplate = new ArrayList<ItemStack>();
                }
                if (stacksInOutput == null) {
                    stacksInOutput = new ArrayList<ItemStack>();
                }
                ArrayList<ItemStack> traversedItems = new ArrayList<ItemStack>();
                ArrayList<ItemStack> allApplicableItems = new ArrayList<ItemStack>();
                allApplicableItems.addAll(stacksInTemplate);
                allApplicableItems.addAll(stacksInOutput);
                for (ItemStack templateStack : allApplicableItems) {
                    boolean alreadyTraversed = false;
                    for (ItemStack itemStack : traversedItems) {
                        if (!itemStack.func_77969_a(templateStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)templateStack)) continue;
                        alreadyTraversed = true;
                        break;
                    }
                    if (alreadyTraversed) continue;
                    traversedItems.add(templateStack);
                    int count = 0;
                    for (ItemStack stack : stacksInTemplate) {
                        if (!stack.func_77969_a(templateStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)templateStack)) continue;
                        count += stack.field_77994_a;
                    }
                    for (ItemStack stack : stacksInOutput) {
                        if (!stack.func_77969_a(templateStack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)templateStack)) continue;
                        count -= stack.field_77994_a;
                    }
                    if ((count *= target.field_77994_a) > 0) {
                        ItemStack itemStack = templateStack.func_77946_l();
                        itemStack.field_77994_a = count;
                        ItemStack itemStack2 = IOHelper.extract(this, ForgeDirection.UNKNOWN, itemStack, true, simulate, 2);
                        if (itemStack2 != null && itemStack2.field_77994_a >= count) continue;
                        return false;
                    }
                    if (count >= 0) continue;
                    ItemStack itemStack = templateStack.func_77946_l();
                    itemStack.field_77994_a = -count;
                    ItemStack itemStack3 = IOHelper.insert(this, itemStack, ForgeDirection.UNKNOWN, simulate);
                    if (itemStack3 == null || simulate) continue;
                    IOHelper.spawnItemInWorld(this.field_145850_b, itemStack3, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
                }
            }
            if (!simulate) {
                ItemStack copyStack = template.func_77946_l();
                copyStack.field_77994_a = target.field_77994_a;
                this.copyInventory.func_70299_a(1, copyStack);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.copyInventory.func_70301_a(0) != null) {
                if (this.curCopyProgress >= 0 && ++this.curCopyProgress > 20) {
                    this.curCopyProgress = -1;
                    if (this.copy(this.triggeringPlayer, this.copyInventory.func_70301_a(0), this.copyInventory.func_70301_a(1), true)) {
                        this.copy(this.triggeringPlayer, this.copyInventory.func_70301_a(0), this.copyInventory.func_70301_a(1), false);
                    }
                }
                if (this.curUploadProgress >= 0 && ++this.curUploadProgress > 20) {
                    this.curUploadProgress = -1;
                    if (this.selectedShareOption == 1 && this.triggeringPlayer != null) {
                        BPNetworkHandler.INSTANCE.sendTo((IMessage)new MessageCircuitDatabaseTemplate(this, this.copyInventory.func_70301_a(0)), (EntityPlayerMP)this.triggeringPlayer);
                    }
                    if (this.selectedShareOption == 2) {
                        this.stackDatabase.saveItemStack(this.copyInventory.func_70301_a(0));
                        BPNetworkHandler.INSTANCE.sendToAll((IMessage)new MessageSendClientServerTemplates(this.stackDatabase.loadItemStacks()));
                    }
                    this.selectedShareOption = 0;
                }
            } else {
                this.curCopyProgress = -1;
                this.curUploadProgress = -1;
                this.selectedShareOption = 0;
            }
        }
    }

    public void saveToPrivateLibrary(ItemStack stack) {
        this.stackDatabase.saveItemStack(stack);
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        NBTTagCompound stackTag;
        super.func_145841_b(tag);
        if (this.copyInventory.func_70301_a(0) != null) {
            stackTag = new NBTTagCompound();
            this.copyInventory.func_70301_a(0).func_77955_b(stackTag);
            tag.func_74782_a("copyTemplateStack", (NBTBase)stackTag);
        }
        if (this.copyInventory.func_70301_a(1) != null) {
            stackTag = new NBTTagCompound();
            this.copyInventory.func_70301_a(1).func_77955_b(stackTag);
            tag.func_74782_a("copyOutputStack", (NBTBase)stackTag);
        }
        tag.func_74768_a("curUploadProgress", this.curUploadProgress);
        tag.func_74768_a("curCopyProgress", this.curCopyProgress);
        tag.func_74774_a("selectedShareOption", (byte)this.selectedShareOption);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("copyTemplateStack")) {
            this.copyInventory.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("copyTemplateStack")));
        } else {
            this.copyInventory.func_70299_a(0, null);
        }
        if (tag.func_74764_b("copyOutputStack")) {
            this.copyInventory.func_70299_a(1, ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("copyOutputStack")));
        } else {
            this.copyInventory.func_70299_a(1, null);
        }
        this.curUploadProgress = tag.func_74762_e("curUploadProgress");
        this.curCopyProgress = tag.func_74762_e("curCopyProgress");
        this.selectedShareOption = tag.func_74771_c("selectedShareOption");
    }

    @Override
    public String func_145825_b() {
        return BPBlocks.circuit_database.func_149739_a();
    }
}

