/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier2;

import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.tile.tier1.TileProjectTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileAutoProjectTable
extends TileProjectTable
implements ISidedInventory {
    private static int[] slots = new int[19];
    protected ItemStack craftBuffer;
    private boolean markedForBufferFill = true;

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        if (this.craftBuffer != null) {
            drops.add(this.craftBuffer);
        }
        return drops;
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.craftBuffer != null) {
            NBTTagCompound bufferTag = new NBTTagCompound();
            this.craftBuffer.func_77955_b(bufferTag);
            tag.func_74782_a("craftBuffer", (NBTBase)bufferTag);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.craftBuffer = tag.func_74764_b("craftBuffer") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("craftBuffer")) : null;
    }

    @Override
    protected void updateCraftingGrid() {
        super.updateCraftingGrid();
        this.markedForBufferFill = true;
    }

    @Override
    public int func_70302_i_() {
        return super.func_70302_i_() + 1;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot < 18;
    }

    public boolean func_102008_b(int slot, ItemStack extractedStack, int side) {
        if (slot == 18) {
            return true;
        }
        return side > 5;
    }

    private void addItem(Map<ItemStack, Integer> collection, ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : collection.entrySet()) {
            ItemStack s = entry.getKey();
            if (!s.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)s)) continue;
            entry.setValue(entry.getValue() + 1);
            return;
        }
        collection.put(stack, 1);
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        this.markedForBufferFill = true;
        return slot < super.func_70302_i_() ? super.func_70301_a(slot) : this.craftBuffer;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < super.func_70302_i_()) {
            super.func_70299_a(slot, stack);
        } else {
            this.craftBuffer = stack;
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.markedForBufferFill) {
            this.updateCraftingGrid();
            this.tryFillCraftBuffer();
            this.markedForBufferFill = false;
        }
    }

    private void tryFillCraftBuffer() {
        if (this.craftBuffer == null && this.craftResult.func_70301_a(0) != null && !this.field_145850_b.field_72995_K) {
            HashMap<ItemStack, Integer> recipeItems = new HashMap<ItemStack, Integer>();
            for (ItemStack s : this.craftingGrid) {
                if (s == null) continue;
                this.addItem(recipeItems, s);
            }
            boolean canCraft = true;
            for (Map.Entry entry : recipeItems.entrySet()) {
                ItemStack s;
                s = ((ItemStack)entry.getKey()).func_77946_l();
                s.field_77994_a = (Integer)entry.getValue();
                ItemStack extracted = IOHelper.extract(this, ForgeDirection.UNKNOWN, s, true, true);
                if (extracted != null) continue;
                canCraft = false;
                break;
            }
            if (canCraft) {
                this.craftBuffer = this.craftResult.func_70301_a(0).func_77946_l();
                this.craft();
            }
        }
    }

    @Override
    public String func_145825_b() {
        return BPBlocks.auto_project_table.func_149739_a();
    }

    static {
        for (int i = 0; i < slots.length; ++i) {
            TileAutoProjectTable.slots[i] = i;
        }
    }
}

