/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.misc.IFace;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.vec.Vec3i;

public class DummyRedstoneDevice
implements IRedstoneDevice {
    private static final List<DummyRedstoneDevice> dummyDevices = new ArrayList<DummyRedstoneDevice>();
    private Vec3i loc;
    private RedstoneConnectionCache connections;

    public static DummyRedstoneDevice getDeviceAt(Vec3i loc) {
        for (DummyRedstoneDevice dev : new ArrayList<DummyRedstoneDevice>(dummyDevices)) {
            if (dev.loc == null || !dev.loc.equals((Object)loc)) continue;
            return dev;
        }
        DummyRedstoneDevice dev = new DummyRedstoneDevice(loc);
        dummyDevices.add(dev);
        return dev;
    }

    private DummyRedstoneDevice(Vec3i loc) {
        this.loc = loc;
        if (loc != null) {
            this.connections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);
        }
    }

    public World getWorld() {
        return this.loc.getWorld();
    }

    public int getX() {
        return this.loc.getX();
    }

    public int getY() {
        return this.loc.getY();
    }

    public int getZ() {
        return this.loc.getZ();
    }

    public RedstoneConnectionCache getRedstoneConnectionCache() {
        return this.connections;
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice dev, ConnectionType type) {
        if (type == ConnectionType.STRAIGHT) {
            return RedstoneHelper.canConnect((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)side, (ForgeDirection)(dev instanceof IFace ? ((IFace)((Object)dev)).getFace() : ForgeDirection.UNKNOWN));
        }
        return false;
    }

    @Override
    public byte getRedstonePower(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return 0;
        }
        return (byte)MathHelper.map((int)RedstoneHelper.getOutput((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)side), (int)0, (int)15, (int)0, (int)255);
    }

    @Override
    public void setRedstonePower(ForgeDirection side, byte power) {
    }

    public int getRedstoneOutput(int def) {
        if (this.loc.getBlock() instanceof BlockRedstoneWire) {
            return 0;
        }
        return def;
    }

    @Override
    public void onRedstoneUpdate() {
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return this.loc.getBlock().isSideSolid((IBlockAccess)this.loc.getWorld(), this.loc.getX(), this.loc.getY(), this.loc.getZ(), side);
    }
}

