/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part;

import com.bluepowermod.part.BPPartFace;
import com.bluepowermod.part.PartPlacementFaceRotate;
import com.bluepowermod.part.PartRotationHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class BPPartFaceRotate
extends BPPartFace {
    private int rotation = 0;

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        int old = this.rotation;
        this.rotation = rotation;
        if (rotation != old) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("rotation", this.rotation);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.rotation = tag.func_74762_e("rotation");
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.rotation);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.rotation = buffer.readInt();
    }

    @Override
    public IPartPlacement getPlacement(IPart part, World world, Vec3i location, ForgeDirection face, MovingObjectPosition mop, EntityPlayer player) {
        int rot = PartRotationHelper.getPlacementRotation(mop);
        if (face == ForgeDirection.UP || face == ForgeDirection.NORTH || face == ForgeDirection.WEST) {
            rot += 2;
        }
        if (!(face != ForgeDirection.DOWN && face != ForgeDirection.EAST || rot != 0 && rot != 2)) {
            rot += 2;
        }
        if (face == ForgeDirection.SOUTH && (rot == 1 || rot == 3)) {
            rot += 2;
        }
        return new PartPlacementFaceRotate(face.getOpposite(), rot % 4);
    }
}

