/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.tile.IWrenchable;
import ic2.core.item.tool.ItemToolPainter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.AdvancedInfoPanel;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.AdvancedInfoPanelExtender;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.AverageCounter;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.EnergyCounter;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.HowlerAlarm;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.IndustrialAlarm;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.InfoPanel;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.InfoPanelExtender;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.RangeTrigger;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.RemoteThermo;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.Subblock;
import shedar.mods.ic2.nuclearcontrol.blocks.subblocks.ThermalMonitor;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityHowlerAlarm;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityIndustrialAlarm;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanelExtender;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityRangeTrigger;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityRemoteThermo;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityThermo;
import shedar.mods.ic2.nuclearcontrol.utils.DyeUtil;
import shedar.mods.ic2.nuclearcontrol.utils.NuclearHelper;
import shedar.mods.ic2.nuclearcontrol.utils.RedstoneHelper;
import shedar.mods.ic2.nuclearcontrol.utils.WrenchHelper;

public class BlockNuclearControlMain
extends BlockContainer {
    public static Map<Integer, Subblock> subblocks;

    public BlockNuclearControlMain() {
        super(Material.field_151573_f);
        this.func_149711_c(0.5f);
        this.func_149647_a(IC2NuclearControl.tabIC2NC);
        subblocks = new HashMap<Integer, Subblock>();
        this.register(new ThermalMonitor());
        this.register(new IndustrialAlarm());
        this.register(new HowlerAlarm());
        this.register(new RemoteThermo());
        this.register(new InfoPanel());
        this.register(new InfoPanelExtender());
        this.register(new EnergyCounter());
        this.register(new AverageCounter());
        this.register(new RangeTrigger());
        this.register(new AdvancedInfoPanel());
        this.register(new AdvancedInfoPanelExtender());
    }

    public void register(Subblock block) {
        subblocks.put(block.getDamage(), block);
    }

    public int func_149645_b() {
        return IC2NuclearControl.instance.modelId;
    }

    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    private boolean isSolidBlockRequired(int metadata) {
        return subblocks.containsKey(metadata) && subblocks.get(metadata).isSolidBlockRequired();
    }

    public boolean canPlaceBlockAtlocal(World world, int x, int y, int z) {
        for (int face = 0; face < 6; ++face) {
            int side = Facing.field_71588_a[face];
            if (!world.isSideSolid(x + Facing.field_71586_b[side], y + Facing.field_71587_c[side], z + Facing.field_71585_d[side], ForgeDirection.getOrientation((int)face))) continue;
            return true;
        }
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        super.func_149660_a(world, x, y, z, side, hitX, hitY, hitZ, metadata);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        ForgeDirection opposite = dir.getOpposite();
        if (metadata > 10) {
            metadata = 0;
        }
        if (this.isSolidBlockRequired(metadata) && !world.isSideSolid(x + opposite.offsetX, y + opposite.offsetY, z + opposite.offsetZ, dir)) {
            side = 1;
        }
        return metadata + (side << 8);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack item) {
        int metadata = item.func_77960_j();
        this.onBlockPlacedBy(world, x, y, z, player, item, metadata);
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase player, ItemStack item, int metadata) {
        TileEntity block = world.func_147438_o(x, y, z);
        int side = metadata >> 8;
        if ((metadata &= 0xFF) > 10) {
            metadata = 0;
        }
        if (block instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)block;
            wrenchable.setFacing((short)side);
            if (player != null && !this.isSolidBlockRequired(metadata)) {
                int rotationSegment = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                if (player.field_70125_A >= 65.0f) {
                    wrenchable.setFacing((short)1);
                } else if (player.field_70125_A <= -65.0f) {
                    wrenchable.setFacing((short)0);
                } else {
                    switch (rotationSegment) {
                        case 0: {
                            wrenchable.setFacing((short)2);
                            break;
                        }
                        case 1: {
                            wrenchable.setFacing((short)5);
                            break;
                        }
                        case 2: {
                            wrenchable.setFacing((short)3);
                            break;
                        }
                        case 3: {
                            wrenchable.setFacing((short)4);
                            break;
                        }
                        default: {
                            wrenchable.setFacing((short)0);
                        }
                    }
                }
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (metadata > 10) {
            metadata = 0;
        }
        if (this.isSolidBlockRequired(metadata)) {
            for (int face = 0; face < 6; ++face) {
                int side = Facing.field_71588_a[face];
                if (!world.isSideSolid(x + Facing.field_71586_b[side], y + Facing.field_71587_c[side], z + Facing.field_71585_d[side], ForgeDirection.getOrientation((int)face))) continue;
                TileEntity tileentity = world.func_147438_o(x, y, z);
                if (!(tileentity instanceof IWrenchable)) break;
                ((IWrenchable)tileentity).setFacing((short)face);
                break;
            }
        }
        this.dropBlockIfCantStay(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        int metadata;
        int side = 0;
        TileEntity tileentity = world.func_147438_o(x, y, z);
        if (tileentity instanceof IWrenchable) {
            side = Facing.field_71588_a[((IWrenchable)tileentity).getFacing()];
        }
        if (this.isSolidBlockRequired(metadata = world.func_72805_g(x, y, z)) && !world.isSideSolid(x + Facing.field_71586_b[side], y + Facing.field_71587_c[side], z + Facing.field_71585_d[side], ForgeDirection.getOrientation((int)side).getOpposite())) {
            if (!world.field_72995_K) {
                this.func_149697_b(world, x, y, z, metadata, 0);
            }
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
        } else {
            RedstoneHelper.checkPowered(world, tileentity);
        }
        super.func_149695_a(world, x, y, z, neighbor);
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side, int metadata) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (!this.isSolidBlockRequired(metadata)) {
            return true;
        }
        return dir == ForgeDirection.DOWN && world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || dir == ForgeDirection.UP && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) || dir == ForgeDirection.NORTH && world.isSideSolid(x, y, z + 1, ForgeDirection.NORTH) || dir == ForgeDirection.SOUTH && world.isSideSolid(x, y, z - 1, ForgeDirection.SOUTH) || dir == ForgeDirection.WEST && world.isSideSolid(x + 1, y, z, ForgeDirection.WEST) || dir == ForgeDirection.EAST && world.isSideSolid(x - 1, y, z, ForgeDirection.EAST);
    }

    private boolean dropBlockIfCantStay(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (!this.isSolidBlockRequired(metadata)) {
            return true;
        }
        if (!this.canPlaceBlockAtlocal(world, x, y, z)) {
            if (world.func_147439_a(x, y, z) == world.func_147439_a(x, y, z)) {
                this.func_149697_b(world, x, y, z, metadata, 0);
                world.func_147468_f(x, y, z);
            }
            return false;
        }
        return true;
    }

    public static float[] getBlockBounds(int damage) {
        if (subblocks.containsKey(damage)) {
            return subblocks.get(damage).getBlockBounds(null);
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        int blockType = blockAccess.func_72805_g(x, y, z);
        float baseX1 = 0.0f;
        float baseY1 = 0.0f;
        float baseZ1 = 0.0f;
        float baseX2 = 1.0f;
        float baseY2 = 1.0f;
        float baseZ2 = 1.0f;
        TileEntity tileentity = blockAccess.func_147438_o(x, y, z);
        if (subblocks.containsKey(blockType)) {
            float[] bounds = subblocks.get(blockType).getBlockBounds(tileentity);
            baseX1 = bounds[0];
            baseY1 = bounds[1];
            baseZ1 = bounds[2];
            baseX2 = bounds[3];
            baseY2 = bounds[4];
            baseZ2 = bounds[5];
        }
        int side = 0;
        if (tileentity instanceof IWrenchable) {
            side = Facing.field_71588_a[((IWrenchable)tileentity).getFacing()];
        }
        switch (side) {
            case 1: {
                baseY1 = 1.0f - baseY1;
                baseY2 = 1.0f - baseY2;
                break;
            }
            case 2: {
                float tmp = baseY1;
                baseY1 = baseZ1;
                baseZ1 = tmp;
                tmp = baseY2;
                baseY2 = baseZ2;
                baseZ2 = tmp;
                break;
            }
            case 3: {
                float tmp = baseY1;
                baseY1 = baseZ1;
                baseZ1 = 1.0f - tmp;
                tmp = baseY2;
                baseY2 = baseZ2;
                baseZ2 = 1.0f - tmp;
                break;
            }
            case 4: {
                float tmp = baseY1;
                baseY1 = baseX1;
                baseX1 = tmp;
                tmp = baseY2;
                baseY2 = baseX2;
                baseX2 = tmp;
                break;
            }
            case 5: {
                float tmp = baseY1;
                baseY1 = baseX1;
                baseX1 = 1.0f - tmp;
                tmp = baseY2;
                baseY2 = baseX2;
                baseX2 = 1.0f - tmp;
            }
        }
        this.func_149676_a(Math.min(baseX1, baseX2), Math.min(baseY1, baseY2), Math.min(baseZ1, baseZ2), Math.max(baseX1, baseX2), Math.max(baseY1, baseY2), Math.max(baseZ1, baseZ2));
    }

    public String getInvName() {
        return "IC2 Thermo";
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float f1, float f2, float f3) {
        int blockType = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityHowlerAlarm) {
            if (player.func_71045_bC() != null && DyeUtil.isADye(player.func_71045_bC())) {
                ((TileEntityHowlerAlarm)tileEntity).setColor(ItemDye.field_150922_c[DyeUtil.getDyeId(player.func_71045_bC())]);
                world.func_147471_g(x, y, z);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (player.field_71071_by.func_70448_g().field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    } else {
                        --player.field_71071_by.func_70448_g().field_77994_a;
                    }
                }
                return true;
            }
            if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemToolPainter) {
                ItemToolPainter p = (ItemToolPainter)player.func_71045_bC().func_77973_b();
                ((TileEntityHowlerAlarm)tileEntity).setColor(ItemDye.field_150922_c[p.color]);
                world.func_147471_g(x, y, z);
                player.func_71045_bC().func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        if (WrenchHelper.isWrenchClicked(tileEntity, player, side)) {
            return true;
        }
        if (player != null && player.func_70093_af()) {
            return false;
        }
        if (subblocks.containsKey(blockType) && subblocks.get(blockType).hasGui()) {
            BlockSnapshot blockSnapshot;
            BlockEvent.PlaceEvent e;
            if (player instanceof EntityPlayerMP && !(e = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)(blockSnapshot = new BlockSnapshot(world, x, y, z, Blocks.field_150350_a, 0)), (ForgeDirection)ForgeDirection.getOrientation((int)side))).isCanceled()) {
                player.openGui((Object)IC2NuclearControl.instance, blockType, world, x, y, z);
            }
            return true;
        }
        return false;
    }

    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public int func_149709_b(IBlockAccess iblockaccess, int x, int y, int z, int direction) {
        return this.func_149748_c(iblockaccess, x, y, z, direction);
    }

    public int func_149748_c(IBlockAccess iblockaccess, int x, int y, int z, int direction) {
        TileEntity tileentity = iblockaccess.func_147438_o(x, y, z);
        if (!(tileentity instanceof TileEntityThermo) && !(tileentity instanceof TileEntityRangeTrigger)) {
            return 0;
        }
        int targetX = x;
        int targetY = y;
        int targetZ = z;
        switch (direction) {
            case 0: {
                ++targetY;
                break;
            }
            case 1: {
                --targetY;
                break;
            }
            case 2: {
                ++targetZ;
                break;
            }
            case 3: {
                --targetZ;
                break;
            }
            case 4: {
                ++targetX;
                break;
            }
            case 5: {
                --targetX;
            }
        }
        TileEntity targetEntity = iblockaccess.func_147438_o(targetX, targetY, targetZ);
        if (tileentity instanceof TileEntityThermo && targetEntity != null && (NuclearHelper.getReactorAt(tileentity.func_145831_w(), targetX, targetY, targetZ) != null || NuclearHelper.getReactorChamberAt(tileentity.func_145831_w(), targetX, targetY, targetZ) != null)) {
            return 0;
        }
        if (tileentity instanceof TileEntityRemoteThermo) {
            TileEntityRemoteThermo thermo = (TileEntityRemoteThermo)tileentity;
            if (thermo.getEnergy() > 0.0) {
                return thermo.getOnFire() >= thermo.getHeatLevel() ^ thermo.isInvertRedstone() ? 15 : 0;
            }
            return 0;
        }
        if (tileentity instanceof TileEntityRangeTrigger) {
            return ((TileEntityRangeTrigger)tileentity).getOnFire() > 0 ^ ((TileEntityRangeTrigger)tileentity).isInvertRedstone() ? 15 : 0;
        }
        return ((TileEntityThermo)tileentity).getOnFire() > 0 ^ ((TileEntityThermo)tileentity).isInvertRedstone() ? 15 : 0;
    }

    public IIcon func_149691_a(int side, int metadata) {
        if (subblocks.containsKey(metadata)) {
            return subblocks.get(metadata).getBlockTextureFromSide(side);
        }
        return null;
    }

    public IIcon func_149673_e(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int blockType = blockaccess.func_72805_g(x, y, z);
        if (subblocks.containsKey(blockType)) {
            return subblocks.get(blockType).getBlockTexture(blockaccess, x, y, z, side);
        }
        return null;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        for (Subblock subblock : subblocks.values()) {
            subblock.registerIcons(iconRegister);
        }
    }

    public Subblock getSubblock(int metadata) {
        if (subblocks.containsKey(metadata)) {
            return subblocks.get(metadata);
        }
        return null;
    }

    public int func_149692_a(int i) {
        if (i > 0 && i <= 10) {
            return i;
        }
        return 0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        int metadata = world.func_72805_g(x, y, z);
        return !this.isSolidBlockRequired(metadata);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntityInfoPanelExtender extender;
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity instanceof TileEntityIndustrialAlarm) {
            return ((TileEntityIndustrialAlarm)entity).lightLevel;
        }
        if (entity instanceof TileEntityInfoPanel) {
            if (((TileEntityInfoPanel)entity).getPowered()) {
                return 7;
            }
            return 0;
        }
        if (entity instanceof TileEntityInfoPanelExtender && (extender = (TileEntityInfoPanelExtender)entity).getScreen() != null) {
            TileEntityInfoPanel core = extender.getScreen().getCore((IBlockAccess)extender.func_145831_w());
            if (core != null && core.getPowered()) {
                return 7;
            }
            return 0;
        }
        return this.func_149750_m();
    }

    public void func_149666_a(Item id, CreativeTabs tab, List itemList) {
        for (int i = 0; i <= 10; ++i) {
            itemList.add(new ItemStack((Block)this, 1, i));
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (subblocks.containsKey(metadata)) {
            return subblocks.get(metadata).getTileEntity();
        }
        return null;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        this.dropItems(world, x, y, z);
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).equals((Object)this) && world.func_72805_g(x, y, z) == 2 && world.func_147438_o(x, y, z) instanceof TileEntityHowlerAlarm) {
            return ((TileEntityHowlerAlarm)world.func_147438_o(x, y, z)).getColor();
        }
        return 0xFFFFFF;
    }

    private int RGBToInt(int r, int g, int b) {
        int color = 0;
        color |= b;
        color |= g << 8;
        return color |= r << 16;
    }
}

