/*
 * Decompiled with CFR 0.152.
 */
package am2.power;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public abstract class AStar<T> {
    private PriorityQueue<Path> paths = new PriorityQueue();
    private HashMap<T, Double> mindists = new HashMap();
    private Double lastCost = 0.0;
    private int expandedCounter = 0;

    protected abstract boolean isGoal(T var1);

    protected abstract Double g(T var1, T var2);

    protected abstract Double h(T var1, T var2);

    protected abstract List<T> generateSuccessors(T var1);

    public int getExpandedCounter() {
        return this.expandedCounter;
    }

    protected Double f(Path p, T from, T to) {
        Double g = this.g(from, to) + (p.parent != null ? p.parent.g : 0.0);
        Double h = this.h(from, to);
        p.g = g;
        p.f = g + h;
        return p.f;
    }

    private void expand(Path path) {
        Object p = path.getPoint();
        Double min = this.mindists.get(path.getPoint());
        if (min != null && !(min > path.f)) {
            return;
        }
        this.mindists.put(path.getPoint(), path.f);
        List successors = this.generateSuccessors(p);
        for (Object t : successors) {
            Path newPath = new Path(path);
            newPath.setPoint(t);
            this.f(newPath, path.getPoint(), t);
            this.paths.offer(newPath);
        }
        ++this.expandedCounter;
    }

    public Double getCost() {
        return this.lastCost;
    }

    public List<T> compute(T start) {
        try {
            Path root = new Path();
            root.setPoint(start);
            this.f(root, start, start);
            this.expand(root);
            while (true) {
                Path p;
                if ((p = this.paths.poll()) == null) {
                    this.lastCost = Double.MAX_VALUE;
                    return null;
                }
                Object last = p.getPoint();
                this.lastCost = p.g;
                if (this.isGoal(last)) {
                    LinkedList retPath = new LinkedList();
                    Path i = p;
                    while (i != null) {
                        retPath.addFirst(i.getPoint());
                        i = i.parent;
                    }
                    return retPath;
                }
                this.expand(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class Path
    implements Comparable {
        public T point = null;
        public Double f;
        public Double g = this.f = Double.valueOf(0.0);
        public Path parent = null;

        public Path() {
        }

        public Path(Path p) {
            this();
            this.parent = p;
            this.g = p.g;
            this.f = p.f;
        }

        public int compareTo(Object o) {
            Path p = (Path)o;
            return (int)(this.f - p.f);
        }

        public T getPoint() {
            return this.point;
        }

        public void setPoint(T p) {
            this.point = p;
        }
    }
}

