/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.api.power.PowerTypes;
import am2.blocks.BlocksCommonProxy;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.power.PowerNodeRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityManaBattery
extends TileEntityAMPower {
    private boolean active;
    public static int storageCapacity;
    private PowerTypes outputPowerType = PowerTypes.NONE;
    private int tickCounter = 0;

    public TileEntityManaBattery() {
        super(250000);
        storageCapacity = 250000;
        this.active = false;
    }

    public PowerTypes getPowerType() {
        return this.outputPowerType;
    }

    public void setPowerType(PowerTypes type, boolean forceSubNodes) {
        this.outputPowerType = type;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return true;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.setPowerRequests();
        } else {
            this.setNoPowerRequests();
        }
        if (this.outputPowerType == PowerTypes.NONE && !this.field_145850_b.field_72995_K) {
            PowerTypes highest = PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this);
            float amt = PowerNodeRegistry.For(this.field_145850_b).getPower(this, highest);
            if (amt > 0.0f) {
                this.outputPowerType = highest;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        ++this.tickCounter;
        if (this.tickCounter % 600 == 0) {
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, BlocksCommonProxy.manaBattery);
            this.tickCounter = 0;
        }
        super.func_145845_h();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("isActive", this.active);
        nbttagcompound.func_74768_a("outputType", this.outputPowerType.ID());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.active = nbttagcompound.func_74767_n("isActive");
        if (nbttagcompound.func_74764_b("outputType")) {
            this.outputPowerType = PowerTypes.getByID(nbttagcompound.func_74762_e("outputType"));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public int getChargeRate() {
        return 1000;
    }

    @Override
    public PowerTypes[] getValidPowerTypes() {
        if (this.outputPowerType == PowerTypes.NONE) {
            return PowerTypes.all();
        }
        return new PowerTypes[]{this.outputPowerType};
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }
}

