/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.addon;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingbook.KitchenMultiBlock;
import net.blay09.mods.cookingbook.api.CookingAPI;
import net.blay09.mods.cookingbook.api.ToastHandler;
import net.blay09.mods.cookingbook.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenSmeltingProvider;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class HarvestCraftAddon {
    private static final String[] ADDITIONAL_RECIPES = new String[]{"flourItem", "doughItem", "cornmealItem", "freshwaterItem", "pastaItem", "vanillaItem", "butterItem", "heavycreamItem", "saltItem", "freshmilkItem", "mayoItem", "cocoapowderItem", "ketchupItem", "vinegarItem", "mustardItem", "blackpepperItem", "groundcinnamonItem", "groundnutmegItem", "saladdressingItem", "batterItem", "oliveoilItem"};
    private static final String[] OVEN_RECIPES = new String[]{"turkeyrawItem", "turkeycookedItem", "rabbitrawItem", "rabbitcookedItem", "venisonrawItem", "venisoncookedItem"};
    private static final String[] TOOLS = new String[]{"cuttingboardItem", "potItem", "skilletItem", "saucepanItem", "bakewareItem", "mortarandpestleItem", "mixingbowlItem", "juicerItem"};
    private static final String TOAST_ITEM = "toastItem";

    public HarvestCraftAddon() {
        KitchenMultiBlock.tileEntityWrappers.put("com.pam.harvestcraft.TileEntityOven", OvenWrapper.class);
        KitchenMultiBlock.blockWrappers.put("harvestcraft:pot", PotWrapper.class);
        KitchenMultiBlock.blockWrappers.put("harvestcraft:cuttingboard", CuttingBoardWrapper.class);
        CookingAPI.addOvenFuel(GameRegistry.findItemStack((String)"harvestcraft", (String)"oliveoilItem", (int)1), 1600);
        for (int i = 0; i < OVEN_RECIPES.length; i += 2) {
            ItemStack source = GameRegistry.findItemStack((String)"harvestcraft", (String)OVEN_RECIPES[i], (int)1);
            ItemStack result = GameRegistry.findItemStack((String)"harvestcraft", (String)OVEN_RECIPES[i + 1], (int)1);
            if (source == null || result == null) continue;
            CookingAPI.addOvenRecipe(source, result);
        }
        for (String toolName : TOOLS) {
            ItemStack toolItem = GameRegistry.findItemStack((String)"harvestcraft", (String)toolName, (int)1);
            if (toolItem == null) continue;
            CookingAPI.addToolItem(toolItem);
        }
        CookingAPI.addToastHandler(new ItemStack(Items.field_151025_P), new ToastHandler(){

            @Override
            public ItemStack getToasterOutput(ItemStack itemStack) {
                return GameRegistry.findItemStack((String)"harvestcraft", (String)HarvestCraftAddon.TOAST_ITEM, (int)1);
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onFoodRegistryInit(FoodRegistryInitEvent event) {
        event.registerNonFoodRecipe(new ItemStack(Items.field_151105_aU));
        event.registerNonFoodRecipe(new ItemStack(Items.field_151102_aT));
        for (String s : ADDITIONAL_RECIPES) {
            ItemStack itemStack = GameRegistry.findItemStack((String)"harvestcraft", (String)s, (int)1);
            if (itemStack == null) continue;
            event.registerNonFoodRecipe(itemStack);
        }
    }

    public static boolean isWeirdBrokenRecipe(IRecipe recipe) {
        if (recipe.func_77570_a() == 2 && recipe instanceof ShapelessOreRecipe) {
            List list;
            ShapelessOreRecipe oreRecipe = (ShapelessOreRecipe)recipe;
            Object first = oreRecipe.getInput().get(0);
            Object second = oreRecipe.getInput().get(1);
            ItemStack firstItem = null;
            ItemStack secondItem = null;
            if (first instanceof ItemStack) {
                firstItem = (ItemStack)first;
            } else if (first instanceof ArrayList && (list = (List)first).size() == 1) {
                firstItem = (ItemStack)list.get(0);
            }
            if (second instanceof ItemStack) {
                secondItem = (ItemStack)second;
            } else if (second instanceof ArrayList && (list = (List)second).size() == 1) {
                secondItem = (ItemStack)list.get(0);
            }
            if (firstItem != null && secondItem != null && ItemStack.func_77989_b((ItemStack)firstItem, (ItemStack)secondItem) && oreRecipe.func_77571_b().func_77969_a(firstItem)) {
                return true;
            }
        }
        return false;
    }

    public static class PotWrapper
    extends ToolWrapper {
        public PotWrapper(Block block) {
            super(block);
            this.itemStacks.add(GameRegistry.findItemStack((String)"harvestcraft", (String)"potItem", (int)1));
        }
    }

    public static class CuttingBoardWrapper
    extends ToolWrapper {
        public CuttingBoardWrapper(Block block) {
            super(block);
            this.itemStacks.add(GameRegistry.findItemStack((String)"harvestcraft", (String)"cuttingboardItem", (int)1));
        }
    }

    public static abstract class ToolWrapper
    implements IKitchenItemProvider {
        protected final List<ItemStack> itemStacks = new ArrayList<ItemStack>();

        public ToolWrapper(Block block) {
        }

        @Override
        public List<ItemStack> getProvidedItemStacks() {
            return this.itemStacks;
        }

        @Override
        public boolean addToCraftingBuffer(ItemStack itemStack) {
            return true;
        }

        @Override
        public void clearCraftingBuffer() {
        }

        @Override
        public void craftingComplete() {
        }
    }

    public static class OvenWrapper
    implements IKitchenSmeltingProvider {
        private final ISidedInventory inventory;

        public OvenWrapper(TileEntity tileEntity) {
            this.inventory = (ISidedInventory)tileEntity;
        }

        @Override
        public ItemStack smeltItem(ItemStack itemStack) {
            int[] inputSlots = this.inventory.func_94128_d(ForgeDirection.UP.ordinal());
            int firstEmptySlot = -1;
            for (int slot : inputSlots) {
                ItemStack slotStack = this.inventory.func_70301_a(slot);
                if (slotStack != null) {
                    int spaceLeft;
                    if (slotStack.func_77969_a(slotStack) && (spaceLeft = Math.min(itemStack.field_77994_a, slotStack.func_77976_d() - slotStack.field_77994_a)) > 0) {
                        slotStack.field_77994_a += spaceLeft;
                        itemStack.field_77994_a -= spaceLeft;
                    }
                    if (itemStack.field_77994_a > 0) continue;
                    return null;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = slot;
            }
            if (firstEmptySlot != -1) {
                this.inventory.func_70299_a(firstEmptySlot, itemStack);
                return null;
            }
            return itemStack;
        }
    }
}

