/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.gamedata.TownMap;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.TownBoundingArea;
import net.shadowmage.ancientwarfare.structure.world_gen.StructureEntry;

public class TownPlacementValidator {
    private static int maxSize = 21;

    public static TownBoundingArea findGenerationPosition(World world, int x, int z) {
        int diff;
        if (world == null) {
            return null;
        }
        TownMap tm = AWGameData.INSTANCE.getPerWorldData(world, TownMap.class);
        if (tm == null) {
            return null;
        }
        int minDist = AWStructureStatics.townClosestDistance * 16;
        float dist = tm.getClosestTown(x, z, minDist * 2);
        if (dist < (float)minDist) {
            return null;
        }
        int cx = x >> 4;
        int cz = z >> 4;
        int height = TownPlacementValidator.getTopFilledHeight(world.func_72964_e(cx, cz), x & 0xF, z & 0xF);
        if (height <= 0) {
            return null;
        }
        int minY = (int)Math.min(0.0, world.field_73011_w.getHorizon() - 7.0);
        TownBoundingArea area = new TownBoundingArea();
        area.minY = Math.max(minY, height);
        area.maxY = Math.min(255, area.minY + 15);
        area.chunkMinX = cx;
        area.chunkMaxX = cx;
        area.chunkMinZ = cz;
        area.chunkMaxZ = cz;
        TownPlacementValidator.expandBoundingArea(world, area);
        int cw = area.getChunkWidth();
        int cl = area.getChunkLength();
        if (cw > cl * 2) {
            diff = cw - cl * 2;
            while (diff > 0) {
                --area.chunkMaxX;
                if (--diff <= 0) continue;
                ++area.chunkMinX;
                --diff;
            }
        }
        if (cl > cw * 2) {
            diff = cl - cw * 2;
            while (diff > 0) {
                --area.chunkMaxZ;
                if (--diff <= 0) continue;
                ++area.chunkMinZ;
                --diff;
            }
        }
        return area;
    }

    public static boolean validateAreaForPlacement(World world, TownBoundingArea area) {
        return TownPlacementValidator.validateStructureCollision(world, area);
    }

    private static boolean validateStructureCollision(World world, TownBoundingArea area) {
        StructureMap map = AWGameData.INSTANCE.getData(world, StructureMap.class);
        if (map == null) {
            return true;
        }
        StructureBB bb = new StructureBB(new BlockPosition(area.getBlockMinX(), area.getMinY(), area.getBlockMaxX()), new BlockPosition(area.getBlockMaxX(), area.getMaxY(), area.getBlockMaxZ()));
        int size = Math.max(area.getChunkWidth(), area.getChunkLength());
        ArrayList<StructureEntry> entries = new ArrayList<StructureEntry>();
        map.getEntriesNear(world, area.getCenterX(), area.getCenterZ(), size, true, entries);
        for (StructureEntry e : entries) {
            if (!e.getBB().crossWith(bb)) continue;
            AWLog.logDebug("Skipping town generation at: " + area + " for intersection with existing structure at: " + e.getBB());
            return false;
        }
        return true;
    }

    private static void expandBoundingArea(World world, TownBoundingArea area) {
        boolean xneg = true;
        boolean xpos = true;
        boolean zneg = true;
        boolean zpos = true;
        boolean didExpand = false;
        do {
            didExpand = false;
            if (xneg && area.getChunkWidth() <= maxSize) {
                xneg = TownPlacementValidator.tryExpandXNeg(world, area);
                boolean bl = didExpand = didExpand || xneg;
            }
            if (xpos && area.getChunkWidth() <= maxSize) {
                xpos = TownPlacementValidator.tryExpandXPos(world, area);
                boolean bl = didExpand = didExpand || xpos;
            }
            if (zneg && area.getChunkLength() <= maxSize) {
                zneg = TownPlacementValidator.tryExpandZNeg(world, area);
                boolean bl = didExpand = didExpand || zneg;
            }
            if (!zpos || area.getChunkLength() > maxSize) continue;
            zpos = TownPlacementValidator.tryExpandZPos(world, area);
            boolean bl = didExpand = didExpand || zpos;
        } while (didExpand && (area.getChunkWidth() <= maxSize || area.getChunkLength() <= maxSize));
    }

    private static boolean tryExpandXNeg(World world, TownBoundingArea area) {
        int cx = area.chunkMinX - 1;
        for (int z = area.chunkMinZ; z <= area.chunkMaxZ; ++z) {
            if (TownPlacementValidator.isAverageHeightWithin(world, cx, z, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMinX = cx;
        return true;
    }

    private static boolean tryExpandXPos(World world, TownBoundingArea area) {
        int cx = area.chunkMaxX + 1;
        for (int z = area.chunkMinZ; z <= area.chunkMaxZ; ++z) {
            if (TownPlacementValidator.isAverageHeightWithin(world, cx, z, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMaxX = cx;
        return true;
    }

    private static boolean tryExpandZNeg(World world, TownBoundingArea area) {
        int cz = area.chunkMinZ - 1;
        for (int x = area.chunkMinX; x <= area.chunkMaxX; ++x) {
            if (TownPlacementValidator.isAverageHeightWithin(world, x, cz, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMinZ = cz;
        return true;
    }

    private static boolean tryExpandZPos(World world, TownBoundingArea area) {
        int cz = area.chunkMaxZ + 1;
        for (int x = area.chunkMinX; x <= area.chunkMaxX; ++x) {
            if (TownPlacementValidator.isAverageHeightWithin(world, x, cz, area.minY, area.maxY)) continue;
            return false;
        }
        area.chunkMaxZ = cz;
        return true;
    }

    private static boolean isAverageHeightWithin(World world, int cx, int cz, int min, int max) {
        Chunk chunk = world.func_72964_e(cx, cz);
        int total = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int val = TownPlacementValidator.getTopFilledHeight(chunk, x, z);
                if (val < 0) {
                    return false;
                }
                total += val;
            }
        }
        return (total /= world.func_72800_K()) >= min && total <= max;
    }

    private static int getTopFilledHeight(Chunk chunk, int xInChunk, int zInChunk) {
        int maxY;
        for (int y = maxY = chunk.func_76625_h() + 15; y > 0; --y) {
            Block block = chunk.func_150810_a(xInChunk, y, zInChunk);
            if (AWStructureStatics.skippableBlocksContains(block)) continue;
            if (block.func_149688_o().func_76224_d()) {
                if (y >= 56) continue;
                return -1;
            }
            if (!AWStructureStatics.isValidTownTargetBlock(block)) {
                AWLog.logDebug("rejecting town chunk for non-target block: " + block + " :: " + chunk.field_76635_g + ":" + chunk.field_76647_h);
                return -1;
            }
            return y;
        }
        return -1;
    }
}

