/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.load;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateParsingException;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.template.StructurePluginManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateFormatConverter;

public class TemplateParser {
    public static final TemplateParser INSTANCE = new TemplateParser();
    private final TemplateFormatConverter converter = new TemplateFormatConverter();
    public static int lineNumber = -1;

    private TemplateParser() {
    }

    public StructureTemplate parseTemplate(String fileName, List<String> templateLines) {
        try {
            return this.parseTemplateLines(fileName, templateLines);
        }
        catch (TemplateParsingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private StructureTemplate parseTemplateLines(String fileName, List<String> lines) throws IllegalArgumentException, TemplateParsingException {
        lineNumber = -1;
        Iterator<String> it = lines.iterator();
        ArrayList<TemplateRule> parsedRules = new ArrayList<TemplateRule>();
        ArrayList<TemplateRuleEntity> parsedEntities = new ArrayList<TemplateRuleEntity>();
        TemplateRule[] ruleArray = null;
        TemplateRuleEntity[] entityRuleArray = null;
        StructureValidator validation = null;
        ArrayList<String> groupedLines = new ArrayList<String>();
        int parsedLayers = 0;
        String name = null;
        int xSize = 0;
        int ySize = 0;
        int zSize = 0;
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        short[] templateData = null;
        boolean newVersion = false;
        boolean[] initData = new boolean[4];
        int highestParsedRule = 0;
        while (it.hasNext()) {
            Object e1;
            String data;
            ++lineNumber;
            String line = it.next();
            if (line.startsWith("#") || line.equals("")) continue;
            if (line.startsWith("header:")) {
                while (it.hasNext()) {
                    line = it.next();
                    ++lineNumber;
                    if (line.startsWith(":endheader")) break;
                    if (line.startsWith("version=")) {
                        newVersion = true;
                        initData[0] = true;
                    }
                    if (line.startsWith("name=")) {
                        name = StringTools.safeParseString("=", line);
                        initData[1] = true;
                    }
                    if (line.startsWith("size=")) {
                        int[] sizes = StringTools.safeParseIntArray("=", line);
                        xSize = sizes[0];
                        ySize = sizes[1];
                        zSize = sizes[2];
                        initData[2] = true;
                    }
                    if (!line.startsWith("offset=")) continue;
                    int[] offsets = StringTools.safeParseIntArray("=", line);
                    xOffset = offsets[0];
                    yOffset = offsets[1];
                    zOffset = offsets[2];
                    initData[3] = true;
                }
                for (int i = 0; i < 4; ++i) {
                    if (initData[i]) continue;
                    throw new TemplateParsingException("Could not parse template for " + fileName + " -- template was missing header or header data.");
                }
                templateData = new short[xSize * ySize * zSize];
            }
            if (!newVersion) {
                try {
                    return this.converter.convertOldTemplate(fileName, lines);
                }
                catch (Exception e) {
                    throw new TemplateParsingException("Error parsing template: " + fileName + " at line: " + (this.converter.lineNumber + 1) + " for line: " + lines.get(this.converter.lineNumber));
                }
            }
            if (line.startsWith("validation:")) {
                groupedLines.add(line);
                while (it.hasNext()) {
                    line = it.next();
                    groupedLines.add(line);
                    if (!line.startsWith(":endvalidation")) continue;
                }
                validation = StructureValidator.parseValidator(groupedLines);
                groupedLines.clear();
            }
            if (line.startsWith("rule:")) {
                groupedLines.add(line);
                while (it.hasNext()) {
                    line = it.next();
                    groupedLines.add(line);
                    if (!line.startsWith(":endrule")) continue;
                }
                try {
                    TemplateRule rule = this.parseRule(groupedLines, "rule");
                    if (rule != null) {
                        parsedRules.add(rule);
                        if (rule.ruleNumber > highestParsedRule) {
                            highestParsedRule = rule.ruleNumber;
                        }
                    }
                }
                catch (TemplateParsingException.TemplateRuleParsingException e) {
                    data = e.getMessage() + "\n";
                    for (String line1 : groupedLines) {
                        data = data + line1 + "\n";
                    }
                    e1 = new TemplateParsingException.TemplateRuleParsingException(data, e);
                    AWLog.logError("Caught exception parsing template rule for structure: " + name);
                    AWLog.logError(((Throwable)e1).getMessage());
                }
                groupedLines.clear();
            }
            if (line.startsWith("entity:")) {
                groupedLines.add(line);
                while (it.hasNext()) {
                    line = it.next();
                    groupedLines.add(line);
                    if (!line.startsWith(":endentity")) continue;
                }
                try {
                    TemplateRuleEntity rule = (TemplateRuleEntity)this.parseRule(groupedLines, "entity");
                    if (rule != null) {
                        parsedEntities.add(rule);
                    }
                }
                catch (TemplateParsingException.TemplateRuleParsingException e) {
                    data = e.getMessage() + "\n";
                    for (String line1 : groupedLines) {
                        data = data + line1 + "\n";
                    }
                    e1 = new TemplateParsingException.TemplateRuleParsingException(data, e);
                    AWLog.logError("Caught exception parsing template rule for structure: " + name);
                    AWLog.logError(((Throwable)e1).getMessage());
                }
                groupedLines.clear();
            }
            if (!line.startsWith("layer:")) continue;
            groupedLines.add(line);
            while (it.hasNext()) {
                line = it.next();
                groupedLines.add(line);
                if (!line.startsWith(":endlayer")) continue;
            }
            this.parseLayer(groupedLines, parsedLayers, xSize, ySize, zSize, templateData);
            ++parsedLayers;
            groupedLines.clear();
        }
        ruleArray = new TemplateRule[highestParsedRule + 1];
        for (TemplateRule rule : parsedRules) {
            if (rule == null || rule.ruleNumber <= 0) continue;
            ruleArray[rule.ruleNumber] = rule;
        }
        entityRuleArray = new TemplateRuleEntity[parsedEntities.size()];
        int ruleNumber = 0;
        Iterator iterator = parsedEntities.iterator();
        while (iterator.hasNext()) {
            TemplateRuleEntity rule;
            entityRuleArray[ruleNumber] = rule = (TemplateRuleEntity)iterator.next();
            ++ruleNumber;
        }
        return this.constructTemplate(name, xSize, ySize, zSize, xOffset, yOffset, zOffset, templateData, ruleArray, entityRuleArray, validation);
    }

    private TemplateRule parseRule(List<String> templateLines, String ruleType) throws TemplateParsingException.TemplateRuleParsingException {
        return StructurePluginManager.getRule(templateLines, ruleType);
    }

    private StructureTemplate constructTemplate(String name, int x, int y, int z, int xo, int yo, int zo, short[] templateData, TemplateRule[] rules, TemplateRuleEntity[] entityRules, StructureValidator validation) {
        StructureTemplate template = new StructureTemplate(name, x, y, z, xo, yo, zo);
        template.setRuleArray(rules);
        template.setEntityRules(entityRules);
        template.setTemplateData(templateData);
        template.setValidationSettings(validation);
        return template;
    }

    private void parseLayer(List<String> templateLines, int yLayer, int xSize, int ySize, int zSize, short[] templateData) {
        int z = 0;
        for (String st : templateLines) {
            ++lineNumber;
            if (st.startsWith("layer:") || st.startsWith(":endlayer")) continue;
            short[] data = StringTools.parseShortArray(st);
            for (int x = 0; x < xSize && x < data.length; ++x) {
                templateData[StructureTemplate.getIndex((int)x, (int)yLayer, (int)z, (int)xSize, (int)ySize, (int)zSize)] = data[x];
            }
            ++z;
        }
    }
}

