/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.shadowmage.ancientwarfare.core.config.AWLog;
import net.shadowmage.ancientwarfare.core.util.BlockPosition;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.block.BlockDataManager;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationProperty;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateParser;
import net.shadowmage.ancientwarfare.structure.world_gen.WorldStructureGenerator;

public abstract class StructureValidator {
    public static final String PROP_WORLD_GEN = "enableWorldGen";
    public static final String PROP_UNIQUE = "unique";
    public static final String PROP_SURVIVAL = "survival";
    public static final String PROP_PRESERVE_BLOCKS = "preserveBlocks";
    public static final String PROP_SELECTION_WEIGHT = "selectionWeight";
    public static final String PROP_CLUSTER_VALUE = "clusterValue";
    public static final String PROP_MIN_DUPLICATE_DISTANCE = "minDuplicateDistance";
    public static final String PROP_BORDER_SIZE = "borderSize";
    public static final String PROP_MAX_LEVELING = "maxLeveling";
    public static final String PROP_MAX_FILL = "maxFill";
    public static final String PROP_BIOME_WHITE_LIST = "biomeWhiteList";
    public static final String PROP_DIMENSION_WHITE_LIST = "dimensionWhiteList";
    public static final String PROP_BIOME_LIST = "biomeList";
    public static final String PROP_DIMENSION_LIST = "dimensionList";
    public static final String PROP_BLOCK_LIST = "blockList";
    public static final String PROP_BLOCK_SWAP = "blockSwap";
    public final StructureValidationType validationType;
    private HashMap<String, StructureValidationProperty> properties = new HashMap();

    protected StructureValidator(StructureValidationType validationType) {
        this.validationType = validationType;
        for (StructureValidationProperty property : validationType.getValidationProperties()) {
            this.properties.put(property.regName, property.copy());
        }
    }

    public void inheritPropertiesFrom(StructureValidator validator) {
        for (String name : this.properties.keySet()) {
            if (!validator.properties.containsKey(name)) continue;
            StructureValidationProperty prop = validator.properties.get(name);
            this.properties.put(name, prop.copy());
        }
    }

    protected void readFromLines(List<String> lines) {
    }

    protected void write(BufferedWriter writer) throws IOException {
    }

    public final void readFromNBT(NBTTagCompound tag) {
        for (StructureValidationProperty prop : this.properties.values()) {
            prop.readFromNBT(tag);
        }
    }

    public final void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("validationType", this.validationType.getName());
        for (StructureValidationProperty prop : this.properties.values()) {
            prop.writeToNBT(tag);
        }
    }

    protected void setDefaultSettings(StructureTemplate template) {
    }

    public abstract boolean shouldIncludeForSelection(World var1, int var2, int var3, int var4, int var5, StructureTemplate var6);

    public int getAdjustedSpawnY(World world, int x, int y, int z, int face, StructureTemplate template, StructureBB bb) {
        return y;
    }

    public abstract boolean validatePlacement(World var1, int var2, int var3, int var4, int var5, StructureTemplate var6, StructureBB var7);

    public abstract void preGeneration(World var1, BlockPosition var2, int var3, StructureTemplate var4, StructureBB var5);

    public void postGeneration(World world, BlockPosition origin, StructureBB bb) {
    }

    public void handleClearAction(World world, int x, int y, int z, StructureTemplate template, StructureBB bb) {
        world.func_147449_b(x, y, z, Blocks.field_150350_a);
    }

    public static boolean startLow(String text, String test) {
        return text.toLowerCase(Locale.ENGLISH).startsWith(test);
    }

    public static final StructureValidator parseValidator(List<String> lines) {
        StructureValidator validator;
        String line;
        String type = null;
        ArrayList<String> tagLines = new ArrayList<String>();
        Iterator<String> it = lines.iterator();
        boolean unique = false;
        boolean worldGen = false;
        boolean biome = false;
        boolean dimension = false;
        boolean blocks = false;
        boolean survival = false;
        boolean swap = false;
        int selectionWeight = 1;
        int clusterValue = 1;
        int duplicate = 1;
        int maxLeveling = 0;
        int maxFill = 0;
        int borderSize = 0;
        int[] dimensions = null;
        HashSet<String> biomes = new HashSet<String>();
        HashSet<String> validTargetBlocks = new HashSet<String>();
        while (it.hasNext() && (line = it.next()) != null) {
            if (StructureValidator.startLow(line, "type=")) {
                type = StringTools.safeParseString("=", line);
            } else if (StructureValidator.startLow(line, "unique=")) {
                unique = StringTools.safeParseBoolean("=", line);
            } else if (StructureValidator.startLow(line, "survival=")) {
                survival = StringTools.safeParseBoolean("=", line);
            } else if (StructureValidator.startLow(line, "worldgenenabled=")) {
                worldGen = StringTools.safeParseBoolean("=", line);
            } else if (StructureValidator.startLow(line, "biomewhitelist=")) {
                biome = StringTools.safeParseBoolean("=", line);
            } else if (StructureValidator.startLow(line, "dimensionwhitelist=")) {
                dimension = StringTools.safeParseBoolean("=", line);
            } else if (StructureValidator.startLow(line, "preserveblocks=")) {
                blocks = StringTools.safeParseBoolean("=", line);
            } else if (StructureValidator.startLow(line, "dimensionlist=")) {
                dimensions = StringTools.safeParseIntArray("=", line);
            } else if (StructureValidator.startLow(line, "biomelist=")) {
                StringTools.safeParseStringsToSet(biomes, "=", line, true);
            } else if (StructureValidator.startLow(line, "selectionweight=")) {
                selectionWeight = StringTools.safeParseInt("=", line);
            } else if (StructureValidator.startLow(line, "clustervalue=")) {
                clusterValue = StringTools.safeParseInt("=", line);
            } else if (StructureValidator.startLow(line, "minduplicatedistance=")) {
                duplicate = StringTools.safeParseInt("=", line);
            } else if (StructureValidator.startLow(line, "leveling=")) {
                maxLeveling = StringTools.safeParseInt("=", line);
            } else if (StructureValidator.startLow(line, "fill=")) {
                maxFill = StringTools.safeParseInt("=", line);
            } else if (StructureValidator.startLow(line, "border=")) {
                borderSize = StringTools.safeParseInt("=", line);
            } else if (StructureValidator.startLow(line, "validtargetblocks=")) {
                StringTools.safeParseStringsToSet(validTargetBlocks, "=", line, false);
            } else if (StructureValidator.startLow(line, "blockSwap=")) {
                swap = StringTools.safeParseBoolean("=", line);
            } else if (StructureValidator.startLow(line, "data:")) {
                tagLines.add(line);
                while (it.hasNext() && (line = it.next()) != null) {
                    tagLines.add(line);
                    if (!StructureValidator.startLow(line, ":enddata")) continue;
                }
            }
            ++TemplateParser.lineNumber;
        }
        StructureValidationType validatorType = StructureValidationType.getTypeFromName(type);
        if (validatorType == null) {
            validator = StructureValidationType.GROUND.getValidator();
        } else {
            validator = validatorType.getValidator();
            validator.readFromLines(tagLines);
        }
        validator.setProperty(PROP_DIMENSION_WHITE_LIST, dimension);
        validator.setProperty(PROP_DIMENSION_LIST, dimensions);
        validator.setProperty(PROP_BIOME_WHITE_LIST, biome);
        validator.setProperty(PROP_BIOME_LIST, biomes);
        validator.setProperty(PROP_WORLD_GEN, worldGen);
        validator.setProperty(PROP_SURVIVAL, survival);
        validator.setProperty(PROP_UNIQUE, unique);
        validator.setProperty(PROP_PRESERVE_BLOCKS, blocks);
        validator.setProperty(PROP_CLUSTER_VALUE, clusterValue);
        validator.setProperty(PROP_SELECTION_WEIGHT, selectionWeight);
        validator.setProperty(PROP_MIN_DUPLICATE_DISTANCE, duplicate);
        validator.setProperty(PROP_MAX_FILL, maxFill);
        validator.setProperty(PROP_MAX_LEVELING, maxLeveling);
        validator.setProperty(PROP_BORDER_SIZE, borderSize);
        validator.setProperty(PROP_BLOCK_LIST, validTargetBlocks);
        validator.setProperty(PROP_BLOCK_SWAP, swap);
        return validator;
    }

    public static final void writeValidator(BufferedWriter out, StructureValidator validator) throws IOException {
        out.write("type=" + validator.validationType.getName());
        out.newLine();
        out.write("survival=" + validator.isSurvival());
        out.newLine();
        out.write("worldGenEnabled=" + validator.isWorldGenEnabled());
        out.newLine();
        out.write("unique=" + validator.isUnique());
        out.newLine();
        out.write("preserveBlocks=" + validator.isPreserveBlocks());
        out.newLine();
        out.write("selectionWeight=" + validator.getSelectionWeight());
        out.newLine();
        out.write("clusterValue=" + validator.getClusterValue());
        out.newLine();
        out.write("minDuplicateDistance=" + validator.getMinDuplicateDistance());
        out.newLine();
        out.write("dimensionWhiteList=" + validator.isDimensionWhiteList());
        out.newLine();
        out.write("dimensionList=" + StringTools.getCSVStringForArray(validator.getAcceptedDimensions()));
        out.newLine();
        out.write("biomeWhiteList=" + validator.isBiomeWhiteList());
        out.newLine();
        out.write("biomeList=" + StringTools.getCSVValueFor(validator.getBiomeList().toArray(new String[validator.getBiomeList().size()])));
        out.newLine();
        out.write("leveling=" + validator.getMaxLeveling());
        out.newLine();
        out.write("fill=" + validator.getMaxFill());
        out.newLine();
        out.write("border=" + validator.getBorderSize());
        out.newLine();
        out.write("validTargetBlocks=" + StringTools.getCSVfor(validator.getTargetBlocks()));
        out.newLine();
        out.write("blockSwap=" + validator.isBlockSwap());
        out.newLine();
        out.write("data:");
        out.newLine();
        validator.write(out);
        out.write(":enddata");
        out.newLine();
    }

    public final StructureValidator setDefaults(StructureTemplate template) {
        this.setDefaultSettings(template);
        return this;
    }

    public final StructureValidationProperty getProperty(String name) {
        return this.properties.get(name);
    }

    public final void setProperty(String name, Object value) {
        if (!this.properties.containsKey(name)) {
            throw new IllegalArgumentException("Validation properties does not contain key for: " + name);
        }
        this.properties.get(name).setValue(value);
    }

    public final void setBiomeWhiteList(boolean val) {
        this.properties.get(PROP_BIOME_WHITE_LIST).setValue(val);
    }

    public final void setDimensionWhiteList(boolean val) {
        this.properties.get(PROP_DIMENSION_WHITE_LIST).setValue(val);
    }

    public final boolean isBlockSwap() {
        return this.properties.get(PROP_BLOCK_SWAP).getDataBoolean();
    }

    public final int getSelectionWeight() {
        return this.properties.get(PROP_SELECTION_WEIGHT).getDataInt();
    }

    public final int getClusterValue() {
        return this.properties.get(PROP_CLUSTER_VALUE).getDataInt();
    }

    public final boolean isWorldGenEnabled() {
        return this.properties.get(PROP_WORLD_GEN).getDataBoolean();
    }

    public final boolean isPreserveBlocks() {
        return this.properties.get(PROP_PRESERVE_BLOCKS).getDataBoolean();
    }

    public final boolean isBiomeWhiteList() {
        return this.properties.get(PROP_BIOME_WHITE_LIST).getDataBoolean();
    }

    public final boolean isUnique() {
        return this.properties.get(PROP_UNIQUE).getDataBoolean();
    }

    public final boolean isDimensionWhiteList() {
        return this.properties.get(PROP_DIMENSION_WHITE_LIST).getDataBoolean();
    }

    public final int[] getAcceptedDimensions() {
        return this.properties.get(PROP_DIMENSION_LIST).getDataIntArray();
    }

    public final void setValidDimension(Set<Integer> dims) {
        int[] dimsa = new int[dims.size()];
        int index = 0;
        for (Integer dim : dims) {
            dimsa[index] = dim;
            ++index;
        }
        this.properties.get(PROP_DIMENSION_LIST).setValue(dimsa);
    }

    public final int getMinDuplicateDistance() {
        return this.properties.get(PROP_MIN_DUPLICATE_DISTANCE).getDataInt();
    }

    public final void setTargetBlocks(Collection<String> targetBlocks) {
        HashSet<String> blocks = new HashSet<String>();
        blocks.addAll(targetBlocks);
        this.properties.get(PROP_BLOCK_LIST).setValue(blocks);
    }

    public final void setBiomeList(Collection<String> biomes) {
        HashSet<String> blocks = new HashSet<String>();
        blocks.addAll(biomes);
        this.properties.get(PROP_BIOME_LIST).setValue(blocks);
    }

    public Set<String> getTargetBlocks() {
        return this.properties.get(PROP_BLOCK_LIST).getDataStringSet();
    }

    public Set<String> getBiomeList() {
        return this.properties.get(PROP_BIOME_LIST).getDataStringSet();
    }

    public int getMaxFill() {
        return this.properties.get(PROP_MAX_FILL).getDataInt();
    }

    public int getMaxLeveling() {
        return this.properties.get(PROP_MAX_LEVELING).getDataInt();
    }

    public int getBorderSize() {
        return this.properties.get(PROP_BORDER_SIZE).getDataInt();
    }

    protected boolean validateBorderBlocks(World world, StructureTemplate template, StructureBB bb, int minY, int maxY, boolean skipWater) {
        int bz;
        int bx;
        Set<String> validTargetBlocks = this.getTargetBlocks();
        int borderSize = this.getBorderSize();
        for (bx = bb.min.x - borderSize; bx <= bb.max.x + borderSize; ++bx) {
            bz = bb.min.z - borderSize;
            if (!this.validateBlockHeightAndType(world, bx, bz, minY, maxY, skipWater, validTargetBlocks)) {
                return false;
            }
            bz = bb.max.z + borderSize;
            if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, skipWater, validTargetBlocks)) continue;
            return false;
        }
        for (bz = bb.min.z - borderSize + 1; bz <= bb.max.z + borderSize - 1; ++bz) {
            bx = bb.min.x - borderSize;
            if (!this.validateBlockHeightAndType(world, bx, bz, minY, maxY, skipWater, validTargetBlocks)) {
                return false;
            }
            bx = bb.max.x + borderSize;
            if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, skipWater, validTargetBlocks)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateBlockHeightAndType(World world, int x, int z, int min, int max, boolean skipWater, Set<String> validBlocks) {
        return this.validateBlockType(world, x, this.validateBlockHeight(world, x, z, min, max, skipWater), z, validBlocks);
    }

    protected int validateBlockHeight(World world, int x, int z, int minimumAcceptableY, int maximumAcceptableY, boolean skipWater) {
        int topFilledY = WorldStructureGenerator.getTargetY(world, x, z, skipWater);
        if (topFilledY < minimumAcceptableY || topFilledY > maximumAcceptableY) {
            AWLog.logDebug("rejected for leveling or depth test. foundY: " + topFilledY + " min: " + minimumAcceptableY + " max:" + maximumAcceptableY + " at: " + x + "," + topFilledY + "," + z);
            return -1;
        }
        return topFilledY;
    }

    protected boolean validateBlockType(World world, int x, int y, int z, Set<String> validBlocks) {
        if (y < 0 || y >= world.func_72800_K()) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (block == null) {
            AWLog.logDebug("rejected for non-matching block: air at: " + x + "," + y + "," + z);
            return false;
        }
        if (!validBlocks.contains(BlockDataManager.INSTANCE.getNameForBlock(block))) {
            AWLog.logDebug("Rejected for non-matching block: " + BlockDataManager.INSTANCE.getNameForBlock(block) + " at: " + x + "," + y + "," + z + " Valid blocks: " + validBlocks);
            return false;
        }
        return true;
    }

    protected int getMinY(StructureTemplate template, StructureBB bb) {
        int minY = bb.min.y - this.getMaxFill() - 1;
        if (this.getBorderSize() > 0) {
            minY += template.yOffset;
        }
        return minY;
    }

    protected int getMaxY(StructureTemplate template, StructureBB bb) {
        return bb.min.y + template.yOffset + this.getMaxLeveling();
    }

    protected int getMinFillY(StructureTemplate template, StructureBB bb) {
        return this.getMinY(template, bb);
    }

    protected int getMaxFillY(StructureTemplate template, StructureBB bb) {
        return this.getMinY(template, bb) + this.getMaxFill();
    }

    protected int getMinLevelingY(StructureTemplate template, StructureBB bb) {
        return bb.min.y + template.yOffset;
    }

    protected int getMaxLevelingY(StructureTemplate template, StructureBB bb) {
        return bb.min.y + template.yOffset + this.getMaxLeveling();
    }

    protected void borderLeveling(World world, int x, int z, StructureTemplate template, StructureBB bb) {
        int y;
        Block block;
        if (this.getMaxLeveling() <= 0) {
            return;
        }
        int topFilledY = WorldStructureGenerator.getTargetY(world, x, z, true);
        int step = WorldStructureGenerator.getStepNumber(x, z, bb.min.x, bb.max.x, bb.min.z, bb.max.z);
        for (int y2 = bb.min.y + template.yOffset + step; y2 <= topFilledY; ++y2) {
            this.handleClearAction(world, x, y2, z, template, bb);
        }
        BiomeGenBase biome = world.func_72807_a(x, z);
        BlockGrass fillBlock = Blocks.field_150349_c;
        if (biome != null && biome.field_76752_A != null) {
            fillBlock = biome.field_76752_A;
        }
        if ((block = world.func_147439_a(x, y = bb.min.y + template.yOffset + step - 1, z)) != null && block != Blocks.field_150350_a && block.func_149688_o() != Material.field_151586_h && !AWStructureStatics.skippableBlocksContains(block)) {
            world.func_147449_b(x, y, z, (Block)fillBlock);
        }
    }

    protected void borderFill(World world, int x, int z, StructureTemplate template, StructureBB bb) {
        if (this.getMaxFill() <= 0) {
            return;
        }
        int maxFillY = this.getMaxFillY(template, bb);
        int step = WorldStructureGenerator.getStepNumber(x, z, bb.min.x, bb.max.x, bb.min.z, bb.max.z);
        maxFillY -= step;
        BiomeGenBase biome = world.func_72807_a(x, z);
        BlockGrass fillBlockID = Blocks.field_150349_c;
        if (biome != null && biome.field_76752_A != null) {
            fillBlockID = biome.field_76752_A;
        }
        for (int y = maxFillY; y > 1; --y) {
            Block block = world.func_147439_a(x, y, z);
            if (!AWStructureStatics.skippableBlocksContains(block) && block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
            world.func_147449_b(x, y, z, (Block)fillBlockID);
        }
    }

    protected void underFill(World world, int x, int z, StructureTemplate template, StructureBB bb) {
        int topFilledY = WorldStructureGenerator.getTargetY(world, x, z, true);
        BiomeGenBase biome = world.func_72807_a(x, z);
        BlockGrass fillBlockID = Blocks.field_150349_c;
        if (biome != null && biome.field_76752_A != null) {
            fillBlockID = biome.field_76752_A;
        }
        for (int y = topFilledY; y <= bb.min.y - 1; ++y) {
            world.func_147449_b(x, y, z, (Block)fillBlockID);
        }
    }

    protected void prePlacementUnderfill(World world, StructureTemplate template, StructureBB bb) {
        if (this.getMaxFill() <= 0) {
            return;
        }
        for (int bx = bb.min.x; bx <= bb.max.x; ++bx) {
            for (int bz = bb.min.z; bz <= bb.max.z; ++bz) {
                this.underFill(world, bx, bz, template, bb);
            }
        }
    }

    protected void prePlacementBorder(World world, StructureTemplate template, StructureBB bb) {
        int bz;
        int bx;
        int borderSize = this.getBorderSize();
        if (borderSize <= 0) {
            return;
        }
        for (bx = bb.min.x - borderSize; bx <= bb.max.x + borderSize; ++bx) {
            for (bz = bb.max.z + borderSize; bz > bb.max.z; --bz) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
            for (bz = bb.min.z - borderSize; bz < bb.min.z; ++bz) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
        }
        for (bz = bb.min.z; bz <= bb.max.z; ++bz) {
            for (bx = bb.min.x - borderSize; bx < bb.min.x; ++bx) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
            for (bx = bb.max.x + borderSize; bx > bb.max.x; --bx) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
        }
    }

    public Collection<StructureValidationProperty> getProperties() {
        return this.properties.values();
    }

    public boolean isSurvival() {
        return this.properties.get(PROP_SURVIVAL).getDataBoolean();
    }
}

