/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;

public class StructureTemplate {
    public final String name;
    public final int xSize;
    public final int ySize;
    public final int zSize;
    public final int xOffset;
    public final int yOffset;
    public final int zOffset;
    private TemplateRule[] templateRules;
    private TemplateRuleEntity[] entityRules;
    private short[] templateData;
    List<ItemStack> resourceList;
    private StructureValidator validator;

    public StructureTemplate(String name, int xSize, int ySize, int zSize, int xOffset, int yOffset, int zOffset) {
        if (name == null) {
            throw new IllegalArgumentException("cannot have null name for structure");
        }
        this.name = name;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    public TemplateRuleEntity[] getEntityRules() {
        return this.entityRules;
    }

    public TemplateRule[] getTemplateRules() {
        return this.templateRules;
    }

    public short[] getTemplateData() {
        return this.templateData;
    }

    public StructureValidator getValidationSettings() {
        return this.validator;
    }

    public void setRuleArray(TemplateRule[] rules) {
        this.templateRules = rules;
    }

    public void setEntityRules(TemplateRuleEntity[] rules) {
        this.entityRules = rules;
    }

    public void setTemplateData(short[] datas) {
        this.templateData = datas;
    }

    public void setValidationSettings(StructureValidator settings) {
        this.validator = settings;
    }

    public TemplateRule getRuleAt(int x, int y, int z) {
        int index = StructureTemplate.getIndex(x, y, z, this.xSize, this.ySize, this.zSize);
        int ruleIndex = index >= 0 && index < this.templateData.length ? this.templateData[index] : -1;
        return ruleIndex >= 0 && ruleIndex < this.templateRules.length ? this.templateRules[ruleIndex] : null;
    }

    public static int getIndex(int x, int y, int z, int xSize, int ySize, int zSize) {
        return y * xSize * zSize + z * xSize + x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("name: ").append(this.name).append("\n");
        b.append("size: ").append(this.xSize).append(", ").append(this.ySize).append(", ").append(this.zSize).append("\n");
        b.append("buildKey: ").append(this.xOffset).append(", ").append(this.yOffset).append(", ").append(this.zOffset);
        return b.toString();
    }

    public List<ItemStack> getResourceList() {
        if (this.resourceList == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int x = 0; x < this.xSize; ++x) {
                for (int y = 0; y < this.ySize; ++y) {
                    for (int z = 0; z < this.zSize; ++z) {
                        TemplateRule rule = this.getRuleAt(x, y, z);
                        if (rule == null) continue;
                        rule.addResources(stacks);
                    }
                }
            }
            this.resourceList = InventoryTools.compactStackList3(stacks);
        }
        return this.resourceList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructureTemplate)) {
            return false;
        }
        StructureTemplate that = (StructureTemplate)o;
        return this.xSize == that.xSize && this.ySize == that.ySize && this.zSize == that.zSize && this.xOffset == that.xOffset && this.yOffset == that.yOffset && this.zOffset == that.zOffset && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.xSize;
        result = 31 * result + this.ySize;
        result = 31 * result + this.zSize;
        result = 31 * result + this.xOffset;
        result = 31 * result + this.yOffset;
        result = 31 * result + this.zOffset;
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

